/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.net;

import com.vmware.vide.utils.VIDEUtilPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IProgressMonitor;

public class NetworkHelper {
    public static final String IP_V4_REGEX = "^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$";

    public static String getIpAddress() {
        String ip = null;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (ip == null && interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                if (i.isLoopback() || !i.isUp()) continue;
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    String address = addresses.nextElement().getHostAddress();
                    if (!address.matches(IP_V4_REGEX)) continue;
                    ip = address;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static boolean isPortAvailable(int port) {
        boolean free;
        block17: {
            free = false;
            ServerSocket tcp = null;
            DatagramSocket udp = null;
            try {
                try {
                    udp = new DatagramSocket(port);
                    udp.setReuseAddress(true);
                    tcp = new ServerSocket(port);
                    tcp.setReuseAddress(true);
                    free = true;
                }
                catch (IOException iOException) {
                    if (udp != null) {
                        udp.close();
                    }
                    if (tcp != null) {
                        try {
                            tcp.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (udp != null) {
                    udp.close();
                }
                if (tcp != null) {
                    try {
                        tcp.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (udp != null) {
                udp.close();
            }
            if (tcp != null) {
                try {
                    tcp.close();
                }
                catch (IOException iOException) {}
            }
        }
        return free;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFromURL(String url) {
        String charset = "UTF-8";
        BufferedReader reader = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URLConnection connection = NetworkHelper.getUrlConnection(url);
            connection.setRequestProperty("Accept-Charset", charset);
            InputStream response = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(response, charset));
            while ((line = reader.readLine()) != null) {
                if (result == null) continue;
                result.append(line);
                result.append('\n');
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            if (reader == null) return result.toString();
            try {
                reader.close();
                return result.toString();
            }
            catch (IOException iOException) {}
            return result.toString();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                if (reader == null) return result.toString();
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                reader.close();
                return result.toString();
            }
            catch (IOException iOException) {}
            return result.toString();
        }
        if (reader == null) return result.toString();
        try {
            reader.close();
            return result.toString();
        }
        catch (IOException iOException) {}
        return result.toString();
    }

    public static Exception checkURL(String url) {
        String charset = "UTF-8";
        try {
            URLConnection connection = NetworkHelper.getUrlConnection(url);
            connection.setConnectTimeout(600000);
            connection.setReadTimeout(600000);
            connection.setRequestProperty("Accept-Charset", charset);
            connection.getInputStream();
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public static String getFileFromURL(String url, String destPath, IProgressMonitor monitor) {
        String error;
        URLConnection connection;
        block40: {
            OutputStream output;
            block42: {
                String charset = "UTF-8";
                connection = null;
                output = null;
                InputStream reader = null;
                byte[] block = new byte[4096];
                error = null;
                int checkMonitor = 0;
                try {
                    connection = NetworkHelper.getUrlConnection(url);
                    connection.setRequestProperty("Accept-Charset", charset);
                    InputStream response = connection.getInputStream();
                    reader = new BufferedInputStream(response);
                    output = new BufferedOutputStream(new FileOutputStream(destPath));
                    int nRead = 0;
                    while ((nRead = reader.read(block)) > 0) {
                        output.write(block, 0, nRead);
                        if (checkMonitor++ >= 64) {
                            if (monitor != null && monitor.isCanceled()) break;
                            checkMonitor = 0;
                        }
                        if (monitor == null) continue;
                        monitor.worked(nRead);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    error = e.getMessage();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block40;
                }
                catch (IOException e) {
                    block41: {
                        try {
                            e.printStackTrace();
                            error = e.getMessage();
                            if (reader == null) break block41;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (monitor != null) {
                                monitor.done();
                            }
                            throw throwable;
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block40;
                }
                if (reader == null) break block42;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        if (error != null && connection != null && connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            try {
                int code = httpConnection.getResponseCode();
                String msg = httpConnection.getResponseMessage();
                error = "Error " + code + " acccessing server. (" + msg + ")\nDid your session expire?";
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return error;
    }

    public static URLConnection getUrlConnection(String url) throws IOException {
        IProxyData data;
        URLConnection connection = null;
        Proxy proxy = null;
        IProxyService service = VIDEUtilPlugin.getDefault().getProxyService();
        if (service.isProxiesEnabled() && (data = service.getProxyData("HTTP")) != null) {
            String proxyHost = data.getHost();
            int proxyPort = data.getPort();
            if (proxyHost != null && proxyPort != -1) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                final String user = data.getUserId();
                final String pass = data.getPassword();
                if (user != null && pass != null) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, pass.toCharArray());
                        }
                    });
                }
            }
        }
        connection = new URL(url).openConnection(proxy == null ? Proxy.NO_PROXY : proxy);
        return connection;
    }
}

