/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.resource;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ResourceUtils {
    public static String getResourceAbsolutePath(IResource resource) {
        if (resource != null) {
            String path = new File(resource.getLocationURI()).getAbsolutePath();
            return path;
        }
        return null;
    }

    public static List<IFile> findFilesInContainer(IContainer parentFolder, String regex, boolean checkChildFolders) throws CoreException {
        return ResourceUtils.findFilesInContainer(parentFolder, regex, checkChildFolders, null);
    }

    public static List<IFile> findFilesInContainer(IContainer parentFolder, String regex, boolean checkChildFolders, Set<String> ignoreFolders) throws CoreException {
        ArrayList<IFile> results = new ArrayList<IFile>();
        if (parentFolder == null || !parentFolder.exists()) {
            return results;
        }
        ArrayList<IContainer> foldersToProcess = new ArrayList<IContainer>();
        foldersToProcess.add(parentFolder);
        while (!foldersToProcess.isEmpty()) {
            IResource[] children;
            IContainer parent = (IContainer)foldersToProcess.remove(0);
            if (parent == null) continue;
            IResource[] iResourceArray = children = parent.members();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (child instanceof IFile) {
                    IFile childFile = (IFile)child;
                    if (childFile.getName().matches(regex)) {
                        results.add(childFile);
                    }
                } else if (checkChildFolders && child instanceof IContainer && (ignoreFolders == null || !ignoreFolders.contains(child.getName()))) {
                    foldersToProcess.add((IContainer)child);
                }
                ++n2;
            }
        }
        return results;
    }

    public static IContainer[] findFileParentContainers(String fileAbsolutePath) {
        try {
            File parentFile;
            File scriptFile;
            if (fileAbsolutePath != null && (scriptFile = new File(fileAbsolutePath)).exists() && (parentFile = scriptFile.getParentFile()) != null && parentFile.exists() && parentFile.isDirectory()) {
                IWorkspaceRoot workSpaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                return workSpaceRoot.findContainersForLocationURI(parentFile.toURI());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getWorkspaceDir() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = ws.getRoot();
        IPath path = root.getLocation();
        return path.toOSString();
    }

    public static IProject findFileParentProject(String fileAbsolutePath) {
        IContainer projectContainer;
        IContainer[] parentContainers = ResourceUtils.findFileParentContainers(fileAbsolutePath);
        if (parentContainers != null && parentContainers.length != 0 && (projectContainer = parentContainers[0]) instanceof IProject) {
            return (IProject)projectContainer;
        }
        return null;
    }

    public static void refreshFileParent(String fileAbsolutePath, IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        try {
            IContainer[] parentContainers = ResourceUtils.findFileParentContainers(fileAbsolutePath);
            if (parentContainers != null) {
                IContainer[] iContainerArray = parentContainers;
                int n = parentContainers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer parent = iContainerArray[n2];
                    progressMonitor.beginTask("Refreshing parent folder", -1);
                    parent.refreshLocal(1, progressMonitor);
                    progressMonitor.done();
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static File getJavaFile(IFile file) throws CoreException {
        if (file == null) {
            return null;
        }
        URI uri = file.isLinked() ? file.getRawLocationURI() : file.getLocationURI();
        File javaFile = EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
        return javaFile;
    }

    public static File getBundleFile(String bundleId) throws IOException {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IOException("Unable to find bundle with id='" + bundleId + "'");
        }
        URL locationUrl = bundle.getEntry("/");
        URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
        String path = fileUrl.getPath();
        File bundleDir = new File(path);
        if (!bundleDir.exists()) {
            throw new IOException("Bundle directory doesn't exist '" + bundleDir.getAbsolutePath() + "'");
        }
        return bundleDir;
    }

    public static File getFileRelativeToBundle(String bundleId, String path) throws IOException {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            throw new IOException("Unable to find bundle with id='" + bundleId + "'");
        }
        if (path == null || path.isEmpty() || path.equals(".") || path.equals("./")) {
            URL locationUrl = bundle.getEntry("/");
            URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
            String bundleDirPath = fileUrl.getPath();
            File bundleDir = new File(bundleDirPath);
            if (!bundleDir.exists()) {
                throw new IOException("Bundle directory doesn't exist '" + bundleDir.getAbsolutePath() + "'");
            }
            return bundleDir;
        }
        Path epath = new Path(path);
        if (!epath.isAbsolute()) {
            URL fileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)epath, null));
            if (fileURL == null) {
                throw new IOException("Unable to locate segment '" + path + "' inside of bundle '" + bundleId + "'");
            }
            epath = new Path(fileURL.getFile());
        }
        File resolvedFile = epath.toFile();
        return resolvedFile;
    }

    public static String getBundleVersion(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle == null) {
            return null;
        }
        return bundle.getVersion().toString();
    }

    private ResourceUtils() {
    }
}

