/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.security;

import com.vmware.vide.utils.digest.DigestHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class SecurePreferencesManager {
    private static final String PASSWORD_PROVIDER_ID = "com.vmware.vide.utils.security.AutoPasswordProvider";
    private static final String MASTER_CHECK = "com.vmware.vide.utils.security.master";
    private ISecurePreferences preferences;
    private String password;

    public static SecurePreferencesManager getInstance() {
        return SecurePreferencesManagerHolder.INSTANCE;
    }

    private SecurePreferencesManager() {
    }

    private String createKey() throws NoSuchAlgorithmException {
        String value = UUID.randomUUID().toString();
        return DigestHelper.getMd5(value);
    }

    public void init(URL storage) throws URISyntaxException, IOException, StorageException, NoSuchAlgorithmException {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.equinox.security.storage.requiredID", PASSWORD_PROVIDER_ID);
        File key = new File(Platform.getConfigurationLocation().getURL().getFile(), "vmwb.key");
        if (key.canRead()) {
            FileInputStream stream = new FileInputStream(key);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                this.password = reader.readLine().trim();
            }
            this.preferences = SecurePreferencesFactory.open((URL)storage, options);
            try {
                this.preferences.get(MASTER_CHECK, null);
            }
            catch (StorageException storageException) {
                throw new SecurityException("The master key has been tampered with");
            }
        }
        this.password = this.createKey();
        this.preferences = SecurePreferencesFactory.open((URL)storage, options);
        this.preferences.clear();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(key));){
            writer.write(this.password);
        }
        this.preferences.put(MASTER_CHECK, MASTER_CHECK, true);
        this.preferences.flush();
    }

    public ISecurePreferences getSecurePreferences() {
        return this.preferences;
    }

    protected String getPassword() {
        return this.password;
    }

    /* synthetic */ SecurePreferencesManager(SecurePreferencesManager securePreferencesManager) {
        this();
    }

    private static class SecurePreferencesManagerHolder {
        private static final SecurePreferencesManager INSTANCE = new SecurePreferencesManager(null);

        private SecurePreferencesManagerHolder() {
        }
    }
}

