/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.timer;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimerUtils {
    private static long startTime = 0L;

    public static void start() {
        startTime = Calendar.getInstance().getTimeInMillis();
    }

    public static void report() {
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.println("elapsed time: " + (endTime - startTime) + " ms.");
    }

    public static void report(String prefix, String suffix) {
        if (prefix != null) {
            System.out.print(prefix);
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.print("elapsed time: " + (endTime - startTime) + " ms.");
        if (suffix != null) {
            System.out.print(suffix);
        }
        System.out.println();
    }

    public static void stop() {
        if (startTime == 0L) {
            return;
        }
        long endTime = Calendar.getInstance().getTimeInMillis();
        System.out.println("Elapsed Time: " + (endTime - startTime) + "(ms)");
        startTime = 0L;
    }

    public static String getCurrentTimeStr() {
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss");
        String timeStr = dateFormat.format(now);
        return timeStr;
    }

    public static void trace(String message) {
        Date now = Calendar.getInstance().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm:ss:SS");
        String timeStr = dateFormat.format(now);
        System.out.println(String.valueOf(timeStr) + ": " + message);
    }

    public static String getTimeStr(long ms, boolean includeMs) {
        long seconds = ms / 1000L;
        long ss = seconds % 60L;
        long mm = seconds / 60L % 60L;
        long hh = seconds / 3600L;
        long ms2 = ms - seconds * 1000L;
        String format = "{0,number,##00}:{1,number,##00}:{2,number,##00}";
        if (includeMs) {
            format = String.valueOf(format) + ".{3,number,##000}";
        }
        String str = MessageFormat.format(format, hh, mm, ss, ms2);
        return str;
    }
}

