/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.xml;

import com.vmware.vide.utils.xml.XMLParser;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static final String XML_START_COMMENT = "<!--";
    public static final String XML_END_COMMENT = "-->";
    public static final String XML_START_COMMENT_REPLACEMENT_TAG = "<comment>";
    public static final String XML_END_COMMENT_REPLACEMENT_TAG = "</comment>";

    public static ArrayList<Node> getAllChildrenNamed(String name, Node parent) {
        ArrayList<Node> list = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String tag;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && (tag = node.getNodeName()).equals(name)) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    public static Node getChildNamed(String id, Node parent) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeName().equals(id)) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public static String getChildValue(String id, Node parent) {
        Node n = XMLUtil.getChildNamed(id, parent);
        if (n == null) {
            return "";
        }
        return XMLUtil.getTextNodeValue(n);
    }

    public static boolean isTextNode(Node node) {
        if (node.getFirstChild() == null) {
            return false;
        }
        return node.getFirstChild().getNodeType() == 3;
    }

    public static String getTextNodeValue(Node node) {
        if (!XMLUtil.isTextNode(node)) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public static int getColumnWidth(Node pageNode, String colName) {
        int width = -1;
        if (pageNode == null || colName == null) {
            return -1;
        }
        ArrayList<Node> cols = XMLUtil.getAllChildrenNamed("column", pageNode);
        for (Node n : cols) {
            String id;
            String name = XMLUtil.getChildValue("id", n);
            if (name == null || !name.equals(colName) || (id = XMLUtil.getChildValue("width", n)) == null || id.isEmpty()) continue;
            width = Integer.parseInt(id);
            break;
        }
        return width;
    }

    public static void setColumnWidth(Document myDoc, Node pageNode, String colName, int width) {
        ArrayList<Node> cols = XMLUtil.getAllChildrenNamed("column", pageNode);
        Node columnNode = null;
        for (Node n : cols) {
            String name = XMLUtil.getChildValue("id", n);
            if (name == null || !name.equals(colName)) continue;
            columnNode = n;
            break;
        }
        if (columnNode == null) {
            columnNode = myDoc.createElement("column");
            pageNode.appendChild(columnNode);
            XMLParser.createTextElementAndValue(myDoc, columnNode, "id", colName);
        }
        Node widthNode = XMLUtil.getChildNamed("width", columnNode);
        String w = Integer.toString(width);
        if (widthNode == null) {
            XMLParser.createTextElementAndValue(myDoc, columnNode, "width", w);
        } else {
            XMLParser.replaceNodeValue(myDoc, widthNode, w, true, true);
        }
    }

    public static String storeComments(String xmlString, String startXMLTAG) {
        StringBuffer sb = new StringBuffer(xmlString);
        int start = sb.indexOf(startXMLTAG);
        if (start < 0) {
            return xmlString;
        }
        int startComment = sb.indexOf(XML_START_COMMENT, start);
        while (startComment > 0) {
            sb.replace(startComment, startComment + XML_START_COMMENT.length(), XML_START_COMMENT_REPLACEMENT_TAG);
            int endComment = sb.indexOf(XML_END_COMMENT, startComment + XML_START_COMMENT.length());
            sb.replace(endComment, endComment + XML_END_COMMENT.length(), XML_END_COMMENT_REPLACEMENT_TAG);
            startComment = sb.indexOf(XML_START_COMMENT, endComment);
        }
        return sb.toString();
    }

    public static String restoreComments(String xmlString) {
        xmlString = xmlString.replace(XML_START_COMMENT_REPLACEMENT_TAG, XML_START_COMMENT);
        xmlString = xmlString.replace(XML_END_COMMENT_REPLACEMENT_TAG, XML_END_COMMENT);
        return xmlString;
    }

    public static void insertNodes(Node node, List<Node> nodes, Node refNode) {
        if (!nodes.isEmpty()) {
            for (Node n : nodes) {
                node.insertBefore(n, refNode);
            }
            nodes.clear();
        }
    }

    public static void appendNodes(Node node, List<Node> nodes) {
        if (!nodes.isEmpty()) {
            for (Node n : nodes) {
                node.appendChild(n);
            }
            nodes.clear();
        }
    }
}

