/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class XmlPrettyPrinter {
    public static void formatXml(InputStream inputStream, OutputStream outputStream, boolean includeXmlDeclaration) throws Exception {
        Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
        serializer.setOutputProperty("indent", "yes");
        if (!includeXmlDeclaration) {
            serializer.setOutputProperty("omit-xml-declaration", "yes");
        }
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        SAXSource xmlSource = new SAXSource(new InputSource(inputStream));
        StreamResult res = new StreamResult(outputStream);
        serializer.transform(xmlSource, res);
    }

    public static String formatXml(String xml, boolean includeXmlDeclaration) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlPrettyPrinter.formatXml(inputStream, outputStream, includeXmlDeclaration);
        return new String(outputStream.toByteArray());
    }

    public static void formatXml(File inputXmlFile, File outputXmlFile, boolean includeXmlDeclaration) throws Exception {
        FileInputStream inputStream = null;
        try (OutputStream outputStream = null;){
            inputStream = new FileInputStream(inputXmlFile);
            outputStream = new FileOutputStream(outputXmlFile);
            XmlPrettyPrinter.formatXml(inputStream, outputStream, includeXmlDeclaration);
        }
    }

    public static void formatXml(String xmlFileAsString, File outputXmlFile, boolean includeXmlDeclaration) throws Exception {
        ByteArrayInputStream inputStream = null;
        try (OutputStream outputStream = null;){
            inputStream = new ByteArrayInputStream(xmlFileAsString.getBytes());
            outputStream = new FileOutputStream(outputXmlFile);
            XmlPrettyPrinter.formatXml(inputStream, outputStream, includeXmlDeclaration);
        }
    }

    private XmlPrettyPrinter() {
    }
}

