/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.StatusException;
import com.vmware.vide.p2action.vIDEInstallHelper;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupcopyAction;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CopyAction;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;

public class CopyFileAction
extends ProvisioningAction {
    private static final String ID = "copyfile";
    private static final String IGNORE_EXISTING_OPT = "ignoreexisting";

    public IStatus execute(Map<String, Object> parameters) {
        Map<String, Object> newParams = vIDEInstallHelper.replaceSourcePath(parameters);
        vIDEInstallHelper.updateTargetParam(newParams);
        try {
            if (this.checkIgnoreExistingOption(newParams)) {
                return Status.OK_STATUS;
            }
        }
        catch (StatusException e) {
            return e.getStatus();
        }
        return CopyAction.copy(newParams, (boolean)true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        Map<String, Object> newParams = vIDEInstallHelper.replaceSourcePath(parameters);
        vIDEInstallHelper.updateTargetParam(newParams);
        return CleanupcopyAction.cleanupcopy(newParams, (boolean)false);
    }

    private boolean checkIgnoreExistingOption(Map<String, Object> parameters) throws StatusException {
        File sourceFile;
        String ignoreExisting = (String)parameters.get(IGNORE_EXISTING_OPT);
        if (ignoreExisting == null) {
            return false;
        }
        if (Boolean.valueOf(ignoreExisting) == Boolean.FALSE) {
            return false;
        }
        String overWrite = (String)parameters.get("overwrite");
        if (Boolean.valueOf(overWrite).booleanValue()) {
            String msg = String.format("The [%s] action specified the option [%s] with [%s].", ID, IGNORE_EXISTING_OPT, "overwrite");
            throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
        }
        String source = (String)parameters.get("source");
        if (source == null) {
            String msg = String.format("The [%s] was not set in the [%s] action.", "source", ID);
            throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
        }
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                String msg = String.format("The [%s] artifact is not available.", artifactKey.getId());
                throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
            }
            source = artifactLocation;
        }
        if ((sourceFile = new File(source)).exists() && sourceFile.isDirectory()) {
            String msg = String.format("The [%s] does not support that the source is a directory in the [%s] action.", IGNORE_EXISTING_OPT, ID);
            throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
        }
        if (!sourceFile.isFile()) {
            String msg = String.format("The [%s] source file does not exist in the [%s] action.", sourceFile.getAbsolutePath(), ID);
            throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
        }
        String target = (String)parameters.get("target");
        if (target == null) {
            String msg = String.format("The [%s] was not set in the [%s] action.", "target", ID);
            throw new StatusException(new Status(4, "com.vmware.vide.p2action", 0, msg, null));
        }
        File targetFile = new File(target);
        return targetFile.exists();
    }
}

