/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;

public class ReplaceAction
extends ProvisioningAction {
    private static final String ID = "replace";
    private static final String PLUGIN_ID = "com.vmware.vide.p2action";
    private static final String PARAM_TARGET_DIR = "targetDir";
    private static final String PARAM_TARGET_FILE = "targetFile";
    private static final String PARAM_PATTERN = "pattern";
    private static final String PARAM_REPLACEMENT = "replacement";
    private static final String PARAM_SUBDIRS_POSTFIX = "...";
    private static final String ERR_MISSING_PARAMETER = "Missing parameter [%s]";
    private static final String ERR_MULTIPLE_ERRORS = "Multiple errors on replacing action";
    private static final String ERR_NOT_ABSOLUTE_PATH = "Specified path [%s] is not absolute path";
    private static final String ERR_NO_TARGET_DIR = "Cannot find target directory [%s].";
    private static final String WARN_BINARY_FILE = "Binary file [%s] is specified.";
    private static final String WARN_MULTIPLE_WARNINGS = "Multiple warnings on replacing action";
    private static final String ERR_MISSING_REPLACEMENT_FOR_PATTERN = "Missing the replacement [%s] for the pattern [%s].";
    private static final String ERR_MISSING_PATTERN_FOR_REPLACEMENT = "Missing the pattern [%s] for the replacement [%s].";
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private SortedMap<String, String> replacements = new TreeMap<String, String>();
    private boolean subdirs = false;
    private File[] targetFiles;

    public IStatus execute(Map parameters) {
        this.parseParameters(parameters);
        if (this.isError()) {
            return this.createErrorStatus();
        }
        this.replace();
        if (this.isError()) {
            return this.createErrorStatus();
        }
        if (!this.warnings.isEmpty()) {
            return this.createWarningStatus();
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map parameters) {
        return Status.OK_STATUS;
    }

    private IStatus createErrorStatus() {
        if (this.errors.size() > 1) {
            IStatus[] stats = new IStatus[this.errors.size() + this.warnings.size()];
            int i = 0;
            while (i < this.errors.size()) {
                stats[i] = new Status(4, PLUGIN_ID, this.errors.get(i));
                ++i;
            }
            i = 0;
            while (i < this.warnings.size()) {
                stats[this.errors.size() + i] = new Status(2, PLUGIN_ID, this.warnings.get(i));
                ++i;
            }
            return new MultiStatus(PLUGIN_ID, 4, stats, ERR_MULTIPLE_ERRORS, (Throwable)new Exception());
        }
        return new Status(4, PLUGIN_ID, this.errors.get(0));
    }

    private IStatus createWarningStatus() {
        if (this.warnings.size() > 1) {
            IStatus[] stats = new IStatus[this.warnings.size()];
            int i = 0;
            while (i < stats.length) {
                stats[i] = new Status(2, PLUGIN_ID, this.warnings.get(i));
                ++i;
            }
            return new MultiStatus(PLUGIN_ID, 2, stats, WARN_MULTIPLE_WARNINGS, (Throwable)new Exception());
        }
        return new Status(2, PLUGIN_ID, this.warnings.get(0));
    }

    private void parseParameters(Map<?, ?> parameters) {
        File[] rootTargetDirs;
        String targetDir = (String)parameters.get(PARAM_TARGET_DIR);
        String targetFile = (String)parameters.get(PARAM_TARGET_FILE);
        if (targetDir == null || targetDir.isEmpty()) {
            this.errors.add(String.format(ERR_MISSING_PARAMETER, PARAM_TARGET_DIR));
        }
        if (targetFile == null || targetFile.isEmpty()) {
            this.errors.add(String.format(ERR_MISSING_PARAMETER, PARAM_TARGET_FILE));
        }
        if (this.isError()) {
            return;
        }
        this.getReplacementsFromParameters(parameters);
        Path pathDir = new Path(targetDir);
        if (!pathDir.isAbsolute()) {
            this.errors.add(String.format(ERR_NOT_ABSOLUTE_PATH, targetDir));
            return;
        }
        if (pathDir.lastSegment().equals(PARAM_SUBDIRS_POSTFIX)) {
            targetDir = targetDir.substring(0, targetDir.length() - PARAM_SUBDIRS_POSTFIX.length());
            pathDir = pathDir.removeLastSegments(1);
            this.subdirs = true;
        }
        if ((rootTargetDirs = this.getRootTargetDirs((IPath)pathDir)).length == 0) {
            this.errors.add(String.format(ERR_NO_TARGET_DIR, targetDir));
            return;
        }
        this.targetFiles = this.searchTargetFiles(rootTargetDirs, targetFile);
    }

    private boolean isError() {
        return !this.errors.isEmpty();
    }

    private File[] searchTargetFiles(File[] rootTargetDirs, String targetFile) {
        Pattern filePattern = Pattern.compile(this.convertFilespecToRegexp(targetFile));
        ArrayList<File> files = this._findFiles(rootTargetDirs, filePattern);
        return files.toArray(new File[files.size()]);
    }

    private ArrayList<File> _findFiles(File[] dirs, final Pattern filePattern) {
        final ArrayList<File> files = new ArrayList<File>();
        FileFilter fileMatchFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    Matcher m = filePattern.matcher(pathname.getName());
                    if (!m.matches()) {
                        return false;
                    }
                    if (ReplaceAction.this.isBinaryFile(pathname)) {
                        ReplaceAction.this.warnings.add(String.format(ReplaceAction.WARN_BINARY_FILE, pathname.getAbsolutePath()));
                        return false;
                    }
                    files.add(pathname);
                    return true;
                }
                return false;
            }
        };
        FileFilter dirFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        };
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File d = fileArray[n2];
            d.listFiles(fileMatchFilter);
            if (this.isSubDirs()) {
                File[] sdirs = d.listFiles(dirFilter);
                files.addAll(this._findFiles(sdirs, filePattern));
            }
            ++n2;
        }
        return files;
    }

    private boolean isSubDirs() {
        return this.subdirs;
    }

    private File[] getRootTargetDirs(IPath p) {
        ArrayList<File> currentFiles = new ArrayList<File>();
        currentFiles.add(new File(Path.ROOT.toOSString()));
        int i = 0;
        while (i < p.segmentCount()) {
            ArrayList<File> nextFiles = new ArrayList<File>();
            final Pattern segPattern = Pattern.compile(this.convertFilespecToRegexp(p.segment(i)));
            FileFilter segmentMatchFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    Matcher m;
                    return pathname.isDirectory() && (m = segPattern.matcher(pathname.getName())).matches();
                }
            };
            for (File f : currentFiles) {
                File[] nextLevel;
                File[] fileArray = nextLevel = f.listFiles(segmentMatchFilter);
                int n = nextLevel.length;
                int n2 = 0;
                while (n2 < n) {
                    File nextFile = fileArray[n2];
                    nextFiles.add(nextFile);
                    ++n2;
                }
            }
            currentFiles = nextFiles;
            ++i;
        }
        return currentFiles.toArray(new File[currentFiles.size()]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private String convertFilespecToRegexp(String filespec) {
        StringBuffer sb = new StringBuffer();
        ArrayList<Range> indexes = new ArrayList<Range>();
        int index = 0;
        block13: while (index < filespec.length()) {
            char c = filespec.charAt(index);
            switch (c) {
                case '\\': {
                    if (index + 1 >= filespec.length()) break;
                    c = filespec.charAt(++index);
                    break;
                }
                case '*': {
                    indexes.add(new Range(sb.length()));
                    break;
                }
                case '?': {
                    indexes.add(new Range(sb.length()));
                    break;
                }
                case '[': {
                    if (index + 2 >= filespec.length()) break;
                    int end = this.searchForChar(filespec, ']', index + 1);
                    if (end <= index + 1) continue block13;
                    int start = sb.length();
                    sb.append(filespec.substring(index, end + 1));
                    indexes.add(new Range(start, sb.length()));
                    index = end + 1;
                    continue block13;
                }
                case '(': {
                    if (index + 3 >= filespec.length()) break;
                    int end = this.searchForChar(filespec, ')', index + 1);
                    if (end <= index + 2) continue block13;
                    int start = sb.length();
                    sb.append(filespec.substring(index, end + 1));
                    indexes.add(new Range(start, sb.length()));
                    index = end + 1;
                    continue block13;
                }
            }
            sb.append(c);
            ++index;
        }
        StringBuffer regexp = new StringBuffer();
        index = 0;
        for (Range r : indexes) {
            regexp.append(Pattern.quote(sb.substring(index, r.start)));
            switch (sb.charAt(r.start)) {
                case '*': {
                    regexp.append(".*");
                    break;
                }
                case '?': {
                    regexp.append('.');
                    break;
                }
                case '[': {
                    regexp.append(sb.subSequence(r.start, r.end));
                    break;
                }
                case '(': {
                    regexp.append(sb.subSequence(r.start, r.end));
                    break;
                }
            }
            index = r.end;
        }
        regexp.append(Pattern.quote(sb.substring(index)));
        return regexp.toString();
    }

    private int searchForChar(String str, char c, int index) {
        while (index < str.length()) {
            if (str.charAt(index) == c) {
                return index;
            }
            if (str.charAt(index) == '\\') {
                ++index;
            }
            ++index;
        }
        return -1;
    }

    private boolean isBinaryFile(File file) {
        block18: {
            FileReader fr = null;
            char[] cbuf = new char[4096];
            try {
                int len;
                fr = new FileReader(file);
                while ((len = fr.read(cbuf)) > 0) {
                    int i = 0;
                    while (i < len) {
                        if (!Character.isDefined(cbuf[i])) {
                            return true;
                        }
                        try {
                            ++i;
                            continue;
                        }
                        catch (Exception e) {
                            this.warnings.add(e.getMessage());
                        }
                        break block18;
                    }
                }
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.warnings.add(e.getMessage());
                }
            }
        }
        return false;
    }

    private boolean isPatternParam(String p) {
        return p.startsWith(PARAM_PATTERN);
    }

    private String getPatternPostfix(String p) {
        return p.substring(PARAM_PATTERN.length());
    }

    private boolean isReplacementParam(String p) {
        return p.startsWith(PARAM_REPLACEMENT);
    }

    private String getReplacementPostfix(String p) {
        return p.substring(PARAM_REPLACEMENT.length());
    }

    private void getReplacementsFromParameters(Map<?, ?> parameters) {
        String k;
        Set<?> keys = parameters.keySet();
        for (Object o : keys) {
            if (!(o instanceof String) || !this.isPatternParam(k = (String)o)) continue;
            String replacementParam = PARAM_REPLACEMENT + this.getPatternPostfix(k);
            if (keys.contains(replacementParam)) {
                this.replacements.put((String)parameters.get(k), (String)parameters.get(replacementParam));
                continue;
            }
            this.errors.add(String.format(ERR_MISSING_REPLACEMENT_FOR_PATTERN, replacementParam, k));
        }
        if (this.replacements.isEmpty()) {
            this.errors.add(String.format(ERR_MISSING_PARAMETER, PARAM_PATTERN));
        }
        for (Object o : parameters.keySet()) {
            String patternParam;
            if (!(o instanceof String) || !this.isReplacementParam(k = (String)o) || keys.contains(patternParam = PARAM_PATTERN + this.getReplacementPostfix(k))) continue;
            this.errors.add(String.format(ERR_MISSING_PATTERN_FOR_REPLACEMENT, patternParam, k));
        }
    }

    private void replace() {
        File[] fileArray = this.targetFiles;
        int n = this.targetFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            List<String> lines = this.getReplacedLines(f);
            this.writeFile(f, lines);
            ++n2;
        }
    }

    private List<String> getReplacedLines(File f) {
        ArrayList<String> lines = new ArrayList<String>(1000);
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(f));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    for (Map.Entry<String, String> e : this.replacements.entrySet()) {
                        line = line.replaceAll(e.getKey(), e.getValue());
                    }
                    lines.add(line);
                }
            }
            catch (FileNotFoundException e) {
                this.errors.add(e.getMessage());
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    this.errors.add(e2.getMessage());
                }
            }
            catch (IOException e) {
                this.errors.add(e.getMessage());
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e3) {
                    this.errors.add(e3.getMessage());
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                this.errors.add(e.getMessage());
            }
        }
        return lines;
    }

    private void writeFile(File f, List<String> lines) {
        BufferedWriter writer = null;
        try {
            try {
                writer = new BufferedWriter(new FileWriter(f));
                for (String line : lines) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                this.errors.add(e.getMessage());
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e2) {
                    this.errors.add(e2.getMessage());
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                this.errors.add(e.getMessage());
            }
        }
    }

    private class Range {
        int start;
        int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        Range(int start) {
            this(start, start + 1);
        }
    }
}

