/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlinkAction
extends ProvisioningAction {
    private static final Logger logger = LoggerFactory.getLogger(UnlinkAction.class);
    private static final String ID = "unlink";
    private List<SymlinkPair> unlinkedLinks = new ArrayList<SymlinkPair>(1);

    private static IStatus logAndCreateStatusError(String message, Throwable e) {
        logger.error(message, e);
        return new Status(4, "com.vmware.vide.p2action", message);
    }

    public IStatus execute(Map<String, Object> parameters) {
        Path link;
        String pathString = (String)parameters.get("path");
        if (pathString == null) {
            return new Status(4, "com.vmware.vide.p2action", 0, this.formatParamErrorMessage("path"), null);
        }
        try {
            link = Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            return UnlinkAction.logAndCreateStatusError("Invalid path string passed to unlink: '" + pathString + "'.", e);
        }
        if (Files.isSymbolicLink(link)) {
            try {
                Path target = Files.readSymbolicLink(link);
                logger.info("Unlinking '{}'", (Object)link);
                Files.delete(link);
                this.unlinkedLinks.add(new SymlinkPair(target, link));
            }
            catch (IOException e) {
                logger.error("Exception while trying to unlink '{}'. Happily ignoring.", (Object)link, (Object)e);
            }
        } else {
            logger.info("Attempt to unlink '{}' which is not a symlink.  Happily ignoring.", (Object)link);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        Path link;
        String pathString = (String)parameters.get("path");
        if (pathString == null) {
            return new Status(4, "com.vmware.vide.p2action", 0, this.formatParamErrorMessage("path"), null);
        }
        try {
            link = Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            return UnlinkAction.logAndCreateStatusError("Invalid path passed to unlink: '" + pathString + "'.", e);
        }
        for (SymlinkPair p : this.unlinkedLinks) {
            if (!p.LINK.equals(link)) continue;
            return this.createSymlink(p);
        }
        return Status.OK_STATUS;
    }

    private String formatParamErrorMessage(String paramName) {
        return "Parameter " + paramName + " is not set in the p2.inf call to " + ID;
    }

    private IStatus createSymlink(SymlinkPair p) {
        try {
            if (Files.isSymbolicLink(p.LINK)) {
                try {
                    Files.delete(p.LINK);
                }
                catch (IOException e) {
                    logger.error("Exception while trying to unlink '{}'. Happily ignoring.", (Object)p.LINK, (Object)e);
                }
            }
            Files.createSymbolicLink(p.LINK, p.TARGET, new FileAttribute[0]);
            logger.info("unlink created symlink due to undo: '{}' > '{}'", (Object)p.LINK, (Object)p.TARGET);
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return UnlinkAction.logAndCreateStatusError("Exception creating symlink link='" + p.LINK + "' existing='" + p.TARGET + "'.", e);
        }
    }

    private static class SymlinkPair {
        public final Path TARGET;
        public final Path LINK;

        public SymlinkPair(Path target, Path link) {
            this.TARGET = target;
            this.LINK = link;
        }
    }
}

