/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action;

import com.vmware.vide.p2action.CleanupUntarAction;
import com.vmware.vide.p2action.P2ActionPlugin;
import com.vmware.vide.p2action.vIDEInstallHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;

public class UntarAction
extends ProvisioningAction {
    private static final ILog logger = P2ActionPlugin.getInstance().getLog();
    private static final byte[] GZIP_MAGIC = new byte[]{31, -117};
    private static final int GZIP_MAGIC_OFFSET = 0;
    private static final int GZIP_MIN_HEADER_SIZE = 10;
    private static final byte[] PAX_USTAR_MAGIC;
    private static final int PAX_USTAR_MAGIC_OFFSET = 257;
    private static final byte[] GNU_TAR_MAGIC;
    private static final int GNU_TAR_MAGIC_OFFSET = 257;
    private static final int TAR_MIN_HEADER_SIZE = 512;
    private static final String READ_IO_ERROR_MSG = "I/O Error on reading the archive file [%s].";
    public static final char SYMLINK_MARKER = '*';

    static {
        byte[] byArray = new byte[6];
        byArray[0] = 117;
        byArray[1] = 115;
        byArray[2] = 116;
        byArray[3] = 97;
        byArray[4] = 114;
        PAX_USTAR_MAGIC = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 117;
        byArray2[1] = 115;
        byArray2[2] = 116;
        byArray2[3] = 97;
        byArray2[4] = 114;
        byArray2[5] = 32;
        byArray2[6] = 32;
        GNU_TAR_MAGIC = byArray2;
    }

    public IStatus execute(Map<String, Object> parameters) {
        return UntarAction.untar(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return CleanupUntarAction.cleanupUntar(parameters, false);
    }

    public static String getUntaredFilesKey(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder("untared");
        sb.append("|");
        sb.append((String)params.get("source"));
        sb.append("|");
        String target = (String)params.get("target");
        if (target == null) {
            target = "null";
        }
        sb.append(target);
        return sb.toString();
    }

    public static IStatus untar(Map<String, Object> params, boolean restoreable) {
        String tarPath = null;
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        newParams.putAll(params);
        try {
            tarPath = vIDEInstallHelper.resolveSourcePath(newParams, "/tar");
        }
        catch (IOException e) {
            return new Status(4, "com.vmware.vide.p2action", "Failed to resolve the source path.", (Throwable)e);
        }
        newParams.put("source", tarPath);
        try {
            vIDEInstallHelper.resolveTargetPath(newParams, (String)params.get("source"));
        }
        catch (RuntimeException e) {
            if (e.getMessage().startsWith("Canceled by the user")) {
                return new Status(8, "com.vmware.vide.p2action", e.getMessage());
            }
            return new Status(4, "com.vmware.vide.p2action", "Failed to resolve the target location.", (Throwable)e);
        }
        IStatus status = UntarAction.untar(newParams, restoreable, UntarAction.getUntaredFilesKey(params));
        if (status.isOK()) {
            try {
                vIDEInstallHelper.propagateTargetLocation(newParams);
            }
            catch (Exception e) {
                logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", e.getMessage()));
            }
        }
        return status;
    }

    private static IStatus untar(Map<String, Object> params, boolean restoreable, String untaredFilesKey) {
        IInstallableUnit iu = (IInstallableUnit)params.get("iu");
        Profile profile = (Profile)params.get("profile");
        String source = (String)params.get("source");
        String target = (String)params.get("target");
        IBackupStore store = restoreable ? (IBackupStore)params.get("backup") : null;
        boolean ignoreSymlink = Boolean.parseBoolean((String)params.get("ignoreSymlink"));
        File srcFile = new File(source);
        TarInputStream tis = null;
        try {
            try {
                if (UntarAction.isGZipTarFile(srcFile)) {
                    tis = new TarInputStream((InputStream)new GZIPInputStream(new FileInputStream(srcFile)));
                } else if (UntarAction.isTarFile(srcFile)) {
                    tis = new TarInputStream((InputStream)new FileInputStream(srcFile));
                }
                ArrayList<File> files = new ArrayList<File>();
                ArrayList<File> symlinkFiles = new ArrayList<File>();
                UntarAction.untar(tis, new File(target), store, ignoreSymlink, files, symlinkFiles);
                StringBuilder sb = new StringBuilder();
                for (File f : symlinkFiles) {
                    sb.append('*').append(f.getAbsolutePath()).append("|");
                }
                for (File f : files) {
                    sb.append(f.getAbsolutePath()).append("|");
                }
                profile.setInstallableUnitProperty(iu, untaredFilesKey, sb.toString());
            }
            catch (Exception e) {
                Status status = new Status(4, "com.vmware.vide.p2action", e.getMessage());
                if (tis != null) {
                    try {
                        tis.close();
                    }
                    catch (IOException e2) {
                        logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", e2.getMessage()));
                    }
                }
                return status;
            }
        }
        finally {
            if (tis != null) {
                try {
                    tis.close();
                }
                catch (IOException e) {
                    logger.log((IStatus)new Status(4, "com.vmware.vide.p2action", e.getMessage()));
                }
            }
        }
        return new Status(0, "com.vmware.vide.p2action", String.format("%s is untared in %s.", srcFile.getName(), target));
    }

    private static void untar(TarInputStream tis, File target, IBackupStore store, boolean ignoreSymlink, List<File> files, List<File> symlinkFiles) throws Exception {
        TarEntry entry = null;
        boolean isLinkSupported = vIDEInstallHelper.checkLinkSupported();
        target = target.getCanonicalFile();
        while ((entry = tis.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                File dir = new File(target, entry.getName());
                if (!dir.exists()) {
                    dir.mkdirs();
                } else if (!dir.isDirectory()) {
                    if (store != null) {
                        store.backup(dir);
                    }
                    dir.delete();
                    dir = new File(target, entry.getName());
                    dir.mkdirs();
                }
                files.add(dir);
                continue;
            }
            File file = new File(target, entry.getName());
            if (file.exists()) {
                if (store != null) {
                    store.backup(file);
                }
                file.delete();
            } else {
                file.getParentFile().mkdirs();
            }
            if (!entry.getLinkName().isEmpty()) {
                boolean symlink = UntarAction.isSymbolicLink(entry);
                if (!isLinkSupported) {
                    if (ignoreSymlink) {
                        String msg = String.format("Ignored symbolic link [%s -> %s].", entry.getName(), entry.getLinkName());
                        logger.log((IStatus)new Status(2, "com.vmware.vide.p2action", msg));
                        continue;
                    }
                    throw new UnsupportedOperationException("Symbolic link is not supported.");
                }
                vIDEInstallHelper.mklink(target, entry.getName(), entry.getLinkName(), symlink);
                if (!symlink) continue;
                symlinkFiles.add(file);
                continue;
            }
            file.createNewFile();
            try (FileOutputStream fos = null;){
                fos = new FileOutputStream(file);
                tis.copyEntryContents((OutputStream)fos);
            }
            UntarAction.setAttributes(entry, file);
            files.add(file);
        }
    }

    private static void setAttributes(TarEntry entry, File file) {
        int mod = entry.getMode();
        List<Object> warnings = null;
        try {
            if (!file.setExecutable((mod & 0x40) != 0, (mod & 1) == 0)) {
                warnings = UntarAction.addSetAttributesWarnings(warnings, "Failed to change executable mode");
            }
        }
        catch (Exception e) {
            warnings = UntarAction.addSetAttributesWarnings(warnings, e);
        }
        try {
            if (!file.setWritable((mod & 0x80) != 0, (mod & 2) == 0)) {
                warnings = UntarAction.addSetAttributesWarnings(warnings, "Failed to change writable mode.");
            }
        }
        catch (Exception e) {
            warnings = UntarAction.addSetAttributesWarnings(warnings, e);
        }
        try {
            if (!file.setReadable((mod & 0x100) != 0, (mod & 4) == 0)) {
                warnings = UntarAction.addSetAttributesWarnings(warnings, "Failed to change readable mode.");
            }
        }
        catch (Exception e) {
            warnings = UntarAction.addSetAttributesWarnings(warnings, e);
        }
        try {
            if (!file.setLastModified(entry.getModTime().getTime())) {
                warnings = UntarAction.addSetAttributesWarnings(warnings, "Failed to change modified time.");
            }
        }
        catch (Exception e) {
            warnings = UntarAction.addSetAttributesWarnings(warnings, e);
        }
        if (warnings != null) {
            UntarAction.logSetAttributeWarnings(file, warnings);
        }
    }

    private static void logSetAttributeWarnings(File file, List<Object> warnings) {
        if (warnings.isEmpty()) {
            return;
        }
        MultiStatus status = new MultiStatus("com.vmware.vide.p2action", 2, String.format("Failed to set attribute(s) on %s.", file.getAbsolutePath()), null);
        for (Object o : warnings) {
            if (o instanceof Exception) {
                status.add((IStatus)new Status(2, "com.vmware.vide.p2action", null, (Throwable)((Exception)o)));
                continue;
            }
            if (!(o instanceof String)) continue;
            status.add((IStatus)new Status(2, "com.vmware.vide.p2action", (String)o));
        }
        logger.log((IStatus)status);
    }

    private static List<Object> addSetAttributesWarnings(List<Object> warnings, Object e) {
        if (warnings == null) {
            warnings = new ArrayList<Object>();
        }
        warnings.add(e);
        return warnings;
    }

    private static boolean isTarFile(File f) {
        byte[] b = null;
        try {
            b = UntarAction.readBytes(f, 512);
        }
        catch (IOException e) {
            ILog log = P2ActionPlugin.getInstance().getLog();
            Status status = new Status(4, "com.vmware.vide.p2action", String.format(READ_IO_ERROR_MSG, f.getName()), (Throwable)e);
            log.log((IStatus)status);
            return false;
        }
        if (b == null) {
            return false;
        }
        return UntarAction.compareBytes(b, 257, GNU_TAR_MAGIC) || UntarAction.compareBytes(b, 257, PAX_USTAR_MAGIC);
    }

    private static boolean isGZipFile(File f) {
        byte[] b = null;
        try {
            b = UntarAction.readBytes(f, 10);
        }
        catch (IOException e) {
            ILog log = P2ActionPlugin.getInstance().getLog();
            Status status = new Status(4, "com.vmware.vide.p2action", String.format(READ_IO_ERROR_MSG, f.getName()), (Throwable)e);
            log.log((IStatus)status);
            return false;
        }
        if (b == null) {
            return false;
        }
        return UntarAction.compareBytes(b, 0, GZIP_MAGIC);
    }

    /*
     * Loose catch block
     */
    public static boolean isGZipTarFile(File f) {
        if (UntarAction.isGZipFile(f)) {
            byte[] b;
            block18: {
                GZIPInputStream gzis;
                block16: {
                    block17: {
                        gzis = null;
                        b = null;
                        gzis = new GZIPInputStream(new FileInputStream(f));
                        b = new byte[512];
                        int n = gzis.read(b);
                        if (n >= 512) break block16;
                        if (gzis == null) break block17;
                        try {
                            gzis.close();
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    return false;
                    catch (IOException e) {
                        try {
                            ILog log = P2ActionPlugin.getInstance().getLog();
                            Status status = new Status(4, "com.vmware.vide.p2action", String.format(READ_IO_ERROR_MSG, f.getName()), (Throwable)e);
                            log.log((IStatus)status);
                            if (gzis == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (gzis != null) {
                                try {
                                    gzis.close();
                                }
                                catch (IOException iOException) {
                                    return false;
                                }
                            }
                            throw throwable;
                        }
                        try {
                            gzis.close();
                            break block18;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                }
                if (gzis != null) {
                    try {
                        gzis.close();
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            }
            if (b == null) {
                return false;
            }
            return UntarAction.compareBytes(b, 257, GNU_TAR_MAGIC) || UntarAction.compareBytes(b, 257, PAX_USTAR_MAGIC);
        }
        return false;
    }

    private static byte[] readBytes(File f, int num) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] b = new byte[num];
            int n = fis.read(b);
            if (n < num) {
                return null;
            }
            byte[] byArray = b;
            return byArray;
        }
    }

    private static boolean compareBytes(byte[] buff, int offset, byte[] pattern) {
        byte[] byArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (offset >= buff.length) {
                return false;
            }
            if (buff[offset] != b) {
                return false;
            }
            ++offset;
            ++n2;
        }
        return true;
    }

    private static boolean isSymbolicLink(TarEntry entry) {
        Field[] fields;
        if (entry.getLinkName().isEmpty()) {
            return false;
        }
        Field[] fieldArray = fields = TarEntry.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getName().equals("linkFlag")) {
                f.setAccessible(true);
                try {
                    return f.getByte(entry) == 50;
                }
                catch (IllegalAccessException illegalAccessException) {
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }
}

