/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.p2action.rpm;

import com.vmware.vide.p2action.ReadStreamToStringThread;
import com.vmware.vide.p2action.rpm.RPMDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class RPMUtil {
    private static final byte[] lead_magic = new byte[]{-19, -85, -18, -37};
    private static final byte[] head_magic = new byte[]{-114, -83, -24};

    public static boolean isRPMInstalled(String rpmName) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder("rpm", "-q", rpmName);
        Process proc = pb.start();
        ReadStreamToStringThread stderrReaderThread = new ReadStreamToStringThread("RPM err reader", proc.getErrorStream());
        ReadStreamToStringThread stdoutReaderThread = new ReadStreamToStringThread("RPM out reader", proc.getInputStream());
        stderrReaderThread.start();
        stdoutReaderThread.start();
        proc.waitFor();
        stdoutReaderThread.join();
        stderrReaderThread.join();
        return proc.exitValue() == 0;
    }

    public static String getRPMName(Path rpmPath, boolean includeVersion, boolean includeRelease) throws InterruptedException, IOException {
        StringBuilder queryForm = new StringBuilder("%{NAME}");
        if (includeVersion) {
            queryForm.append("-%{VERSION}");
        }
        if (includeRelease) {
            queryForm.append("-%{RELEASE}");
        }
        ProcessBuilder pb = new ProcessBuilder("rpm", "-q", "--qf", queryForm.toString(), "-p", rpmPath.toString());
        Process proc = pb.start();
        ReadStreamToStringThread stderrReaderThread = new ReadStreamToStringThread("RPM err reader", proc.getErrorStream());
        ReadStreamToStringThread stdoutReaderThread = new ReadStreamToStringThread("RPM out reader", proc.getInputStream());
        stderrReaderThread.start();
        stdoutReaderThread.start();
        proc.waitFor();
        stdoutReaderThread.join();
        stderrReaderThread.join();
        int retCode = -1;
        retCode = proc.exitValue();
        if (retCode != 0) {
            String msg = String.format("The command [%s] returned the error code [%d].", RPMUtil.commandLine(pb), retCode);
            throw new IOException(msg);
        }
        List<String> output = stdoutReaderThread.getOutput();
        if (output.isEmpty() || output.size() > 1) {
            String msg = String.format("The command [%s] produced unexpected output [%s].", RPMUtil.commandLine(pb), stdoutReaderThread.getAllOutput());
            throw new IOException(msg);
        }
        return stdoutReaderThread.getOutput().get(0);
    }

    private static String commandLine(ProcessBuilder pb) {
        StringBuilder sb = new StringBuilder();
        for (String item : pb.command()) {
            sb.append(item).append(' ');
        }
        return sb.toString();
    }

    public static boolean hasRPMManifest(Path rpmDirPath) {
        return RPMUtil.getRPMManifest(rpmDirPath) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isRPM(Path rpm) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            FileInputStream is = new FileInputStream(rpm.toFile());
            try {
                byte[] lead_head = new byte[100];
                int offset = 0;
                int len = lead_head.length;
                while (true) {
                    int n;
                    if ((n = ((InputStream)is).read(lead_head, offset, len)) <= 0) {
                        if (len == 0) break;
                        return false;
                    }
                    offset += n;
                    len -= n;
                }
                if (lead_head[0] != lead_magic[0]) return false;
                if (lead_head[1] != lead_magic[1]) return false;
                if (lead_head[2] != lead_magic[2]) return false;
                if (lead_head[3] != lead_magic[3]) return false;
                if (lead_head[96] != head_magic[0]) return false;
                if (lead_head[97] != head_magic[1]) return false;
                if (lead_head[98] != head_magic[2]) return false;
                return true;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (is == null) return false;
                ((InputStream)is).close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static Path getRPMManifest(Path rpmDirPath) {
        Path rpmManifestPath = Paths.get(rpmDirPath.toString(), "rpm.manifest");
        if (rpmManifestPath.toFile().isFile()) {
            return rpmManifestPath;
        }
        return null;
    }

    public static RPMDescriptor getRPMDescriptor(Path rpm) throws InterruptedException, IOException {
        StringBuilder queryForm = new StringBuilder("%{NAME}\\n%{VERSION}\\n%{RELEASE}\\n");
        ProcessBuilder pb = new ProcessBuilder("rpm", "-q", "--qf", queryForm.toString(), "-R", "-p", rpm.toString());
        Process proc = pb.start();
        ReadStreamToStringThread stderrReaderThread = new ReadStreamToStringThread("RPM err reader", proc.getErrorStream());
        ReadStreamToStringThread stdoutReaderThread = new ReadStreamToStringThread("RPM out reader", proc.getInputStream());
        stderrReaderThread.start();
        stdoutReaderThread.start();
        proc.waitFor();
        stdoutReaderThread.join();
        stderrReaderThread.join();
        int retCode = -1;
        retCode = proc.exitValue();
        if (retCode != 0) {
            String msg = String.format("The command [%s] returned the error code [%d].", RPMUtil.commandLine(pb), retCode);
            throw new IOException(msg);
        }
        List<String> output = stdoutReaderThread.getOutput();
        if (output.size() < 4) {
            String msg = String.format("The command [%s] produced unexpected output [%s].", RPMUtil.commandLine(pb), stdoutReaderThread.getAllOutput());
            throw new IOException(msg);
        }
        String name = output.get(0);
        String version = output.get(1);
        String release = output.get(2);
        ArrayList<String> requires = new ArrayList<String>();
        int index = 3;
        while (index < output.size()) {
            String rpmName = output.get(index);
            if (!rpmName.startsWith("/") && !rpmName.startsWith("rpmlib")) {
                int pos = rpmName.indexOf(32);
                if (pos != -1) {
                    rpmName = rpmName.substring(0, pos);
                }
                if ((pos = rpmName.indexOf(40)) == -1) {
                    requires.add(rpmName);
                }
            }
            ++index;
        }
        return new RPMDescriptor(rpm, name, version, release, requires);
    }
}

