/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.HTTPUpdateJob;
import com.vmware.vide.dashboard.IInstalledPackages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.jobs.Job;

public class ContentPanel
extends Observable
implements Comparable<ContentPanel> {
    private boolean working;
    private boolean closed;
    private String content;
    private String category;
    private int order = 100;
    private String icon;
    private Job updater;
    private String userName;
    private String password;
    private static IInstalledPackages installedPackagesChecker;
    public static final int NOT_ORDERED = 100;

    public boolean init() {
        this.working = false;
        return true;
    }

    public void dispose() {
        installedPackagesChecker = null;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String cat) {
        this.category = cat;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int pos) {
        this.order = pos;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        this.icon = value;
    }

    public String getHeader(boolean isHome) {
        return this.getHeader();
    }

    public String getHeader() {
        return "My Header";
    }

    public String getHeaderCommands(boolean isHome) {
        return null;
    }

    public String getHtml() {
        return this.content == null || this.content.isEmpty() ? "No content" : this.content;
    }

    public void setHtml(String content) {
        this.content = content;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean value) {
        this.setChanged();
        this.working = value;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.setChanged();
        this.closed = closed;
    }

    public void startUpdate() {
    }

    public boolean handleActionClick(String url) {
        return false;
    }

    public boolean handleClick(String url) {
        return false;
    }

    public void setCredentials(String loginId, String password) {
        this.userName = loginId;
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLoggedIn() {
        return false;
    }

    public boolean isLockedContent() {
        return false;
    }

    public String getPrefix() {
        return "?";
    }

    public String getHomeHtml() {
        return "No summary available.";
    }

    public String getLinkDescription(String link) {
        return "No link description";
    }

    public void startUpdateJob(String url) {
        this.updater = new HTTPUpdateJob(url, "Updating", "Updating the portal content", "message"){

            @Override
            public void onResult(String result) {
                ContentPanel.this.gotResult(result);
            }
        };
        this.setWorking(true);
        this.updater.schedule();
    }

    public void setInstalledPackagesChecker(IInstalledPackages checker) {
        installedPackagesChecker = checker;
    }

    public IInstalledPackages getInstalledPackagesChecker() {
        return installedPackagesChecker;
    }

    public String replaceContent(List<String> input, Map<String, String> values) {
        StringBuffer output = new StringBuffer();
        for (String line : input) {
            for (String k : values.keySet()) {
                String value = values.get(k);
                int index = line.indexOf(k);
                if (index < 0) continue;
                String t = String.valueOf(line.substring(0, index)) + value;
                line = t = String.valueOf(t) + line.substring(index + k.length());
            }
            output.append(line);
        }
        return output.toString();
    }

    public File getResourceFile(String filePath) {
        try {
            File scriptfile;
            URL path = FileLocator.toFileURL((URL)this.getClass().getResource(filePath));
            if (path != null && path.getFile() != null && (scriptfile = new File(path.getFile())).exists()) {
                return scriptfile;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addContentHeader(StringBuilder page, String title) {
        page.append("<ul class='panel' id='listPanel'>\n");
        page.append("<li class='header'>").append(title).append("</li>\n");
    }

    public void addContentHeaderWithSearch(StringBuilder page, String title) {
        page.append("<div id='contentList'>\n");
        page.append("<ul class='panel' id='listPanel'>\n");
        page.append("<li class='header'>").append(title);
        page.append("<span style='float:right'><input class='search' placeholder='filter' autofocus='autofocus'/></span></li>\n");
        page.append("<ul class='list'>\n");
    }

    public void addContentItemForSearch(StringBuilder page, String item) {
        page.append("<li><span class='listItem'>").append(item).append("</span></li>\n");
    }

    public void addContentFooterForSearch(StringBuilder page) {
        page.append("</ul>\n</ul>").append("</div>");
    }

    private void gotResult(String result) {
        this.setHtml(result);
        this.setWorking(false);
        this.notifyObservers(result);
    }

    @Override
    public int compareTo(ContentPanel anotherPanel) {
        int result;
        int ord2;
        int ord1 = this.getOrder();
        if (ord1 == (ord2 = anotherPanel.getOrder())) {
            String className0 = this.getClass().getSimpleName();
            String className1 = anotherPanel.getClass().getSimpleName();
            result = className0.compareToIgnoreCase(className1);
        } else {
            result = ord1 < ord2 ? -1 : 1;
        }
        return result;
    }
}

