/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.PortalManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DashboardPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite composite;
    private Button enableButton;
    private Button openButton;
    private Button disableUpdateSitesButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.composite.setLayout((Layout)layout);
        layout.numColumns = 2;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.composite.setLayoutData((Object)data);
        this.enableButton = new Button(this.composite, 32);
        this.enableButton.setText("&Show Dashboard on Startup");
        data = new GridData(512);
        data.horizontalSpan = 2;
        this.enableButton.setLayoutData((Object)data);
        this.openButton = new Button(this.composite, 0);
        this.openButton.setText("&Open the Dashboard");
        data = new GridData(4, 1, false, false);
        this.openButton.setLayoutData((Object)data);
        this.openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardPreferencePage.this.OpenDashboard();
            }
        });
        this.disableUpdateSitesButton = new Button(this.composite, 32);
        this.disableUpdateSitesButton.setText("&Disable non-VMware Update Sites when installing VMware plug-ins.");
        this.disableUpdateSitesButton.setToolTipText("When checked, VMware Workbench will disable Available Software sites\nthat don't have VMware content, such as Eclipse update sites.");
        data = new GridData(512);
        data.horizontalSpan = 2;
        this.disableUpdateSitesButton.setLayoutData((Object)data);
        this.initializeValues();
        return this.composite;
    }

    private void OpenDashboard() {
        PortalManager.getInstance().open();
    }

    private void initializeValues() {
        this.enableButton.setSelection(PortalManager.getEnabledOnStartup());
        this.disableUpdateSitesButton.setSelection(PortalManager.needDisableRepositories());
    }

    private void updateStatus(String message) {
        this.setValid(true);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableButton.setSelection(true);
        this.disableUpdateSitesButton.setSelection(true);
        this.updateStatus(null);
    }

    public boolean performOk() {
        PortalManager.setEnabledOnStartup(this.enableButton.getSelection());
        PortalManager.setNeedDisableRepositories(this.disableUpdateSitesButton.getSelection());
        return true;
    }
}

