/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.PortalEditorInput;
import com.vmware.vide.dashboard.VMWBPageEditor;
import com.vmware.vide.utils.ui.BrowserEditor;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.cheatsheets.actions.CheatSheetCategoryBasedSelectionAction;

public class DynamicBrowser {
    Browser myBrowser;
    ToolBar myNavBar;
    String previousContent = "";

    public DynamicBrowser(Composite parent) {
        try {
            this.myBrowser = new Browser(parent, 0);
            this.myNavBar = null;
        }
        catch (SWTError sWTError) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Cannot Locate Browser", (String)"Please install a version of Mozilla/XULRunner or WebKitGTK that is compatible with this version of Eclipse. For more information, refer to \"The SWT FAQ\" page on www.eclipse.org.");
        }
    }

    public boolean onShowPerspective(String name) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        try {
            workbench.showPerspective(name, workbench.getActiveWorkbenchWindow());
            return true;
        }
        catch (WorkbenchException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean onShowView(String id) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        try {
            window.getActivePage().showView(id);
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean onOpenBrowser(String url) {
        BrowserEditor.open((String)url, (String)"Web Browser", (String)"Web Browser", (String)"");
        return true;
    }

    public boolean onOpenPage(String url) {
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IEditorPart editor = page.getActiveEditor();
            PortalEditorInput input = new PortalEditorInput();
            VMWBPageEditor vmwbEditor = (VMWBPageEditor)page.openEditor((IEditorInput)input, "com.vmware.vide.dashboard.vmwbpageeditor");
            vmwbEditor.setOldEditor(editor);
            vmwbEditor.show(url);
        }
        catch (PartInitException partInitException) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"Cannot open the requested page.");
            return false;
        }
        return true;
    }

    public boolean onShowHelp(String id) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
        if (id == null || id.length() == 0) {
            helpSystem.displayHelp();
            return true;
        }
        helpSystem.displayHelpResource(id);
        return true;
    }

    public boolean onShowCheatSheet(String id) {
        OpenCheatSheetAction action;
        if (id == null || id.isEmpty()) {
            CheatSheetCategoryBasedSelectionAction action2 = new CheatSheetCategoryBasedSelectionAction();
            if (action2 != null) {
                action2.run();
            }
            return true;
        }
        try {
            action = new OpenCheatSheetAction(id);
            if (action != null) {
                action.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ((action = new OpenCheatSheetAction(id)) != null) {
            action.run();
        }
        return true;
    }

    public String onExecFg(String path) {
        Runner runner = new Runner(path);
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException interruptedException) {}
        return runner.output;
    }

    public String onExec(String path) {
        Runner runner = new Runner(path);
        runner.start();
        return null;
    }

    public void onChangingPage(LocationEvent event) {
        String uri = event.location;
        if (!uri.startsWith("vide:")) {
            return;
        }
        if ((uri = uri.substring(5)).startsWith("/welcome/")) {
            int pos = (uri = uri.substring(9)).indexOf(63);
            if (pos < 0) {
                return;
            }
            String cmd = uri.substring(0, pos);
            event.doit = !this.doLocalCommand(cmd, uri = uri.substring(pos + 1));
        }
    }

    public boolean doLocalCommand(String cmd, String uri) {
        boolean done = true;
        if (cmd.equalsIgnoreCase("openPerspective")) {
            done = this.onShowPerspective(uri);
        } else if (cmd.equalsIgnoreCase("showView")) {
            done = this.onShowView(uri);
        } else if (cmd.equalsIgnoreCase("showPage")) {
            done = this.onShowPage(uri, this.myBrowser);
        } else if (cmd.equalsIgnoreCase("openBrowser")) {
            done = this.onOpenBrowser(uri);
        } else if (cmd.equalsIgnoreCase("openPage")) {
            done = this.onOpenPage(uri);
        } else if (cmd.equalsIgnoreCase("showHelp")) {
            done = this.onShowHelp(uri);
        } else if (cmd.equalsIgnoreCase("showCheatSheets")) {
            done = this.onShowCheatSheet(null);
        } else if (cmd.equalsIgnoreCase("showCheatSheet")) {
            done = this.onShowCheatSheet(uri);
        } else if (cmd.equalsIgnoreCase("root")) {
            done = true;
        } else if (cmd.equalsIgnoreCase("exec")) {
            this.onExec(uri);
        } else if (cmd.equalsIgnoreCase("execandwait")) {
            String html = this.onExecFg(uri);
            if (html.length() > 0) {
                this.myBrowser.setText(html);
                done = true;
            }
        } else if (cmd.equalsIgnoreCase("proxySetup")) {
            PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"org.eclipse.ui.net.NetPreferences", null, null);
            pref.open();
        } else if (cmd.equalsIgnoreCase("contactMessage")) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Contact Information", (String)"E-mail any comments or questions to your VMware representative or vmwb@vmware.com");
        }
        return done;
    }

    public void setBackForwardTools() {
        if (this.myNavBar == null) {
            return;
        }
        ToolItem back = new ToolItem(this.myNavBar, 8);
        back.setText("back");
        back.setEnabled(false);
        ToolItem forward = new ToolItem(this.myNavBar, 8);
        forward.setText("forward");
        forward.setEnabled(false);
        back.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DynamicBrowser.this.myBrowser.back();
            }
        });
        forward.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DynamicBrowser.this.myBrowser.forward();
            }
        });
    }

    public boolean onShowPage(String url, Browser browser) {
        browser.setUrl(url);
        return true;
    }

    public ArrayList<String> readFileContent(String path) {
        ArrayList<String> page = new ArrayList<String>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(path);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                page.add(strLine);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return page;
    }

    public void setText(String html) {
        if (!this.previousContent.equals(html)) {
            this.myBrowser.setText(html);
            this.previousContent = html;
        }
    }

    public void addLocationListener(LocationListener listener) {
        this.myBrowser.addLocationListener(listener);
    }

    public Browser getBrowser() {
        return this.myBrowser;
    }

    class Runner
    extends Thread {
        String myPath;
        String output;

        Runner(String path) {
            this.myPath = path;
        }

        @Override
        public void run() {
            String cmd;
            Process proc = null;
            Runtime runtime = Runtime.getRuntime();
            this.output = "";
            int n = 0;
            Map<String, String> env = System.getenv();
            String[] newEnv = new String[env.size() + 1];
            for (Map.Entry<String, String> entry : env.entrySet()) {
                cmd = entry.getKey() + "=" + entry.getValue();
                newEnv[n++] = cmd;
            }
            newEnv[n] = "VIDE_CONF=/opt/vmware/vide/tmp";
            cmd = this.myPath;
            try {
                String line;
                proc = runtime.exec(cmd);
                InputStream inputstream = proc.getInputStream();
                InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
                BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
                InputStream errorstream = proc.getErrorStream();
                InputStreamReader errorstreamreader = new InputStreamReader(errorstream);
                BufferedReader bufferederrorreader = new BufferedReader(errorstreamreader);
                while ((line = bufferedreader.readLine()) != null) {
                    this.output = String.valueOf(this.output) + line + "\n";
                }
                while ((line = bufferederrorreader.readLine()) != null) {
                    this.output = String.valueOf(this.output) + line + "\n";
                    System.out.println(line);
                }
            }
            catch (IOException iOException) {}
            try {
                if (proc == null) {
                    this.output = "Cannot execute process '" + cmd + "' (is it an executable?)";
                } else if (proc.waitFor() != 0) {
                    this.output = "exit value = " + proc.exitValue();
                }
            }
            catch (InterruptedException e) {
                System.err.println(e);
            }
        }
    }
}

