/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.utils.net.NetworkHelper;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class HTTPUpdateJob
extends Job {
    private String url;
    private String title;
    private String description;
    private String message;
    private long start;
    private long finish;
    private boolean successful;

    public HTTPUpdateJob(String url, String title, String description, String message) {
        super(message);
        this.url = url;
        this.title = title;
        this.description = description;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                String result = NetworkHelper.getFromURL((String)this.url);
                this.onResult(result);
            }
            catch (Throwable throwable) {
                this.successful = false;
                IStatus iStatus = Status.CANCEL_STATUS;
                this.finish = System.currentTimeMillis();
                return iStatus;
            }
        }
        finally {
            this.finish = System.currentTimeMillis();
        }
        return Status.OK_STATUS;
    }

    public abstract void onResult(String var1);

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLogMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Task: ");
        buffer.append(super.getName());
        buffer.append("\n");
        buffer.append("Description: ");
        buffer.append(this.description);
        buffer.append("\n");
        buffer.append("Start Time: ");
        buffer.append(new Date(this.start).toString());
        buffer.append("\n");
        buffer.append("Finish Time: ");
        buffer.append(new Date(this.finish).toString());
        buffer.append("\n");
        if (this.message != null) {
            String[] messages = this.message.split("\\s*\n");
            if (messages != null) {
                if (this.successful) {
                    buffer.append("Completion Message: ");
                } else {
                    buffer.append("Error Message: ");
                }
                buffer.append(messages[0]);
                buffer.append("\n");
                int i = 1;
                while (i < messages.length) {
                    buffer.append("\t");
                    buffer.append(messages[i]);
                    buffer.append("\n");
                    ++i;
                }
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

