/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.NetworkChecker;
import com.vmware.vide.vmwbrepository.AccountInfo;
import com.vmware.vide.vmwbrepository.ProviderData;
import com.vmware.vide.vmwbrepository.ProviderDataList;
import com.vmware.vide.vmwbrepository.WebServiceController;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LoginDialog
extends TitleAreaDialog {
    private static final String LOGIN_MSG = "Enter your company's full email address and account password.";
    private static final String LOGIN_EMAIL = "Email Address:";
    private static final String LOGIN_INVALID_EMAIL = "Please enter a valid email address.";
    private static final String LOGIN_PASSWORD = "Password:";
    private static final String LOGIN_INVALID_PASSWORD = "A password is required.";
    private static final String LOGIN_ACCOUNT = "Account:";
    private static final String LOGIN_OK = "Sign In";
    private static final String LOGIN_FAILED = "The account or password entered was incorrect. Please try again.";
    private static final String LOGIN_FAILED_TITLE = "Authentication Failed";
    private static final String EMAIL_REGEX = "^[^.][a-zA-Z0-9.!#$%&'*\\+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$";
    private Text emailText;
    private String emailValue;
    private Text passwordText;
    private String passwordValue;
    private Combo accountCombo;
    private Button signInButton;
    private WebServiceController webService;
    private NetworkChecker networkChecker;
    private Map<String, ProviderData> providersMap;
    private ProviderData authProvider;
    private String sessionToken;
    private String prevErr;
    private Shell mainShell;

    public LoginDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.networkChecker = new NetworkChecker();
        this.networkChecker.schedule();
        this.webService = new WebServiceController();
        this.mainShell = parentShell;
    }

    public int open() {
        if (!this.networkChecker.getConnected()) {
            this.networkChecker.reportNotConnected(this.mainShell);
            return 1;
        }
        return super.open();
    }

    public void create() {
        super.create();
        this.setShellStyle(32);
        this.setTitle(LOGIN_OK);
        this.setMessage(LOGIN_MSG);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createEmailFields(container);
        this.createPasswordFields(container);
        this.createAuthProvidersList(container);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.signInButton = this.createButton(parent, 0, LOGIN_OK, true);
        this.signInButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void createEmailFields(Composite container) {
        this.createLabel(container, LOGIN_EMAIL);
        this.emailText = new Text(container, 2048);
        this.emailText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.emailText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean result = LoginDialog.this.validateEmail(LoginDialog.this.emailText.getText().trim());
                LoginDialog.this.updateErrorStatus(result, LoginDialog.LOGIN_INVALID_EMAIL);
            }
        });
    }

    protected void createPasswordFields(Composite container) {
        this.createLabel(container, LOGIN_PASSWORD);
        this.passwordText = new Text(container, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean result = LoginDialog.this.validateField(LoginDialog.this.passwordText.getText().trim());
                LoginDialog.this.updateErrorStatus(result, LoginDialog.LOGIN_INVALID_PASSWORD);
            }
        });
    }

    protected void createAuthProvidersList(Composite container) {
        this.createLabel(container, LOGIN_ACCOUNT);
        this.accountCombo = new Combo(container, 8);
        this.accountCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.providersMap = new HashMap<String, ProviderData>();
        String displayName = null;
        try {
            ProviderDataList providerDataList = this.webService.getProviderDataList();
            List providers = providerDataList.getProviders();
            for (ProviderData provider : providers) {
                displayName = provider.getDisplayName();
                this.providersMap.put(displayName, provider);
                this.accountCombo.add(displayName);
            }
        }
        catch (Exception exception) {}
        this.accountCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String displayName = LoginDialog.this.accountCombo.getText();
                LoginDialog.this.authProvider = (ProviderData)LoginDialog.this.providersMap.get(displayName);
            }
        });
        this.accountCombo.select(0);
        this.authProvider = this.providersMap.get(this.accountCombo.getText());
    }

    protected void updateErrorStatus(Boolean isValidField, String errMsg) {
        if (!isValidField.booleanValue()) {
            this.prevErr = this.getErrorMessage();
            this.setErrorMessage(errMsg);
            this.updateButtons();
        } else {
            if (this.getErrorMessage() != null && this.getErrorMessage().equalsIgnoreCase(errMsg)) {
                if (this.prevErr != null && this.prevErr.equalsIgnoreCase(errMsg)) {
                    this.prevErr = null;
                }
                this.setErrorMessage(this.prevErr);
            } else if (this.prevErr != null && this.prevErr.equalsIgnoreCase(errMsg)) {
                this.prevErr = this.getErrorMessage();
            }
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        if (this.getErrorMessage() != null) {
            this.signInButton.setEnabled(false);
        } else {
            this.emailValue = this.emailText.getText().trim();
            this.passwordValue = this.passwordText.getText().trim();
            if (this.emailValue != null && !this.emailValue.isEmpty() && this.passwordValue != null && !this.passwordValue.isEmpty()) {
                this.signInButton.setEnabled(true);
            } else {
                this.signInButton.setEnabled(false);
            }
        }
    }

    private Label createLabel(Composite container, String name) {
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(name);
        return label;
    }

    private Point getCenterPoint() {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        Rectangle shellBounds = parentShell.getBounds();
        return new Point(shellBounds.x + shellBounds.width / 2, shellBounds.y + shellBounds.height / 2);
    }

    protected Point getInitialLocation(Point initialSize) {
        super.getInitialLocation(initialSize);
        Point shellCenter = this.getCenterPoint();
        return new Point(shellCenter.x - initialSize.x / 2, shellCenter.y - initialSize.y / 2);
    }

    protected boolean validateEmail(String email) {
        Pattern pattern = Pattern.compile(EMAIL_REGEX);
        Matcher matcher = pattern.matcher(email);
        return matcher.matches();
    }

    protected boolean validateField(String value) {
        return !value.isEmpty();
    }

    public void okPressed() {
        AccountInfo accountInfo = null;
        try {
            accountInfo = this.webService.authenticateLogin(this.emailValue, this.passwordValue, this.authProvider);
            if (accountInfo != null) {
                this.sessionToken = accountInfo.getSessionToken();
            }
        }
        catch (Exception exception) {
            Shell shell = this.getShell();
            MessageDialog.openError((Shell)shell, (String)LOGIN_FAILED_TITLE, (String)LOGIN_FAILED);
            return;
        }
        super.okPressed();
    }

    public String getUserAccount() {
        return this.emailValue;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getPassword() {
        return this.passwordValue;
    }
}

