/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard;

import com.vmware.vide.dashboard.Activator;
import com.vmware.vide.dashboard.ContentProvider;
import com.vmware.vide.dashboard.DynamicBrowser;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class PortalEditor
extends EditorPart {
    DynamicBrowser browser;
    private IEditorSite partSite;
    private ContentProvider contentProvider;
    private Observer observer;

    public void dispose() {
        this.contentProvider.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.partSite = site;
        this.setInput(input);
        this.createObserver();
        Image vmwbImage = Activator.getWMVBImage();
        if (vmwbImage != null) {
            this.setTitleImage(vmwbImage);
        }
    }

    public IEditorSite getSite() {
        return this.partSite;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.browser = new DynamicBrowser(parent);
        this.browser.setText("<html><body>Loading...</body></html>");
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String uri = event.location;
                if (uri.startsWith("vide:") && PortalEditor.this.contentProvider.handleClick(event.location)) {
                    event.doit = false;
                    return;
                }
                int pos = uri.indexOf("org.eclipse.ui.intro/vide?");
                if (pos >= 0) {
                    String arg = uri.substring(pos + 26);
                    String[] args = arg.split("&");
                    String cmd = args[0].substring(4);
                    String id = null;
                    if (args.length > 1) {
                        id = args[1].substring(3);
                    }
                    PortalEditor.this.browser.doLocalCommand(cmd, id);
                    event.doit = false;
                    return;
                }
                if (uri.indexOf("org.eclipse.ui.intro/navigate?") >= 0) {
                    event.doit = false;
                    return;
                }
                if (uri.indexOf("org.eclipse.ui.intro/showHelp") >= 0) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp();
                    event.doit = false;
                    return;
                }
                PortalEditor.this.browser.onChangingPage(event);
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    public void setFocus() {
    }

    public void setContentProvider(ContentProvider provider) {
        this.contentProvider = provider;
        this.contentProvider.setObserver(this.observer);
    }

    private void createObserver() {
        this.observer = new Observer(){

            @Override
            public void update(Observable arg0, Object arg1) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).PortalEditor.this.browser.myBrowser.isDisposed()) {
                            return;
                        }
                        String content = PortalEditor.this.contentProvider.toHtml();
                        if (content != null && !content.isEmpty()) {
                            (this).PortalEditor.this.browser.setText(content);
                        }
                    }
                });
            }
        };
    }

    public void maximize() {
        IEditorReference[] editors;
        IWorkbenchPage page = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference er = iEditorReferenceArray[n2];
            if (er.getEditor(false) == this) {
                page.setPartState((IWorkbenchPartReference)er, 1);
                break;
            }
            ++n2;
        }
    }
}

