/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.wbis.pinger;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
BundleListener,
IStartup {
    private static final String VMWB_ENG_HOST = "vmwb.eng.vmware.com";
    private static final String VMWB_ENG_URL = "http://vmwb.eng.vmware.com/wbis/";
    private static final String PART_WEB_URL = "http://partnerweb.vmware.com/wbis/";
    private static final long MILLISEC_24H = TimeUnit.HOURS.toMillis(24L);
    private static final long MILLISEC_2H = TimeUnit.HOURS.toMillis(2L);
    private static final String PLUGIN_ID = "com.vmware.vide.wbis.pinger";
    private static Activator plugin;
    private static BundleContext context;
    private ServiceTracker tracker;
    private Timer timer;
    private ILog logger;
    private static Map<String, Long> activities;
    private static boolean _isVMware;

    static {
        activities = new HashMap<String, Long>();
        _isVMware = false;
        try {
            InetAddress.getByName(VMWB_ENG_HOST);
            _isVMware = true;
        }
        catch (UnknownHostException unknownHostException) {}
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        plugin = this;
        context = bundleContext;
        this.logger = Platform.getLog((Bundle)bundleContext.getBundle());
        this.tracker = new ServiceTracker(bundleContext, IProxyService.class.getName(), null);
        this.tracker.open();
        this.pingForAll();
        bundleContext.addBundleListener((BundleListener)this);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PingTask(), 0L, MILLISEC_2H);
    }

    private void pingForAll() {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            this.pingBundle(b);
            ++n2;
        }
    }

    private void pingBundle(Bundle b) {
        String name = b.getSymbolicName();
        if (name.startsWith("com.vmware.") && b.getState() == 32) {
            this.ping(name, b.getVersion().toString());
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        bundleContext.removeBundleListener((BundleListener)this);
        this.timer.cancel();
        context = null;
    }

    public void bundleChanged(BundleEvent event) {
        this.pingBundle(event.getBundle());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void ping(String name, String version) {
        if (activities.containsKey(name) && System.currentTimeMillis() - activities.get(name) < MILLISEC_24H) {
            return;
        }
        String charset = "UTF-8";
        InputStream response = null;
        StringBuilder msg = new StringBuilder("Failed ping to ");
        StringBuilder url = new StringBuilder(_isVMware ? VMWB_ENG_URL : PART_WEB_URL);
        try {
            url.append("wbis.php");
            url.append("?productId=");
            url.append(URLEncoder.encode(name, "UTF-8"));
            if (version != null) {
                url.append("&version=").append(URLEncoder.encode(version, "UTF-8"));
            }
            URLConnection connection = Activator.getUrlConnection(new URI(url.toString()));
            connection.setRequestProperty("Accept-Charset", charset);
            response = connection.getInputStream();
            activities.put(name, System.currentTimeMillis());
        }
        catch (MalformedURLException e) {
            this.logger.log((IStatus)new Status(4, PLUGIN_ID, msg.append((CharSequence)url).toString(), (Throwable)e));
            if (response == null) return;
            try {
                response.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            this.logger.log((IStatus)new Status(4, PLUGIN_ID, msg.append((CharSequence)url).toString(), (Throwable)e));
            if (response == null) return;
            try {
                response.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (URISyntaxException e) {
            this.logger.log((IStatus)new Status(4, PLUGIN_ID, "Internal error", (Throwable)e));
            if (response == null) return;
            {
                catch (Throwable throwable) {
                    if (response == null) throw throwable;
                    try {
                        response.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                response.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (response == null) return;
        try {
            response.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private static URLConnection getUrlConnection(URI uri) throws MalformedURLException, IOException {
        URLConnection connection = null;
        Proxy proxy = null;
        IProxyService service = (IProxyService)Activator.plugin.tracker.getService();
        if (service.isProxiesEnabled()) {
            IProxyData[] proxyDatus = service.select(uri);
            IProxyData data = null;
            IProxyData[] iProxyDataArray = proxyDatus;
            int n = proxyDatus.length;
            int n2 = 0;
            while (n2 < n) {
                IProxyData pd = iProxyDataArray[n2];
                if (pd.getType().equals("HTTP")) {
                    data = pd;
                    break;
                }
                ++n2;
            }
            if (data != null) {
                String proxyHost = data.getHost();
                int proxyPort = data.getPort();
                if (proxyHost != null && proxyPort != -1) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                    final String user = data.getUserId();
                    final String pass = data.getPassword();
                    if (user != null && pass != null) {
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                return new PasswordAuthentication(user, pass.toCharArray());
                            }
                        });
                    }
                }
            }
        }
        connection = uri.toURL().openConnection(proxy == null ? Proxy.NO_PROXY : proxy);
        return connection;
    }

    public void earlyStartup() {
    }

    class PingTask
    extends TimerTask {
        PingTask() {
        }

        @Override
        public void run() {
            Activator.this.pingForAll();
        }
    }
}

