/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api;

import com.vmware.vide.target.api.ITargetTypeFactory;
import com.vmware.vide.target.api.TargetType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetTypeRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TargetTypeRegistry.class);
    private List<TargetType> availableTargetTypes = new ArrayList<TargetType>();
    private Map<String, TargetType> rseSystemTypeToTargetTypeMap = new HashMap<String, TargetType>();
    private Map<String, TargetType> targetTypeIdToTargetTypeMap = new HashMap<String, TargetType>();

    public synchronized void rebuildTargetList(List<TargetType> targets) {
        logger.info("Reloading available targets");
        this.availableTargetTypes = new ArrayList<TargetType>();
        this.availableTargetTypes.addAll(targets);
        this.syncLookupMaps();
    }

    public static List<TargetType> getTargetsFromExtensions() {
        ArrayList<TargetType> targets = new ArrayList<TargetType>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.vmware.vide.target.api.targettypefactory");
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                String contributorName = extension.getContributor().getName();
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        TargetType[] targetTypes;
                        Object obj = element.createExecutableExtension("class");
                        ITargetTypeFactory factory = (ITargetTypeFactory)obj;
                        TargetType[] targetTypeArray = targetTypes = factory.getTargetTypes();
                        int n5 = targetTypes.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            TargetType t = targetTypeArray[n6];
                            logger.info("Adding TargetType extension contributor={} id={} rseSystemType={}", new Object[]{contributorName, t.getId(), t.getRseSystemTypeId()});
                            targets.add(t);
                            ++n6;
                        }
                    }
                    catch (CoreException e) {
                        logger.error("Unable to load equivalency check from {}", (Object)element.getContributor().getName(), (Object)e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return targets;
    }

    private void syncLookupMaps() {
        this.rseSystemTypeToTargetTypeMap = new HashMap<String, TargetType>();
        this.targetTypeIdToTargetTypeMap = new HashMap<String, TargetType>();
        for (TargetType t : this.availableTargetTypes) {
            String rseSystemTypeId = t.getRseSystemTypeId();
            if (rseSystemTypeId != null) {
                this.rseSystemTypeToTargetTypeMap.put(t.getRseSystemTypeId(), t);
            }
            this.targetTypeIdToTargetTypeMap.put(t.getId(), t);
        }
    }

    public synchronized List<TargetType> getAvailableTargetTypes() {
        return this.availableTargetTypes;
    }

    public synchronized TargetType lookupTargetTypeByRseSystemType(String rseSystemType) {
        return this.rseSystemTypeToTargetTypeMap.get(rseSystemType);
    }

    public synchronized TargetType lookupTargetTypeById(String targetTypeId) {
        return this.targetTypeIdToTargetTypeMap.get(targetTypeId);
    }
}

