/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl;

import com.jcraft.jsch.SftpProgressMonitor;
import com.vmware.vide.target.TargetPlugin;
import com.vmware.vide.target.api.ICommandOutputListener;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import com.vmware.vide.target.api.ITargetProcess;
import com.vmware.vide.target.api.TargetType;
import com.vmware.vide.target.api.impl.TargetFile;
import com.vmware.vide.target.api.impl.UnsupportedRemoteOperationException;
import com.vmware.vide.target.api.impl.sdk.SdkConnectionManager;
import com.vmware.vide.target.api.impl.ssh.JschProgressMonitorDelegate;
import com.vmware.vide.target.api.impl.ssh.RemoteProcess;
import com.vmware.vide.target.api.impl.ssh.SshConnectionManager;
import com.vmware.vide.target.api.impl.ssh.StreamReaderRunnable;
import com.vmware.vide.target.util.ScpHelper;
import com.vmware.vide.utils.security.SecurePreferencesManager;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import jcifs.smb.SmbFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class Target
implements ITarget {
    private static final String DEFAULT_USER = "root";
    private static final String VISOR_PROPERTY = "visor";
    private static final String VERSION_PROPERTY = "version";
    private static final String PLUGIN_ID = TargetPlugin.getDefault().getBundle().getSymbolicName();
    private static final int BUFFER_SIZE = 4096;
    private String host;
    private String name;
    private final String type;
    private String description;
    private final TargetType targetType;
    private String user;
    private String password;
    private final ISecurePreferences passwords;
    private SshConnectionManager sshManager;
    private SdkConnectionManager sdkManager;

    public Target(String host, String name, String type, String user, TargetType targetType) {
        if (host == null) {
            throw new IllegalArgumentException("Host can not be null");
        }
        this.host = host;
        this.name = name != null ? name : host;
        this.type = type != null ? type : "unknown";
        this.user = user != null ? user : DEFAULT_USER;
        this.targetType = targetType;
        SecurePreferencesManager manager = SecurePreferencesManager.getInstance();
        this.passwords = manager.getSecurePreferences().node(PLUGIN_ID);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHostName() {
        return this.host;
    }

    public void setHostName(String host) {
        this.host = host;
    }

    public String getDescription() {
        return this.description != null ? this.description : "";
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLabel() {
        return null;
    }

    public String getTargetType() {
        return this.type;
    }

    public String getUserId() {
        return this.user;
    }

    public void setUserId(String user) {
        this.user = user;
    }

    public String getPassword(boolean prompt) {
        if (this.password == null) {
            try {
                this.password = this.passwords.get(this.host, null);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        }
        return this.password;
    }

    private void flush(ISecurePreferences preferences, int retries) {
        boolean flushed = false;
        int count = 0;
        while (!flushed && count < retries) {
            try {
                preferences.flush();
                flushed = true;
            }
            catch (IOException e) {
                ++count;
                e.printStackTrace();
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setPassword(String password, boolean persist) {
        this.password = password;
        if (persist) {
            try {
                this.passwords.put(this.host, password, true);
                this.flush(this.passwords, 3);
            }
            catch (StorageException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isSdkSupported() {
        return this.type.equals("esx") || this.type.equals("vc") || this.type.equals("vcva");
    }

    public boolean isVisor() throws Exception {
        if (!this.isSdkSupported()) {
            throw new Exception("Target type " + this.type + " does not support VI SDK connections");
        }
        boolean isVisor = false;
        String value = null;
        if (this.sdkManager != null) {
            value = this.sdkManager.getProperty(VISOR_PROPERTY);
        }
        if (value != null) {
            isVisor = Boolean.parseBoolean(value);
        } else {
            ServiceInstance serviceInstance = this.getServiceInstance();
            String name = serviceInstance.getAboutInfo().getName().toLowerCase();
            if (name.contains("esxi") || name.contains("3i")) {
                isVisor = true;
            }
            this.sdkManager.setProperty(VISOR_PROPERTY, Boolean.toString(isVisor));
        }
        return isVisor;
    }

    public String getESXVersion() throws Exception {
        if (!this.isSdkSupported()) {
            throw new Exception("Target type " + this.type + " does not support VI SDK connections");
        }
        String version = null;
        if (this.sdkManager != null) {
            version = this.sdkManager.getProperty(VERSION_PROPERTY);
        }
        if (version == null) {
            ServiceInstance serviceInstance = this.getServiceInstance();
            version = serviceInstance.getAboutInfo().getVersion();
            this.sdkManager.setProperty(VERSION_PROPERTY, version);
        }
        return version;
    }

    public ServiceInstance getServiceInstance() throws Exception {
        if (!this.isSdkSupported()) {
            throw new Exception("Target type " + this.type + " does not support VI SDK connections");
        }
        if (this.sdkManager == null) {
            this.sdkManager = new SdkConnectionManager(this.host, this.user, this.password);
        }
        return this.sdkManager.getServiceInstance();
    }

    public void connect(IProgressMonitor monitor) throws Exception {
        if (!this.isSupportSsh()) {
            throw new Exception("Target type " + this.type + " does not support SSH connections");
        }
        if (!this.isConnected()) {
            this.sshManager = new SshConnectionManager(this.host, this.user, this.password);
            this.sshManager.connect();
        }
    }

    public void disconnect() throws Exception {
        if (this.isConnected()) {
            this.sshManager.disconnect();
        }
        if (this.sdkManager != null) {
            this.sdkManager.disconnect();
        }
    }

    public boolean isConnected() {
        return this.sshManager != null && this.sshManager.isConnected();
    }

    public void uploadFile(File localFile, String remoteFileOrDir, IProgressMonitor monitor) throws Exception {
        TargetFile file = (TargetFile)this.getTargetFile(remoteFileOrDir, null);
        String remote = file.getCanonicalPath();
        if (file.isDirectory() || file.isCanonicalDirectory()) {
            remote = String.valueOf(remote) + "/" + localFile.getName();
        }
        if (this.isSupportSsh()) {
            this.connect(null);
            ScpHelper.scpTo(this.sshManager.getSession(), localFile.getCanonicalPath(), remote, new JschProgressMonitorDelegate(monitor));
        } else if (this.isFileSystemSupported() && "windows".equals(this.targetType.getId())) {
            String url = "smb://" + this.user + ":" + this.password + "@" + this.host + "/" + remote;
            SmbFile f = new SmbFile(url);
            this.copyStream(new FileInputStream(localFile), f.getOutputStream(), localFile.getName(), localFile.length(), monitor);
        } else {
            throw new UnsupportedRemoteOperationException(this.host, "upload file");
        }
    }

    public void downloadFile(String remoteFile, File localFileOrDir, IProgressMonitor monitor) throws Exception {
        File remote = new File(remoteFile);
        File dest = null;
        dest = localFileOrDir.isDirectory() ? new File(localFileOrDir, remote.getName()) : localFileOrDir;
        if (this.isSupportSsh()) {
            this.connect(null);
            ScpHelper.scpFrom(this.sshManager.getSession(), remoteFile, dest.getCanonicalPath(), (SftpProgressMonitor)new JschProgressMonitorDelegate(monitor));
        } else if (this.isFileSystemSupported() && "windows".equals(this.targetType.getId())) {
            String url = "smb://" + this.user + ":" + this.password + "@" + this.host + "/" + remoteFile;
            SmbFile f = new SmbFile(url);
            this.copyStream(f.getInputStream(), new FileOutputStream(dest), f.getName(), f.length(), monitor);
        } else {
            throw new UnsupportedRemoteOperationException(this.host, "download file");
        }
    }

    public byte[] readRemoteFile(String remoteFile, int size, IProgressMonitor monitor) throws Exception {
        if (this.isSupportSsh()) {
            this.connect(null);
            return ScpHelper.scpFrom(this.sshManager.getSession(), remoteFile, size, (SftpProgressMonitor)new JschProgressMonitorDelegate(monitor));
        }
        if (this.isFileSystemSupported() && "windows".equals(this.targetType.getId())) {
            String url = "smb://" + this.user + ":" + this.password + "@" + this.host + "/" + remoteFile;
            SmbFile f = new SmbFile(url);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.copyStream(f.getInputStream(), out, f.getName(), f.length(), size, monitor);
            return out.toByteArray();
        }
        throw new UnsupportedRemoteOperationException(this.host, "read remote file");
    }

    public ITargetFile getTargetFile(String remoteFile, IProgressMonitor monitor) throws Exception {
        if (!remoteFile.startsWith("/")) {
            throw new Exception("The remote file path must be absolute");
        }
        String path = remoteFile;
        if (remoteFile.endsWith("/") && remoteFile.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        return new TargetFile(this, path);
    }

    public ITargetFile getTargetFile(ITargetFile parent, String child, IProgressMonitor monitor) throws Exception {
        ITargetFile file = null;
        if (parent == null) {
            file = this.getTargetFile(child, monitor);
        } else {
            String path = String.valueOf(parent.getCanonicalPath()) + "/" + child;
            file = this.getTargetFile(path, monitor);
        }
        return file;
    }

    private RemoteProcess execProcess(String command, ICommandOutputListener listener) throws Exception {
        RemoteProcess process = new RemoteProcess(this, this.sshManager.getSession(), command);
        if (listener != null) {
            SequenceInputStream stream = new SequenceInputStream(process.getInputStream(), process.getErrorStream());
            Thread thread = new Thread(new StreamReaderRunnable(stream, listener));
            thread.start();
        }
        process.run();
        return process;
    }

    public int executeCommand(String command, ICommandOutputListener listener, IProgressMonitor monitor) throws Exception {
        this.connect(null);
        RemoteProcess process = this.execProcess(command, listener);
        while (process.isActive()) {
            if (monitor != null && monitor.isCanceled()) {
                process.destroy();
                throw new OperationCanceledException();
            }
            Thread.sleep(1000L);
        }
        return process.exitValue();
    }

    public void executeCommandAsync(String command, ICommandOutputListener listener) throws Exception {
        this.connect(null);
        this.execProcess(command, listener);
    }

    public ITargetProcess getTargetProcess(String command) throws Exception {
        this.connect(null);
        return new RemoteProcess(this, this.sshManager.getSession(), command);
    }

    public boolean isSupportSsh() {
        if (this.targetType == null) {
            return false;
        }
        return this.targetType.isSshSupported();
    }

    public boolean isFileSystemSupported() {
        return this.targetType.isFileSystemSupported();
    }

    private void copyStream(InputStream in, OutputStream out, String fileName, long fileLength, IProgressMonitor monitor) throws IOException {
        this.copyStream(in, out, fileName, fileLength, Integer.MAX_VALUE, monitor);
    }

    private void copyStream(InputStream in, OutputStream out, String fileName, long fileLength, int limit, IProgressMonitor monitor) throws IOException {
        try {
            int n;
            byte[] b = new byte[4096];
            int i = 0;
            int inc = 409600;
            monitor.beginTask(fileName, (int)fileLength);
            while ((n = in.read(b)) > 0 && i < limit) {
                int ammount = n < limit ? n : limit;
                out.write(b, 0, ammount);
                limit -= limit;
                if ((i += n) % inc == 0) {
                    monitor.worked(inc);
                }
                if (monitor.isCanceled()) break;
            }
            out.close();
            in.close();
        }
        finally {
            monitor.done();
        }
    }
}

