/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.target.api.impl.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.vmware.vide.target.api.impl.AbstractConnectionManager;
import com.vmware.vide.target.api.impl.ssh.HeadlessUserInfoDelegate;
import com.vmware.vide.utils.properties.PropertyManager;

public class SshConnectionManager
extends AbstractConnectionManager {
    private static final String SSH_TIMEOUT = "ssh-timeout";
    private static final String SSH_KEEP_ALIVE = "ssh-keepalive";
    private static final String SSH_SERVER_ALIVE_COUNT_MAX = "ssh-keepalivecount";
    private Session session;

    public SshConnectionManager(String host, String user, String password) {
        super(host, user, password);
    }

    public Session getSession() {
        return this.session;
    }

    public boolean isConnected() {
        return this.session != null && this.session.isConnected();
    }

    @Override
    public void connect() throws Exception {
        if (!this.isConnected()) {
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.user, this.host, 22);
            HeadlessUserInfoDelegate info = new HeadlessUserInfoDelegate(this.password);
            this.session.setUserInfo((UserInfo)info);
            PropertyManager properties = PropertyManager.getInstance();
            int timeout = properties.getInt(SSH_TIMEOUT, 0);
            int keepAlive = properties.getInt(SSH_KEEP_ALIVE, 300000);
            int maxCount = properties.getInt(SSH_SERVER_ALIVE_COUNT_MAX, 6);
            this.session.setTimeout(timeout);
            this.session.setServerAliveInterval(keepAlive);
            this.session.setServerAliveCountMax(maxCount);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.connect();
        }
    }

    @Override
    public void disconnect() throws Exception {
        if (this.isConnected()) {
            this.session.disconnect();
        }
    }
}

