/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.cifs;

import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;

public class CIFSHostFile
implements IHostFile,
IHostFilePermissionsContainer {
    private String parentPath;
    private String name;
    private long length;
    private IHostFilePermissions permissions;
    private SmbFile smbFile;

    public CIFSHostFile(String parentPath, SmbFile f) throws SmbException {
        this.parentPath = parentPath;
        this.smbFile = f;
        this.name = f.getName();
        this.length = f.exists() ? f.length() : 0L;
        this.initPermissions(f);
    }

    private void initPermissions(SmbFile f) {
        this.permissions = new HostFilePermissions();
        try {
            this.permissions.setPermission(256, f.canRead());
            this.permissions.setPermission(128, f.canWrite());
            this.permissions.setPermission(64, false);
            this.permissions.setPermission(32, false);
            this.permissions.setPermission(16, false);
            this.permissions.setPermission(8, false);
            this.permissions.setPermission(4, false);
            this.permissions.setPermission(2, false);
            this.permissions.setPermission(1, false);
            this.permissions.setGroupOwner("");
            this.permissions.setUserOwner("");
        }
        catch (SmbException smbException) {}
    }

    protected boolean internalIsArchive() {
        return false;
    }

    public IHostFilePermissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(IHostFilePermissions permissions) {
        this.permissions = permissions;
    }

    public String getName() {
        return this.name.replaceAll("/", "");
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getAbsolutePath() {
        if (this.isRoot() || this.parentPath == null) {
            return this.getName();
        }
        String parentPath = this.getParentPath();
        StringBuffer path = new StringBuffer(parentPath);
        String sep = PathUtility.getSeparator((String)parentPath);
        if (!(parentPath.endsWith("/") || parentPath.endsWith("\\") || parentPath.endsWith(sep))) {
            path.append(sep);
        }
        path.append(this.getName());
        if (this.isDirectory()) {
            path.append(sep);
        }
        return path.toString();
    }

    public boolean isHidden() {
        boolean isHidden = false;
        try {
            isHidden = this.smbFile.isHidden();
        }
        catch (SmbException smbException) {}
        return isHidden || this.getName().charAt(0) == '.';
    }

    public boolean isDirectory() {
        try {
            return this.smbFile.isDirectory();
        }
        catch (SmbException smbException) {
            return false;
        }
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isFile() {
        return !this.isDirectory() && !this.isRoot();
    }

    public boolean canWrite() {
        try {
            return this.smbFile.canWrite();
        }
        catch (SmbException smbException) {
            return false;
        }
    }

    public boolean canRead() {
        try {
            return this.smbFile.canRead();
        }
        catch (SmbException smbException) {
            return false;
        }
    }

    public boolean exists() {
        try {
            return this.smbFile.exists();
        }
        catch (SmbException smbException) {
            return false;
        }
    }

    public boolean isArchive() {
        return this.internalIsArchive();
    }

    public long getSize() {
        return this.length;
    }

    public long getModifiedDate() {
        try {
            return this.smbFile.lastModified();
        }
        catch (SmbException smbException) {
            return 0L;
        }
    }

    public void renameTo(String newAbsolutePath) {
        int i = newAbsolutePath.lastIndexOf("/");
        if (i == -1) {
            this.name = newAbsolutePath;
        } else if (i == 0) {
            if (newAbsolutePath.length() == 1) {
                this.parentPath = null;
                this.name = newAbsolutePath;
            } else {
                this.parentPath = "/";
                this.name = newAbsolutePath.substring(i + 1);
            }
        } else {
            this.parentPath = newAbsolutePath.substring(0, i);
            this.name = newAbsolutePath.substring(i + 1);
        }
    }

    public SmbFile getSMBFile() {
        return this.smbFile;
    }
}

