/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.xml.XMLParser;
import com.vmware.vide.utils.xml.XMLUtil;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionableEditField {
    protected Composite row;
    protected String id;
    protected Label label;
    protected Combo comboBox;
    protected IAction comboAction;
    protected Composite actionsRow;
    protected IAction[] actions;
    protected Date[] lastAccess;
    protected IPreferenceStore store;
    protected ControlDecoration decorator;
    protected static final String DECORATOR_MESSAGE = "Invalid value.";
    protected static final String TAG_COMBO = "_value";
    protected static final String TAG_CURRENT = "_current";
    protected int MAX_HISTORY_SIZE = 10;
    protected int DOUBLECLICK_DELAY = 500;
    protected Document doc;
    protected Element root;

    public ActionableEditField(Composite parent, String id) {
        this.id = id;
        this.row = new Composite(parent, 0);
        this.row.setFont(parent.getFont());
        GridLayout layout = new GridLayout(3, false);
        this.row.setLayout((Layout)layout);
        this.actions = null;
        this.store = null;
        this.doc = null;
        this.root = null;
    }

    private void setStore(IPreferenceStore s) {
        this.store = s;
    }

    private void setStore(Document doc, Element root) {
        this.doc = doc;
        this.root = root;
    }

    public void init(IAction comboAction, boolean editable, IAction[] usrActions, IPreferenceStore store) {
        this.setStore(store);
        this.init(comboAction, editable, usrActions);
    }

    public void init(IAction comboAction, boolean editable, IAction[] usrActions, Document doc, Element root) {
        this.setStore(doc, root);
        this.init(comboAction, editable, usrActions);
    }

    private void init(final IAction comboAction, boolean editable, IAction[] usrActions) {
        String txt;
        this.comboAction = comboAction;
        this.label = new Label(this.row, 0);
        if (comboAction != null && (txt = comboAction.getText()) != null) {
            this.label.setText(txt);
        }
        this.comboBox = new Combo(this.row, 0x804 | (editable ? 0 : 8));
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.comboBox.setLayoutData((Object)gridData);
        this.comboBox.setFont(this.row.getFont());
        this.comboBox.setData("name", (Object)"txtFilter");
        if (comboAction != null) {
            txt = comboAction.getToolTipText();
            if (txt != null) {
                this.comboBox.setToolTipText(txt);
            }
            this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selText;
                    String txt = ActionableEditField.this.comboBox.getText();
                    if (!txt.equals(selText = ActionableEditField.this.comboBox.getItem(ActionableEditField.this.comboBox.getSelectionIndex()))) {
                        comboAction.run();
                    }
                }
            });
        }
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 10) {
                    ActionableEditField.this.execute();
                }
            }
        });
        this.comboBox.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                ActionableEditField.this.showErrorMarker();
            }
        });
        this.decorator = this.createDecorator(this.getInvalidMessage());
        this.decorator.hide();
        this.actions = usrActions;
        if (this.actions != null) {
            this.actionsRow = new Composite(this.row, 0);
            this.lastAccess = new Date[this.actions.length];
            this.actionsRow.setLayout((Layout)new GridLayout(this.actions.length, false));
            int i = 0;
            while (i < this.actions.length) {
                IAction action = this.actions[i];
                ImageDescriptor img = action.getImageDescriptor();
                Button button = new Button(this.actionsRow, 8);
                if (img != null) {
                    button.setImage(img.createImage());
                }
                if ((txt = action.getText()) != null) {
                    button.setText(txt);
                }
                if ((txt = action.getToolTipText()) != null) {
                    button.setToolTipText(txt);
                }
                button.setData("index", (Object)new Integer(i));
                this.lastAccess[i] = new Date();
                button.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        Integer index = (Integer)arg0.widget.getData("index");
                        IAction act = ActionableEditField.this.actions[index];
                        if (System.currentTimeMillis() - ActionableEditField.this.lastAccess[index].getTime() > (long)ActionableEditField.this.DOUBLECLICK_DELAY) {
                            ActionableEditField.this.lastAccess[index.intValue()] = new Date();
                            act.run();
                        }
                    }
                });
                ++i;
            }
        }
        this.loadState();
        this.comboBox.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ActionableEditField.this.saveState();
            }
        });
    }

    public void execute() {
        String txt = this.comboBox.getText();
        if (!txt.isEmpty()) {
            this.updateHistory();
            this.comboBox.setText(txt);
        }
        if (this.comboAction != null) {
            this.comboAction.run();
        }
    }

    protected ControlDecoration createDecorator(String message) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)this.comboBox, 16512);
        controlDecoration.setDescriptionText(message);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        return controlDecoration;
    }

    public boolean isValid() {
        return true;
    }

    public String getInvalidMessage() {
        return DECORATOR_MESSAGE;
    }

    public void showErrorMarker() {
        if (!this.isValid()) {
            this.decorator.show();
        } else {
            this.decorator.hide();
        }
    }

    public void loadState() {
        if (this.store != null) {
            String name;
            String value;
            int i = 0;
            while ((value = this.store.getString(name = String.valueOf(this.id) + TAG_COMBO + i)) != null && !value.trim().isEmpty()) {
                this.comboBox.add(value);
                ++i;
            }
            return;
        }
        if (this.doc != null && this.root != null) {
            ArrayList elements = XMLUtil.getAllChildrenNamed((String)"ComboHistory", (Node)this.root);
            for (Node n : elements) {
                String idVal;
                NamedNodeMap attrs = n.getAttributes();
                Node idNode = attrs.getNamedItem("id");
                if (idNode == null || (idVal = XMLParser.getTextNodeValue((Node)idNode)) == null || !idVal.equals(this.id)) continue;
                ArrayList info = XMLUtil.getAllChildrenNamed((String)"value", (Node)n);
                if (info == null) break;
                for (Node nfo : info) {
                    String s = XMLParser.getTextNodeValue((Node)nfo);
                    if (s == null || s.isEmpty()) continue;
                    this.comboBox.add(s);
                }
            }
        }
    }

    public void saveState() {
        int i;
        if (this.store != null) {
            i = 0;
            while (i < this.comboBox.getItemCount()) {
                String txt = this.comboBox.getItem(i);
                this.store.setValue(String.valueOf(this.id) + TAG_COMBO + i, txt);
                ++i;
            }
            while (i < this.MAX_HISTORY_SIZE) {
                this.store.setValue(String.valueOf(this.id) + TAG_COMBO + i, " ");
                ++i;
            }
        }
        if (this.doc != null && this.root != null) {
            NodeList nodeListColumns = this.root.getElementsByTagName("ComboHistory");
            i = 0;
            while (i < nodeListColumns.getLength()) {
                String idVal;
                Node n = nodeListColumns.item(i);
                NamedNodeMap attrs = n.getAttributes();
                Node idNode = attrs.getNamedItem("id");
                if (idNode != null && (idVal = XMLParser.getTextNodeValue((Node)idNode)) != null && idVal.equals(this.id)) {
                    this.root.removeChild(nodeListColumns.item(i));
                    break;
                }
                ++i;
            }
            Element group = this.doc.createElement("ComboHistory");
            this.root.appendChild(group);
            group.setAttribute("id", this.id);
            i = 0;
            while (i < this.comboBox.getItemCount()) {
                String txt = this.comboBox.getItem(i);
                Element entry = XMLParser.createTextElementAndValue((Document)this.doc, (Node)group, (String)"value", (String)txt);
                group.appendChild(entry);
                ++i;
            }
        }
    }

    protected void updateHistory() {
        String[] vals = this.comboBox.getItems();
        String curVal = this.comboBox.getText();
        int i = 0;
        while (i < vals.length) {
            if (vals[i].equals(curVal)) {
                this.comboBox.remove(i);
                break;
            }
            ++i;
        }
        this.comboBox.add(curVal, 0);
    }

    public Combo getCombo() {
        return this.comboBox;
    }

    public void setText(String s) {
        this.comboBox.setText(s);
    }

    public String getText() {
        return this.comboBox.getText();
    }
}

