/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.local.CLIListener;
import com.vmware.vide.utils.local.CLIServerProcess;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class CLIHelper {
    private MessageConsole console;
    private MessageConsoleStream consoleStream;
    protected CLIServerProcess process;

    public static MessageConsole getConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (existing[i] instanceof MessageConsole && name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public Job createCLIConsoleJob(final String cmd, String prompt, String cmdDir, String consoleName, final Runnable onEnd) {
        this.process = new CLIServerProcess();
        if (consoleName != null) {
            CLIListener cliListener = new CLIListener(){

                public void onLineReceived(final String line) {
                    if (line == null) {
                        return;
                    }
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!CLIHelper.this.consoleStream.isClosed()) {
                                CLIHelper.this.consoleStream.println(line);
                            }
                        }
                    });
                }
            };
            if (consoleName.isEmpty()) {
                consoleName = "org.eclipse.ui.console.ConsoleView";
            }
            this.console = CLIHelper.getConsole(consoleName);
            this.consoleStream = this.console.newMessageStream();
            this.process.addStderrListener(cliListener);
            this.process.addStdoutListener(cliListener);
        }
        if (cmdDir == null || cmdDir.isEmpty()) {
            cmdDir = System.getProperty("java.io.tmpdir");
        }
        final String finalCmdDir = cmdDir;
        Job job = new Job(prompt){

            protected IStatus run(IProgressMonitor monitor) {
                CLIHelper.this.process.runServer(cmd, finalCmdDir);
                CLIHelper.this.process.waitProcess(monitor);
                if (onEnd != null) {
                    onEnd.run();
                }
                if (CLIHelper.this.consoleStream != null && !CLIHelper.this.consoleStream.isClosed()) {
                    try {
                        CLIHelper.this.consoleStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return Status.OK_STATUS;
            }
        };
        return job;
    }

    public CLIServerProcess getCLIProcess() {
        return this.process;
    }
}

