/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ComboWithHistory {
    String historyId;
    IPreferenceStore store;
    Combo combo;

    public ComboWithHistory(Composite parent, IPreferenceStore store, String historyId) {
        this.combo = new Combo(parent, 0);
        this.store = store;
        this.historyId = historyId;
        String history = store.getString(String.valueOf(historyId) + ".elements");
        if (history != null && !history.isEmpty()) {
            String[] elements;
            String[] stringArray = elements = history.split("\b");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (!e.isEmpty()) {
                    this.combo.add(e);
                }
                ++n2;
            }
            String last = store.getString(String.valueOf(historyId) + ".last");
            if (last != null && !last.isEmpty()) {
                this.combo.setText(last);
            } else if (elements.length > 0) {
                this.combo.setText(elements[0]);
            }
        }
    }

    public void dispose() {
        this.saveHistory();
    }

    protected void updateHistory() {
        String s = this.combo.getText();
        if (s.trim().isEmpty()) {
            return;
        }
        int index = this.findInHistory(this.combo.getText());
        if (index < 0) {
            this.combo.add(s, 0);
        }
        this.store.setValue(String.valueOf(this.historyId) + ".last", s);
    }

    public int findInHistory(String s) {
        int count = this.combo.getItemCount();
        int i = 0;
        while (i < count) {
            if (this.combo.getItem(i).equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void saveHistory() {
        if (this.combo.isDisposed()) {
            return;
        }
        int count = this.combo.getItemCount();
        StringBuilder sb = new StringBuilder();
        String sep = "";
        int i = 0;
        while (i < count) {
            sb.append(sep);
            sb.append(this.combo.getItem(i));
            sep = "\b";
            ++i;
        }
        if (sb.length() > 0) {
            this.store.setValue(String.valueOf(this.historyId) + ".elements", sb.toString());
            this.store.setValue(String.valueOf(this.historyId) + ".last", this.combo.getText());
        }
    }

    public Combo getCombo() {
        return this.combo;
    }

    public String getText() {
        return this.combo.getText();
    }

    public void setText(String text) {
        this.combo.setText(text);
        if (this.findInHistory(text) < 0) {
            this.combo.add(text, 0);
        }
    }

    public void setLayoutData(GridData gd) {
        this.combo.setLayoutData((Object)gd);
    }
}

