/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.WBOption;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class DirectoryOption
extends WBOption {
    String value;
    Text text;
    Button browse;

    public DirectoryOption(final Composite composite, String labelValue, String id) {
        super(id);
        Label label = new Label(composite, 0);
        label.setText(labelValue);
        this.text = new Text(composite, 2048);
        GridData gd = new GridData(4, 0, true, false);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DirectoryOption.this.notifyModifyListeners(e);
            }
        });
        this.browse = new Button(composite, 8);
        this.browse.setText(" ... ");
        this.browse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(composite.getShell());
                dlg.setFilterPath(DirectoryOption.this.text.getText());
                String f = dlg.open();
                if (f == null) {
                    return;
                }
                String dirPath = dlg.getFilterPath();
                DirectoryOption.this.text.setText(dirPath);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Widget getWidget() {
        return this.text;
    }

    @Override
    public void setValue(String value) {
        this.text.setText(value);
    }

    @Override
    public String getValue() {
        final String[] result = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = DirectoryOption.this.text.getText();
            }
        });
        return result[0];
    }
}

