/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.Activator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIUtilsImages {
    private static final String BACKWARD_IMAGE_KEY = "backward";
    private static final String BACKWARD_IMAGE_FILE = "icons/backward_nav.gif";
    private static final String FORWARD_IMAGE_KEY = "forward";
    private static final String FORWARD_IMAGE_FILE = "icons/forward_nav.gif";
    private static final String REFRESH_IMAGE_KEY = "refresh";
    private static final String REFRESH_IMAGE_FILE = "icons/refresh.png";
    private static final String ASCENDING_IMAGE_KEY = "ascending";
    private static final String ASCENDING_IMAGE_FILE = "icons/down.gif";
    private static final String DESCENDING_IMAGE_KEY = "descending";
    private static final String DESCENDING_IMAGE_FILE = "icons/up.gif";
    private static final String EXPAND_ALL_IMAGE_KEY = "expandall";
    private static final String EXPAND_ALL_IMAGE_FILE = "icons/expandall.png";
    private static final String COLLAPSE_ALL_IMAGE_KEY = "collapseall";
    private static final String COLLAPSE_ALL_IMAGE_FILE = "icons/collapseall.png";
    private static final Map<String, String> imageFiles = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(UIUtilsImages.ASCENDING_IMAGE_KEY, UIUtilsImages.ASCENDING_IMAGE_FILE);
            this.put(UIUtilsImages.DESCENDING_IMAGE_KEY, UIUtilsImages.DESCENDING_IMAGE_FILE);
            this.put(UIUtilsImages.BACKWARD_IMAGE_KEY, UIUtilsImages.BACKWARD_IMAGE_FILE);
            this.put(UIUtilsImages.FORWARD_IMAGE_KEY, UIUtilsImages.FORWARD_IMAGE_FILE);
            this.put(UIUtilsImages.REFRESH_IMAGE_KEY, UIUtilsImages.REFRESH_IMAGE_FILE);
            this.put(UIUtilsImages.EXPAND_ALL_IMAGE_KEY, UIUtilsImages.EXPAND_ALL_IMAGE_FILE);
            this.put(UIUtilsImages.COLLAPSE_ALL_IMAGE_KEY, UIUtilsImages.COLLAPSE_ALL_IMAGE_FILE);
        }
    };

    protected static Image getImage(String key) {
        ImageRegistry imgReg = Activator.getDefault().getImageRegistry();
        Image image = imgReg.get(key);
        if (image == null) {
            image = Activator.getImageDescriptor(imageFiles.get(key)).createImage();
            imgReg.put(key, image);
        }
        return image;
    }

    public static ImageDescriptor getPreviousImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)BACKWARD_IMAGE_FILE);
    }

    public static ImageDescriptor getNextImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)FORWARD_IMAGE_FILE);
    }

    public static ImageDescriptor getRefreshImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)REFRESH_IMAGE_FILE);
    }

    public static ImageDescriptor getAscendingImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)ASCENDING_IMAGE_FILE);
    }

    public static ImageDescriptor getDescendingImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)DESCENDING_IMAGE_FILE);
    }

    public static ImageDescriptor getExpandAllImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)EXPAND_ALL_IMAGE_FILE);
    }

    public static ImageDescriptor getCollapseAllImageDescr() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.vmware.vide.utils.ui", (String)COLLAPSE_ALL_IMAGE_FILE);
    }

    public static Image getBackwardImage() {
        return UIUtilsImages.getImage(BACKWARD_IMAGE_KEY);
    }

    public static Image getForwardImage() {
        return UIUtilsImages.getImage(FORWARD_IMAGE_KEY);
    }

    public static Image getRefreshImage() {
        return UIUtilsImages.getImage(REFRESH_IMAGE_KEY);
    }

    public static Image getAscendingImage() {
        return UIUtilsImages.getImage(ASCENDING_IMAGE_KEY);
    }

    public static Image getDescendingImage() {
        return UIUtilsImages.getImage(DESCENDING_IMAGE_KEY);
    }

    public static Image getCollapseAllImage() {
        return UIUtilsImages.getImage(COLLAPSE_ALL_IMAGE_KEY);
    }

    public static Image getExpandAllImage() {
        return UIUtilsImages.getImage(EXPAND_ALL_IMAGE_KEY);
    }
}

