/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.BooleanOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class WBOption {
    String id;
    private static final String[] propertiesExtensions = new String[]{"*.properties", "*.*"};
    List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();

    public WBOption(String id) {
        this.id = id;
    }

    public abstract void setValue(String var1);

    public abstract String getValue();

    public String getId() {
        return this.id;
    }

    public static String readValuesFromFile(Map<String, WBOption> options, String path) {
        String f;
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog dlg = new FileDialog(shell, 4096);
        dlg.setFilterExtensions(propertiesExtensions);
        if (path != null) {
            File fp = new File(path);
            dlg.setFilterPath(fp.getParent());
            dlg.setFileName(fp.getName());
        }
        if ((f = dlg.open()) == null) {
            return null;
        }
        try {
            WBOption.readValuesFromFile(f, options);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)shell, (String)"I/O Error", (String)e.getMessage());
        }
        return f;
    }

    public static void readValuesFromFile(String f, Map<String, WBOption> options) throws Exception {
        try (BufferedReader rdr = null;){
            String line;
            rdr = new BufferedReader(new FileReader(f));
            while ((line = rdr.readLine()) != null) {
                WBOption option;
                String[] kv = line.split("=");
                if (kv.length != 2 || (option = options.get(kv[0].trim())) == null) continue;
                option.setValue(kv[1].trim());
            }
        }
    }

    public static String writeValuesToFile(Map<String, WBOption> options, String path) {
        String f;
        Shell shell = Display.getDefault().getActiveShell();
        FileDialog dlg = new FileDialog(shell, 8192);
        dlg.setFilterExtensions(propertiesExtensions);
        if (path != null) {
            File fp = new File(path);
            dlg.setFilterPath(fp.getParent());
            dlg.setFileName(fp.getName());
        }
        if ((f = dlg.open()) == null) {
            return null;
        }
        try {
            WBOption.writeValuesToFile(f, options);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"I/O Error", (String)e.getMessage());
        }
        return f;
    }

    public static void writeValuesToFile(String path, Map<String, WBOption> options) throws IOException {
        try (OutputStreamWriter fw = null;){
            fw = new FileWriter(new File(path));
            Set<Map.Entry<String, WBOption>> entries = options.entrySet();
            for (Map.Entry<String, WBOption> entry : entries) {
                WBOption opt = entry.getValue();
                String value = opt.getValue();
                fw.write(opt.getId());
                fw.write("=");
                fw.write(value);
                fw.write("\n");
            }
            fw.flush();
        }
    }

    public static void addOptions(StringBuilder cli, Map<String, WBOption> options, Map<String, String> cliChars) {
        Set<Map.Entry<String, WBOption>> entries = options.entrySet();
        for (Map.Entry<String, WBOption> entry : entries) {
            WBOption opt = entry.getValue();
            String value = opt.getValue();
            if (value.isEmpty()) continue;
            if (opt instanceof BooleanOption) {
                if (value.equals("false")) continue;
                value = "";
            }
            cli.append(cliChars.get(opt.getId()));
            cli.append(" ");
            if (value.contains(" ")) {
                if (value.contains("\"")) {
                    cli.append("'");
                    cli.append(value);
                    cli.append("'");
                } else {
                    cli.append("\"");
                    cli.append(value);
                    cli.append("\"");
                }
            } else {
                cli.append(value);
            }
            cli.append(" ");
        }
    }

    public void addModifyListner(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void notifyModifyListeners(ModifyEvent e) {
        for (ModifyListener l : this.modifyListeners) {
            l.modifyText(e);
        }
    }
}

