/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import com.vmware.vide.utils.ui.WorkFlowState;
import com.vmware.vide.utils.xml.XMLParser;
import com.vmware.vide.utils.xml.XMLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WorkFlowManager {
    public ArrayList<WorkFlowState> states = new ArrayList();
    public ArrayList<WorkFlowState> flow;
    protected ArrayList<WorkFlowState> allStates = new ArrayList();

    public WorkFlowManager() {
        this.flow = new ArrayList();
    }

    public void loadPages(String fname) {
        try {
            Node cleanNode;
            URL url = new URL(fname);
            InputStream stream = url.openConnection().getInputStream();
            Document doc = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            dbf.setIgnoringComments(true);
            doc = db.parse(stream);
            Node root = doc.getFirstChild();
            if (root == null) {
                return;
            }
            Node flowRoot = XMLUtil.getChildNamed((String)"flow", (Node)root);
            if (flowRoot == null) {
                return;
            }
            ArrayList pages = XMLUtil.getAllChildrenNamed((String)"state", (Node)root);
            for (Node p : pages) {
                ArrayList parameterNodes;
                Node id = XMLUtil.getChildNamed((String)"id", (Node)p);
                if (id == null) continue;
                String idValue = XMLParser.getTextNodeValue((Node)id);
                Node cls = XMLUtil.getChildNamed((String)"class", (Node)p);
                if (cls == null) continue;
                String className = XMLParser.getTextNodeValue((Node)cls);
                WorkFlowState wfs = new WorkFlowState(className);
                wfs.name = idValue;
                this.states.add(wfs);
                cls = XMLUtil.getChildNamed((String)"provider", (Node)p);
                if (cls != null) {
                    className = XMLParser.getTextNodeValue((Node)cls);
                    wfs.setProvider(className);
                }
                if ((cls = XMLUtil.getChildNamed((String)"activator", (Node)p)) != null) {
                    className = XMLParser.getTextNodeValue((Node)cls);
                    wfs.setActivator(className);
                }
                if ((parameterNodes = XMLUtil.getAllChildrenNamed((String)"parameter", (Node)p)) == null) continue;
                ArrayList<String> parameters = new ArrayList<String>();
                for (Node parameterValues : parameterNodes) {
                    parameters.add(XMLParser.getTextNodeValue((Node)parameterValues));
                }
                wfs.setConstructorParameters(parameters);
            }
            NamedNodeMap attrs = flowRoot.getAttributes();
            if (attrs != null && (cleanNode = attrs.getNamedItem("full")) != null) {
                this.allStates.clear();
            }
            pages = XMLUtil.getAllChildrenNamed((String)"state", (Node)flowRoot);
            for (Node p : pages) {
                Node idNode;
                attrs = p.getAttributes();
                if (attrs == null || (idNode = attrs.getNamedItem("id")) == null) continue;
                String id = idNode.getTextContent();
                for (WorkFlowState st : this.states) {
                    if (!st.name.equals(id)) continue;
                    this.allStates.add(st);
                    Node anchor = attrs.getNamedItem("before");
                    if (anchor != null) {
                        st.position = -1;
                        st.positionAnchor = anchor.getTextContent();
                    }
                    if ((anchor = attrs.getNamedItem("after")) != null) {
                        st.position = 1;
                        st.positionAnchor = anchor.getTextContent();
                    }
                    if ((anchor = attrs.getNamedItem("replace")) != null) {
                        st.position = 2;
                        st.positionAnchor = anchor.getTextContent();
                    }
                    ArrayList params = XMLUtil.getAllChildrenNamed((String)"param", (Node)p);
                    for (Node n : params) {
                        String paramName = XMLUtil.getChildValue((String)"name", (Node)n);
                        String paramVal = XMLUtil.getChildValue((String)"value", (Node)n);
                        if (paramName.isEmpty() || paramVal.isEmpty()) continue;
                        st.stateParams.put(paramName, paramVal);
                    }
                }
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPages() {
        int x = 0;
        for (WorkFlowState st : this.allStates) {
            if (st.position != 0) continue;
            this.flow.add(st);
        }
        block1: for (WorkFlowState st : this.allStates) {
            if (st.position == 0) continue;
            x = 0;
            for (WorkFlowState anchorState : this.flow) {
                if (!anchorState.name.equals(st.positionAnchor)) {
                    ++x;
                    continue;
                }
                if (st.position == 2) {
                    this.flow.set(x, st);
                    continue block1;
                }
                if (st.position == 1) {
                    ++x;
                }
                if (x >= this.flow.size()) {
                    this.flow.add(st);
                    continue block1;
                }
                this.flow.add(x, st);
                continue block1;
            }
        }
        x = 0;
        while (x < this.flow.size()) {
            WorkFlowState st;
            st = this.flow.get(x);
            if (st.create() == null) {
                this.flow.remove(x);
                continue;
            }
            ++x;
        }
    }
}

