/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Composite;
import org.osgi.framework.Bundle;

public class WorkFlowState {
    public static final int POS_BEFORE = -1;
    public static final int POS_ANY = 0;
    public static final int POS_AFTER = 1;
    public static final int POS_AT = 2;
    public String name;
    public String className;
    public Object instance;
    public int position;
    public String positionAnchor;
    public HashMap<String, String> stateParams;
    protected String provider;
    protected String activator;
    protected Object hidden;
    protected Object required;
    public ArrayList<String> constructorArguments;

    public WorkFlowState(String className) {
        this.className = className;
        this.activator = "Activator";
        this.stateParams = new HashMap();
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setConstructorParameters(ArrayList<String> constuctorparameters) {
        this.constructorArguments = constuctorparameters;
    }

    public void setActivator(String activator) {
        this.activator = activator;
    }

    public boolean isHidden() {
        if (this.hidden != null) {
            return (Boolean)this.hidden;
        }
        Object retval = this.invokeMethod("isHidden", true, null, null);
        if (retval != null && retval instanceof Boolean) {
            this.hidden = retval;
            return (Boolean)this.hidden;
        }
        return false;
    }

    public boolean isRequired() {
        if (this.required != null) {
            return (Boolean)this.required;
        }
        Object retval = this.invokeMethod("isRequired", true, null, null);
        if (retval != null && retval instanceof Boolean) {
            this.required = retval;
            return (Boolean)retval;
        }
        return true;
    }

    public boolean isWorking() {
        return false;
    }

    public boolean isValid() {
        Object retval = this.invokeMethod("isValid", true, null, null);
        if (retval != null && retval instanceof Boolean) {
            return (Boolean)retval;
        }
        return true;
    }

    public boolean setParameters(Map<String, String> params) {
        HashMap<String, String> realParams = new HashMap<String, String>();
        realParams.putAll(params);
        realParams.putAll(this.stateParams);
        Class[] argTypes = new Class[]{params.getClass()};
        Object[] argVals = new Object[]{realParams};
        Object retval = this.invokeMethod("setParameters", true, argTypes, argVals);
        if (retval != null && retval instanceof Boolean) {
            return (Boolean)retval;
        }
        return true;
    }

    public boolean init(Composite parent) {
        Class[] argTypes = new Class[]{Composite.class};
        Object[] argVals = new Object[]{parent};
        Object retval = this.invokeMethod("init", false, argTypes, argVals);
        if (retval != null && retval instanceof Boolean) {
            return (Boolean)retval;
        }
        return true;
    }

    public Object create() {
        return this.invokeMethod(null, false, null, null);
    }

    public Object invokeMethod(String methodName, boolean optional, Class<?>[] argTypes, Object[] argVals) {
        ClassLoader ldr = null;
        if (this.provider != null) {
            String controllerClassName = String.valueOf(this.provider) + "." + this.activator;
            Bundle bundle = Platform.getBundle((String)this.provider);
            try {
                Class controllerClass = bundle.loadClass(controllerClassName);
                ldr = controllerClass.getClassLoader();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        try {
            Class<?> cs = null;
            if (this.instance == null) {
                cs = ldr == null ? Class.forName(this.className) : Class.forName(this.className, true, ldr);
                Object classObj = null;
                if (this.constructorArguments.size() != 0) {
                    Class[] argtypes = new Class[this.constructorArguments.size()];
                    int i = 0;
                    while (i < argtypes.length) {
                        argtypes[i] = String.class;
                        ++i;
                    }
                    Object[] argValues = this.constructorArguments.toArray();
                    classObj = cs.getConstructor(argtypes).newInstance(argValues);
                } else {
                    classObj = cs.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                this.instance = classObj;
            } else {
                cs = this.instance.getClass();
            }
            if (methodName == null) {
                return this.instance;
            }
            Method m = cs.getMethod(methodName, argTypes);
            Object retval = m.invoke(this.instance, argVals);
            return retval;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            if (!optional) {
                e.printStackTrace();
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }
}

