/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.utils.ui.supportbundle;

import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportBundleCreationJob
extends Job {
    private static final Logger logger = LoggerFactory.getLogger(SupportBundleCreationJob.class);
    private final File outputFile;
    private final List<ISupportBundleContribution> contributions;
    private final DoneListener doneListener;

    public SupportBundleCreationJob(String name, File outputFile, List<ISupportBundleContribution> contributions, DoneListener doneListener) {
        super(name);
        this.outputFile = outputFile;
        this.contributions = contributions;
        this.doneListener = doneListener;
    }

    protected IStatus run(IProgressMonitor monitor) {
        int status = 0;
        Exception errorDuringCreation = null;
        String errorMessage = null;
        ZipOutputStream stream = null;
        try {
            stream = new ZipOutputStream(new FileOutputStream(this.outputFile));
            monitor.beginTask("Creating " + this.outputFile.getName(), this.contributions.size());
            for (ISupportBundleContribution contribution : this.contributions) {
                InputStream is = contribution.getInputStream();
                if (is != null) {
                    monitor.subTask("Compressing " + contribution.getName() + " ...");
                    ZipEntry entry = new ZipEntry(contribution.getName());
                    stream.putNextEntry(entry);
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)stream);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    stream.closeEntry();
                } else {
                    logger.info("support bundle contribution '{}' returned null input stream", (Object)contribution.getName());
                }
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                status = 8;
                break;
            }
        }
        catch (Exception e) {
            errorMessage = "Exception while creating support bundle: " + e.getMessage();
            errorDuringCreation = e;
            status = 4;
        }
        if (stream != null) {
            IOUtils.closeQuietly((OutputStream)stream);
        }
        monitor.done();
        if (this.doneListener != null) {
            this.doneListener.bundleCreationComplete(this.outputFile.getAbsolutePath(), errorMessage, errorDuringCreation);
        }
        return new Status(status, "com.vmware.vide.utils.ui", 0, errorMessage, (Throwable)errorDuringCreation);
    }

    public static interface DoneListener {
        public void bundleCreationComplete(String var1, String var2, Throwable var3);
    }
}

