/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging.listener;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformLogListener
implements ILogListener {
    private static final String LOG_FORMAT = "{}: {}";
    private static final Logger logger = LoggerFactory.getLogger(PlatformLogListener.class);

    public void logging(IStatus status, String plugin) {
        switch (status.getSeverity()) {
            case 1: {
                if (status.getException() == null) {
                    logger.info(LOG_FORMAT, (Object)status.getPlugin(), (Object)status.getMessage());
                    break;
                }
                logger.info(LOG_FORMAT, new Object[]{status.getPlugin(), status.getMessage(), status.getException()});
                break;
            }
            case 2: {
                if (status.getException() == null) {
                    logger.warn(LOG_FORMAT, (Object)status.getPlugin(), (Object)status.getMessage());
                    break;
                }
                logger.warn(LOG_FORMAT, new Object[]{status.getPlugin(), status.getMessage(), status.getException()});
                break;
            }
            case 4: {
                if (status.getException() == null) {
                    logger.error(LOG_FORMAT, (Object)status.getPlugin(), (Object)status.getMessage());
                    break;
                }
                logger.error(LOG_FORMAT, new Object[]{status.getPlugin(), status.getMessage(), status.getException()});
                break;
            }
            default: {
                if (status.getException() == null) {
                    logger.debug(LOG_FORMAT, (Object)status.getPlugin(), (Object)status.getMessage());
                    break;
                }
                logger.debug(LOG_FORMAT, new Object[]{status.getPlugin(), status.getMessage(), status.getException()});
            }
        }
    }
}

