/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.logging.supportbundle;

import com.vmware.vide.logging.supportbundle.ISupportBundleContribution;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileBundleContribution
implements ISupportBundleContribution {
    private final File file;
    private final String name;
    private final String description;

    public FileBundleContribution(File f) {
        this.file = f;
        this.description = this.name = this.file.getName();
    }

    public FileBundleContribution(File f, String name) {
        this.file = f;
        this.name = name;
        this.description = name;
    }

    public FileBundleContribution(File f, String name, String description) {
        this.file = f;
        this.name = name;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            String message = "Unable to include file '" + this.file.getAbsolutePath() + "' in WB log bundle.  This might be normal depending on the platform and configuration.  Exception='" + e.getMessage();
            System.err.println(message);
            return null;
        }
    }
}

