/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.ui.chart.LogDatasetManager;
import java.util.ArrayList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;

public class DomainAxisChangeManager
implements SelectionListener,
AxisChangeListener {
    public static final String ZOOM_BACK = "Zoom Back";
    public static final String ZOOM_FORWARD = "Zoom Forward";
    private CombinedDomainXYPlot combinedDomainPlot;
    private LogDatasetManager logDatasetManager;
    private ArrayList<DateRange> stateList;
    private int currentState = 0;
    private boolean justInvokedBack = false;
    private boolean justInvokedForward = false;

    public DomainAxisChangeManager(CombinedDomainXYPlot combinedDomainPlot, LogDatasetManager logDatasetManager) {
        this.combinedDomainPlot = combinedDomainPlot;
        this.logDatasetManager = logDatasetManager;
        this.stateList = new ArrayList();
    }

    public void createZoomBackForwardButtons(Composite composite) {
        ImageRegistry registry = new ImageRegistry();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        registry.put(ZOOM_BACK, sharedImages.getImageDescriptor("IMG_TOOL_BACK"));
        registry.put(ZOOM_FORWARD, sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"));
        Button back = new Button(composite, 8);
        back.setData((Object)ZOOM_BACK);
        back.setToolTipText(ZOOM_BACK);
        back.setImage(registry.get(ZOOM_BACK));
        back.addSelectionListener((SelectionListener)this);
        Button forward = new Button(composite, 8);
        forward.setData((Object)ZOOM_FORWARD);
        forward.setToolTipText(ZOOM_FORWARD);
        forward.setImage(registry.get(ZOOM_FORWARD));
        forward.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        DateAxis domainAxis;
        if (this.combinedDomainPlot.getSubplots().size() > 0 && (domainAxis = (DateAxis)this.combinedDomainPlot.getDomainAxis()) != null) {
            Button button = (Button)e.widget;
            String command = (String)button.getData();
            if (command.equals(ZOOM_BACK)) {
                if (this.currentState > 0) {
                    --this.currentState;
                    DateRange range = this.stateList.get(this.currentState);
                    this.justInvokedBack = true;
                    domainAxis.setRange((Range)range);
                }
            } else if (command.equals(ZOOM_FORWARD) && this.currentState < this.stateList.size() - 1) {
                ++this.currentState;
                DateRange range = this.stateList.get(this.currentState);
                this.justInvokedForward = true;
                domainAxis.setRange((Range)range);
            }
        }
    }

    public void axisChanged(AxisChangeEvent event) {
        if (event.getType().equals((Object)ChartChangeEventType.GENERAL)) {
            this.logDatasetManager.createSeries(this.combinedDomainPlot);
            if (this.justInvokedBack || this.justInvokedForward) {
                this.justInvokedBack = false;
                this.justInvokedForward = false;
            } else {
                DateAxis domainAxis = (DateAxis)event.getAxis();
                DateRange dateRange = (DateRange)domainAxis.getRange();
                int i = this.stateList.size() - 1;
                while (i > this.currentState) {
                    this.stateList.remove(i);
                    --i;
                }
                this.stateList.add(dateRange);
                this.currentState = this.stateList.size() - 1;
            }
        } else if (!event.getType().equals((Object)ChartChangeEventType.NEW_DATASET)) {
            event.getType().equals((Object)ChartChangeEventType.DATASET_UPDATED);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

