/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.chart;

import com.vmware.vide.vlogbrowser.core.chart.ILogFile;
import com.vmware.vide.vlogbrowser.core.chart.ILogItemListener;
import com.vmware.vide.vlogbrowser.ui.chart.LogSubplot;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.experimental.chart.swt.ChartComposite;

public class LogChartComposite
extends ChartComposite {
    private Point trackingMouseStart = new Point(0, 0);
    public transient List<ILogItemListener> listLogItemListener = new LinkedList<ILogItemListener>();

    public LogChartComposite(Composite comp, int style, JFreeChart chart, boolean useBuffer) {
        super(comp, style, chart, useBuffer);
    }

    public void mouseDown(MouseEvent event) {
        super.mouseDown(event);
        this.trackingMouseStart = new Point(event.x, event.y);
    }

    public void mouseUp(MouseEvent event) {
        PlotEntity plotEntity;
        Plot plot;
        ChartRenderingInfo info;
        EntityCollection entities;
        ChartEntity entity;
        super.mouseUp(event);
        if (this.trackingMouseStart.x == event.x && this.trackingMouseStart.y == event.y && (entity = (entities = (info = this.getChartRenderingInfo()).getEntityCollection()).getEntity((double)((int)((double)(event.x - this.getClientArea().x) / this.getScaleX())), (double)((int)((double)(event.y - this.getClientArea().y) / this.getScaleY())))) instanceof PlotEntity && (plot = (plotEntity = (PlotEntity)entity).getPlot()) instanceof LogSubplot) {
            LogSubplot subplot = (LogSubplot)plot;
            double crosshair = subplot.getDomainCrosshairValue();
            Date logDate = new Date((long)crosshair);
            this.notifyListeners(subplot.getLogFile(), logDate);
        }
    }

    public void addLogItemListener(ILogItemListener listener) {
        this.listLogItemListener.add(listener);
    }

    public synchronized void removeLogItemListener(ILogItemListener listener) {
        this.listLogItemListener.remove(listener);
    }

    protected void notifyListeners(ILogFile logFile, Date date) {
        for (ILogItemListener listener : this.listLogItemListener) {
            listener.mouseClicked(logFile, date);
        }
    }
}

