/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.model.FilterItem;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.ui.dialogs.FilterDialogRow;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FilterDialog
extends Dialog {
    public static final String EXT = ".logx";
    public static final String DIALOG_TITLE = "Keyword Filtering with a Named Filter";
    public static final String FILTER_LABEL = "Save and Filter";
    public static final String UNFILTER_LABEL = "Unfilter and Clear Form";
    public static final String NAMED_FLTRS_COMBO_LABEL = "Named Filters";
    public static final String NAMED_FLTRS_TOOLTIP = "Choose a saved filter from the 'Named Filters' drop-down list, or type a new filter name in the same location; 'Named Filters' is also an editable text box.";
    public static final String RADIO_GROUP_LABEL = "Choose a Filter Source";
    public static final String BUTTON_THIS_LOGX_FILE = "This .logx file";
    public static final String BUTTON_THIS_LOGX_TOOLTIP = "In addition to describing how to display the log files in this vLogBrowser window, this .logx file can also store a collection of named filters.";
    public static final String BUTTON_FILTERS_FILE = "Filters file:";
    public static final String BUTTON_FILTERS_TOOLTIP = "The 'Named Filters' drop-down list will be disabled unless a *.logx or *.xml file path is present in this text box.";
    public static final String FILTERS_TOOLTIP = "This field is not editable. Use the 'Browse...' button to fill in this field with the full path of a *.logx or *.xml file.";
    public static final String FILE_OPEN_TITLE = "Choose a .xml or .logx file containing vLogBrowser Filters";
    public static final String BUTTON_BROWSE = "Browse...";
    public static final String BUTTON_BROWSE_TOOLTIP = "Only one file can be selected at a time. If you choose a file that does not contain filters, the 'Named Filters' drop-down list will be grayed out.";
    public static final String FORM_INSTRUCTIONS = "Edit or accept a set of keywords connected together with AND/OR, ensure that the filter\n is named, and click 'Save and Filter' to see only log entries that match that criteria.";
    public static final String BUTTON_OTHER_OPEN_LOGX = "Other open .logx files";
    public static final String CLEAR_FORM_BTN_LABEL = "Clear Form";
    public static final String CLEAR_FORM_TOOLTIP = "Click for a blank filter form. Note: This will not unfilter the log table or delete the named filter.";
    public static final String SAVE_BTN_LABEL = "Save";
    public static final String SAVE_BTN_DEFAULT_TOOLTIP = "Save the form as a filter in this .logx file under the name specified in the 'Named Filters' text box.";
    public static final String SAVE_BTN_ALTERNATE_TOOLTIP = "Make a copy of this external set of filter criteria, saving it in this .logx file under the specified name. This will allow it to be edited and/or applied to the log.";
    public static final String BUTTON_OTHER_LOGX_TOOLTIP = "If you choose a file that does not contain filters, the 'Named Filters' drop-down list will be grayed out.";
    public static final String DELETE_BTN_LABEL = "Delete Filter";
    public static final String DELETE_BTN_TOOLTIP = "Although the filter will be removed from the list of named filters in this .logx file, this will not unfilter the log entry table; use the 'Unfilter and Clear Form' button below to accomplish that.";
    public static final String THIS_LOGX_INSTRUCTIONS = "Choose a filter from this .logx file using the 'Named Filters' drop-down list. These filters can be\nedited or applied to the log table.";
    public static final String EXTERNAL_FILE_INSTRUCTIONS = "Browse for a *.logx or *.xml file containing filters, then choose a filter to view using the\n'Named Filters' drop-down list. Filters from external files must be saved to this .logx file before\nediting or applying to the log.";
    public static final String OTHER_LOGX_INSTRUCTIONS = "Choose another open .logx file, then choose a filter to view using the 'Named Filters'\ndrop-down list. Filters from other open .logx files must be saved to this .logx file before\nediting or applying to the log.";
    public static final String ADD_LINES_LABEL = "Include # Surrounding Lines: ";
    public static final String ADD_LINES_TOOLTIP_TEXT = "Number of immediately surrounding log entries displayed before and after log entries that match the filter";
    public static final int FILTER_BTN_ID = 1025;
    public static final int UNFILTER_BTN_ID = 1026;
    private LogFilter myLogFilter;
    private LogBrowserEditor myEditor;
    private Map<String, LogFilter> namedLogFilters;
    private String externalFiltersFilePath;
    private Map<String, LogFilter> externalLogFilters;
    private Composite headerComposite;
    private Composite innerComposite;
    private ScrolledComposite scrolledComposite;
    private Font parensFont;
    private Button btnThisLogxFile;
    private Button btnFiltersFile;
    private Button btnOtherLogxFiles;
    private Text txtFiltersFile;
    private Label lblRadioInstructions;
    private Button btnBrowse;
    private Label lblFormInstructions;
    private Button btnDeleteFilter;
    private Button btnSaveFilter;
    private Button btnClearForm;
    private String lastButtonPushed;
    private Combo cboAddLines;
    private Combo cboOtherLogxFiles;
    private Combo cboFilters;
    private Shell parentShell;
    private List<FilterDialogRow> myFilterDialogRows;
    private int gridLayoutColumnCount;

    public FilterDialog(Shell parentShell, LogFilter myLogFilter, Map<String, LogFilter> namedLogFilters, String externalFiltersFilePath, LogBrowserEditor vlbEditor) {
        super(parentShell);
        this.parentShell = parentShell;
        this.myLogFilter = myLogFilter;
        this.lastButtonPushed = "";
        this.namedLogFilters = namedLogFilters;
        this.externalFiltersFilePath = externalFiltersFilePath;
        this.myEditor = vlbEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite outerDialogComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        outerDialogComposite.setLayout((Layout)gridLayout);
        this.headerComposite = new Composite(outerDialogComposite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        this.headerComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        this.headerComposite.setLayout((Layout)gridLayout);
        Group radioGroup = new Group(this.headerComposite, 0);
        radioGroup.setText(RADIO_GROUP_LABEL);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 10;
        radioGroup.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        radioGroup.setLayout((Layout)gridLayout);
        this.btnThisLogxFile = new Button((Composite)radioGroup, 16);
        this.btnThisLogxFile.setText(BUTTON_THIS_LOGX_FILE);
        this.btnThisLogxFile.setToolTipText(BUTTON_THIS_LOGX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.grabExcessHorizontalSpace = true;
        this.btnThisLogxFile.setLayoutData((Object)gridData);
        this.btnThisLogxFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.btnFiltersFile = new Button((Composite)radioGroup, 16);
        this.btnFiltersFile.setText(BUTTON_FILTERS_FILE);
        this.btnFiltersFile.setToolTipText(BUTTON_FILTERS_TOOLTIP);
        this.btnFiltersFile.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.txtFiltersFile = new Text((Composite)radioGroup, 2048);
        this.txtFiltersFile.setEditable(false);
        this.txtFiltersFile.setToolTipText(FILTERS_TOOLTIP);
        gridData = new GridData();
        gridData.widthHint = 240;
        this.txtFiltersFile.setLayoutData((Object)gridData);
        this.btnBrowse = new Button((Composite)radioGroup, 8);
        this.btnBrowse.setText(BUTTON_BROWSE);
        this.btnBrowse.setToolTipText(BUTTON_BROWSE_TOOLTIP);
        this.btnBrowse.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filePath;
                FilterDialog.this.btnFiltersFile.setSelection(true);
                FilterDialog.this.btnThisLogxFile.setSelection(false);
                FilterDialog.this.btnOtherLogxFiles.setSelection(false);
                Shell outerShell = FilterDialog.this.headerComposite.getShell();
                FileDialog fileDialog = new FileDialog(outerShell, 0);
                fileDialog.setText(FilterDialog.FILE_OPEN_TITLE);
                fileDialog.setFilterExtensions(new String[]{"*.logx;*.xml"});
                File prevFilterFile = new File(FilterDialog.this.externalFiltersFilePath);
                if (prevFilterFile != null && prevFilterFile.exists()) {
                    fileDialog.setFilterPath(prevFilterFile.getParent());
                } else {
                    String cfgParentStr = new File(FilterDialog.this.myEditor.getConfigFilePath()).getParent();
                    if (cfgParentStr != null && !cfgParentStr.isEmpty()) {
                        fileDialog.setFilterPath(cfgParentStr);
                    }
                }
                if (fileDialog.open() != null && (filePath = fileDialog.getFileName()) != null && !filePath.isEmpty()) {
                    FilterDialog.this.externalFiltersFilePath = String.valueOf(fileDialog.getFilterPath()) + File.separator + filePath;
                    FilterDialog.this.txtFiltersFile.setText(FilterDialog.this.externalFiltersFilePath);
                    try {
                        FilterDialog.this.externalLogFilters = FilterDialog.this.getLogFilters(FilterDialog.this.externalFiltersFilePath);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)FilterDialog.this.parentShell, (String)"Error", (String)("An error was caught while trying to load external log filters: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.btnOtherLogxFiles = new Button((Composite)radioGroup, 16);
        this.btnOtherLogxFiles.setText(BUTTON_OTHER_OPEN_LOGX);
        this.btnOtherLogxFiles.setToolTipText(BUTTON_OTHER_LOGX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        this.btnOtherLogxFiles.setLayoutData((Object)gridData);
        this.btnOtherLogxFiles.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.cboOtherLogxFiles = new Combo((Composite)radioGroup, 12);
        this.cboOtherLogxFiles.setToolTipText(BUTTON_OTHER_LOGX_TOOLTIP);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.horizontalSpan = 3;
        gridData.widthHint = 400;
        this.cboOtherLogxFiles.setLayoutData((Object)gridData);
        this.cboOtherLogxFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDialog.this.btnOtherLogxFiles.setSelection(true);
                FilterDialog.this.btnThisLogxFile.setSelection(false);
                FilterDialog.this.btnFiltersFile.setSelection(false);
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.lblRadioInstructions = new Label((Composite)radioGroup, 0);
        this.lblRadioInstructions.setText(THIS_LOGX_INSTRUCTIONS);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 16384;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 10;
        gridData.heightHint = 60;
        this.lblRadioInstructions.setLayoutData((Object)gridData);
        Label lblNamedFilters = new Label(this.headerComposite, 0);
        lblNamedFilters.setText(NAMED_FLTRS_COMBO_LABEL);
        lblNamedFilters.setToolTipText(NAMED_FLTRS_TOOLTIP);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        lblNamedFilters.setLayoutData((Object)gridData);
        this.cboFilters = new Combo(this.headerComposite, 4);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        gridData.widthHint = 150;
        this.cboFilters.setLayoutData((Object)gridData);
        this.cboFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterDialog.this.cboFiltersSelectionChanged();
            }
        });
        this.btnClearForm = new Button(this.headerComposite, 8);
        this.btnClearForm.setText(CLEAR_FORM_BTN_LABEL);
        this.btnClearForm.setToolTipText(CLEAR_FORM_TOOLTIP);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        this.btnClearForm.setLayoutData((Object)gridData);
        this.btnClearForm.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.cboFilters.setText("");
                FilterDialog.this.cboFiltersSelectionChanged();
            }
        });
        this.btnSaveFilter = new Button(this.headerComposite, 8);
        this.btnSaveFilter.setText(SAVE_BTN_LABEL);
        this.btnSaveFilter.setToolTipText(SAVE_BTN_DEFAULT_TOOLTIP);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        this.btnSaveFilter.setLayoutData((Object)gridData);
        this.btnSaveFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    FilterDialog.this.myLogFilter = FilterDialog.this.saveLogFilter();
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)FilterDialog.this.getShell(), (String)"Cannot Save Filter", (String)e.getMessage());
                    return;
                }
                FilterDialog.this.btnThisLogxFile.setSelection(true);
                FilterDialog.this.btnFiltersFile.setSelection(false);
                FilterDialog.this.btnOtherLogxFiles.setSelection(false);
                FilterDialog.this.radioGroupChanged();
            }
        });
        this.btnDeleteFilter = new Button(this.headerComposite, 8);
        this.btnDeleteFilter.setText(DELETE_BTN_LABEL);
        this.btnDeleteFilter.setToolTipText(DELETE_BTN_TOOLTIP);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        this.btnDeleteFilter.setLayoutData((Object)gridData);
        this.btnDeleteFilter.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filterName = FilterDialog.this.cboFilters.getText().trim();
                if (!filterName.isEmpty()) {
                    if (FilterDialog.this.myLogFilter.getName().equals(filterName) && FilterDialog.this.myLogFilter.isFilterEnabled()) {
                        MessageDialog.openError((Shell)FilterDialog.this.getShell(), (String)"Cannot Delete Filter", (String)"Cannot remove a filter that is currently in use.\nPlease click 'Unfilter and Clear Form' then try again.");
                        return;
                    }
                    FilterDialog.this.namedLogFilters.remove(filterName);
                    try {
                        FilterDialog.this.myEditor.deleteLogFilter(filterName);
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)FilterDialog.this.getShell(), (String)"Cannot Delete Filter", (String)("Cannot remove filter from the .logx config file itself due to an error: " + e.getMessage()));
                        e.printStackTrace();
                    }
                    FilterDialog.this.myLogFilter = null;
                    FilterDialog.this.populateCboFilters();
                }
            }
        });
        this.lblFormInstructions = new Label(this.headerComposite, 0);
        this.lblFormInstructions.setText(FORM_INSTRUCTIONS);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalIndent = 10;
        this.lblFormInstructions.setLayoutData((Object)gridData);
        this.scrolledComposite = new ScrolledComposite(outerDialogComposite, 2560);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        gridData.heightHint = 250;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        this.scrolledComposite.setLayoutData((Object)gridData);
        this.gridLayoutColumnCount = 9;
        this.innerComposite = new Composite((Composite)this.scrolledComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = this.gridLayoutColumnCount;
        this.innerComposite.setLayout((Layout)gridLayout);
        this.myFilterDialogRows = new ArrayList<FilterDialogRow>();
        this.scrolledComposite.setContent((Control)this.innerComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.innerComposite.pack();
        Composite footerComposite = new Composite(outerDialogComposite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        footerComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        footerComposite.setLayout((Layout)gridLayout);
        Label lblIncludeSurrndLns = new Label(footerComposite, 131072);
        lblIncludeSurrndLns.setText(ADD_LINES_LABEL);
        gridData = new GridData();
        gridData.verticalIndent = 10;
        gridData.horizontalAlignment = 131072;
        lblIncludeSurrndLns.setLayoutData((Object)gridData);
        this.cboAddLines = new Combo(footerComposite, 12);
        this.cboAddLines.setItems(LogBrowserConsts.ADD_LINES_VALUES);
        this.cboAddLines.setToolTipText(ADD_LINES_TOOLTIP_TEXT);
        this.cboAddLines.pack();
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalIndent = 10;
        this.cboAddLines.setLayoutData((Object)gridData);
        this.parensFont = new Font(null, "Arial", 18, 1);
        this.initRadioGroup();
        this.myFilterDialogRows.get(0).setFocus(0);
        return outerDialogComposite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 1025, FILTER_LABEL, true);
        this.createButton(parent, 1026, UNFILTER_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 1025) {
            try {
                this.myLogFilter = this.saveLogFilter();
                this.lastButtonPushed = FILTER_LABEL;
                this.myLogFilter.setFilterEnabled(true);
                this.parensFont.dispose();
                super.okPressed();
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Cannot Set Filter", (String)e.getMessage());
                return;
            }
        } else if (buttonType == 1026) {
            this.myLogFilter = new LogFilter("", 0, 2);
            this.myLogFilter.setFilterEnabled(false);
            this.lastButtonPushed = UNFILTER_LABEL;
            this.parensFont.dispose();
            super.okPressed();
        } else {
            this.parensFont.dispose();
            super.cancelPressed();
        }
    }

    public String getFilterText() {
        try {
            return this.myLogFilter.getFirstKeyword();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.parentShell, (String)"Error", (String)("While checking the filter keyword, an error occurred: " + e.getMessage()));
            e.printStackTrace();
            return "";
        }
    }

    public String getFilterLines() {
        return Integer.toString(this.myLogFilter.getNumSurroundingLines());
    }

    public String getLastButtonPushed() {
        return this.lastButtonPushed;
    }

    public LogFilter getMyLogFilter() {
        return this.myLogFilter;
    }

    private void initFormFromLogFilterObj(LogFilter logFilter) {
        try {
            int rowNum = 0;
            while (rowNum < logFilter.getNumRows()) {
                FilterDialogRow filterDialogRow = new FilterDialogRow(this.innerComposite, rowNum == 0, 2, this.parensFont, new MyExpansionListener(rowNum), this.gridLayoutColumnCount);
                int columnNum = 0;
                while (columnNum < 2) {
                    FilterItem filterItem = logFilter.getFilterItem(rowNum, columnNum);
                    if (rowNum > 0 || columnNum > 0) {
                        filterDialogRow.setBooleanConn(columnNum, filterItem.getBoolConnector());
                    }
                    filterDialogRow.setNegationFlag(columnNum, filterItem.isNegateFlagSet());
                    filterDialogRow.setKeyword(columnNum, filterItem.getKeyword());
                    filterDialogRow.setRegExFlag(columnNum, filterItem.isRegexFlagSet());
                    ++columnNum;
                }
                this.myFilterDialogRows.add(filterDialogRow);
                ++rowNum;
            }
            this.cboFilters.setText(logFilter.getName());
            this.cboAddLines.setText(Integer.toString(logFilter.getNumSurroundingLines()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.parentShell, (String)"Error", (String)("Error encountered while loading Filter form from Log Filter object: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private void addEmptyDialogRowToGUI() {
        FilterDialogRow filterDialogRow = new FilterDialogRow(this.innerComposite, this.myFilterDialogRows.size() == 0, 2, this.parensFont, new MyExpansionListener(this.myFilterDialogRows.size()), this.gridLayoutColumnCount);
        this.myFilterDialogRows.add(filterDialogRow);
        this.innerComposite.pack();
    }

    private void loadLogFilterObjFromForm(LogFilter logFilter) {
        try {
            int rowNum = 0;
            while (rowNum < this.myFilterDialogRows.size() - 1) {
                int columnCount = this.myFilterDialogRows.get(rowNum).getColumnCount();
                int columnNum = 0;
                while (columnNum < columnCount) {
                    FilterDialogRow filterDialogRow = this.myFilterDialogRows.get(rowNum);
                    FilterItem filterItem = new FilterItem();
                    if (rowNum > 0 || columnNum > 0) {
                        filterItem.setBoolConnector(filterDialogRow.getBooleanConn(columnNum));
                    }
                    filterItem.setNegateFlag(filterDialogRow.getNegationFlag(columnNum));
                    filterItem.setKeyword(filterDialogRow.getKeyword(columnNum));
                    filterItem.setRegexFlag(filterDialogRow.getRegExFlag(columnNum));
                    logFilter.setFilterItem(rowNum, columnNum, filterItem);
                    ++columnNum;
                }
                ++rowNum;
            }
            logFilter.setName(this.cboFilters.getText().trim());
            logFilter.setNumSurroundingLines(Integer.parseInt(this.cboAddLines.getText()));
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.parentShell, (String)"Error", (String)("Error encountered while loading Log Filter object from Filter form: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    private LogFilter buildLogFilterObj(String filterName) {
        LogFilter newLogFilter = new LogFilter(filterName, 0, 2);
        this.loadLogFilterObjFromForm(newLogFilter);
        this.namedLogFilters.put(filterName, newLogFilter);
        return newLogFilter;
    }

    private LogFilter saveLogFilter() throws Exception {
        String filterName = this.cboFilters.getText().trim();
        if (filterName.isEmpty()) {
            throw new Exception("Cannot save an unnamed filter. Please name the filter and try again.");
        }
        String firstKeyword = this.myFilterDialogRows.get(0).getKeyword(0).trim();
        if (firstKeyword.isEmpty()) {
            throw new Exception("Cannot save a blank filter. Please provide a keyword in the first textbox and try again.");
        }
        LogFilter newLogFilter = this.buildLogFilterObj(filterName);
        this.myEditor.saveLogFilter(newLogFilter);
        return newLogFilter;
    }

    private void setFilterCriteriaEnabled(boolean enabled) {
        for (FilterDialogRow row : this.myFilterDialogRows) {
            row.setEnabled(enabled);
        }
        this.cboAddLines.setEnabled(enabled);
    }

    private void initRadioGroup() {
        String[] otherOpenEditors = this.myEditor.getOtherOpenVLBEditorNames();
        if (otherOpenEditors.length > 0) {
            this.cboOtherLogxFiles.setItems(otherOpenEditors);
            this.cboOtherLogxFiles.setText(this.cboOtherLogxFiles.getItem(0));
        } else {
            this.btnOtherLogxFiles.setEnabled(false);
            this.cboOtherLogxFiles.setEnabled(false);
        }
        this.txtFiltersFile.setText(this.externalFiltersFilePath);
        this.btnThisLogxFile.setSelection(true);
        this.radioGroupChanged();
    }

    private void radioGroupChanged() {
        boolean defaultSelectionHasBeenMade = this.btnThisLogxFile.getSelection();
        this.btnDeleteFilter.setEnabled(defaultSelectionHasBeenMade);
        this.btnClearForm.setEnabled(defaultSelectionHasBeenMade);
        if (defaultSelectionHasBeenMade) {
            this.btnSaveFilter.setToolTipText(SAVE_BTN_DEFAULT_TOOLTIP);
            this.lblRadioInstructions.setText(THIS_LOGX_INSTRUCTIONS);
        } else {
            this.btnSaveFilter.setToolTipText(SAVE_BTN_ALTERNATE_TOOLTIP);
            if (this.btnFiltersFile.getSelection()) {
                this.lblRadioInstructions.setText(EXTERNAL_FILE_INSTRUCTIONS);
            } else {
                this.lblRadioInstructions.setText(OTHER_LOGX_INSTRUCTIONS);
            }
        }
        this.lblRadioInstructions.pack();
        this.populateCboFilters();
    }

    private void populateCboFilters() {
        if (this.btnThisLogxFile.getSelection()) {
            List<String> logFilterNames = this.myEditor.getLogFilterNames();
            this.cboFilters.setEnabled(true);
            this.cboFilters.setItems(logFilterNames.toArray(new String[logFilterNames.size()]));
            this.cboFilters.add("", 0);
            if (this.myLogFilter != null && this.myLogFilter.getName() != null) {
                this.cboFilters.setText(this.myLogFilter.getName());
            } else {
                this.cboFilters.setText("");
            }
            this.btnSaveFilter.setEnabled(true);
        } else if (this.btnFiltersFile.getSelection()) {
            if (this.externalLogFilters == null && this.externalFiltersFilePath != null && !this.externalFiltersFilePath.isEmpty()) {
                try {
                    this.externalLogFilters = this.getLogFilters(this.externalFiltersFilePath);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.parentShell, (String)"Error Reading File", (String)("Error while trying to load filters from external file: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (this.externalLogFilters != null && !this.externalLogFilters.isEmpty()) {
                ArrayList<String> lfNames = new ArrayList<String>();
                for (String name : this.externalLogFilters.keySet()) {
                    lfNames.add(name);
                }
                Collections.sort(lfNames);
                this.cboFilters.setItems(lfNames.toArray(new String[lfNames.size()]));
                this.cboFilters.setText((String)lfNames.get(0));
                this.cboFilters.setEnabled(true);
                this.btnSaveFilter.setEnabled(true);
            } else {
                this.cboFilters.setText("");
                this.cboFilters.setEnabled(false);
                this.btnSaveFilter.setEnabled(false);
            }
        } else {
            boolean filtersAreAvailable;
            String filterSource = this.cboOtherLogxFiles.getText();
            List<String> logFilterNames = this.myEditor.getOtherOpenVLBEditor(filterSource).getLogFilterNames();
            this.cboFilters.setItems(logFilterNames.toArray(new String[logFilterNames.size()]));
            boolean bl = filtersAreAvailable = !logFilterNames.isEmpty();
            if (filtersAreAvailable) {
                this.cboFilters.setText(logFilterNames.get(0));
            } else {
                this.cboFilters.setText("");
            }
            this.cboFilters.setEnabled(filtersAreAvailable);
            this.btnSaveFilter.setEnabled(filtersAreAvailable);
        }
        this.cboFiltersSelectionChanged();
    }

    private void cboFiltersSelectionChanged() {
        String filterName = this.cboFilters.getText();
        this.clearFilterForm();
        if (!filterName.isEmpty()) {
            LogFilter logFilter = null;
            if (this.btnThisLogxFile.getSelection()) {
                logFilter = this.namedLogFilters.get(filterName);
            } else if (this.btnFiltersFile.getSelection()) {
                logFilter = this.externalLogFilters.get(filterName);
            } else {
                String filterSource = this.cboOtherLogxFiles.getText();
                logFilter = this.myEditor.getOtherOpenVLBEditor(filterSource).getLogFilter(filterName);
            }
            this.initFormFromLogFilterObj(logFilter);
        } else {
            this.cboAddLines.setText("0");
            this.addEmptyDialogRowToGUI();
        }
        this.addEmptyDialogRowToGUI();
        this.setFilterCriteriaEnabled(this.btnThisLogxFile.getSelection());
    }

    private void clearFilterForm() {
        for (FilterDialogRow row : this.myFilterDialogRows) {
            row.clear();
        }
        this.myFilterDialogRows.clear();
        this.addEmptyDialogRowToGUI();
        this.myFilterDialogRows.get(0).clear();
        this.myFilterDialogRows.clear();
        this.cboAddLines.setText("0");
    }

    public String getExternalFiltersFilePath() {
        return this.externalFiltersFilePath;
    }

    private Map<String, LogFilter> getLogFilters(String filePath) throws Exception {
        FileInputStream configInputStream = new FileInputStream(new File(filePath));
        ConfigParser cfgParser = new ConfigParser((InputStream)configInputStream, false);
        configInputStream.close();
        return cfgParser.getLogFilters();
    }

    private class MyExpansionListener
    implements Listener {
        private int rowNum;

        public MyExpansionListener(int rowNum) {
            this.rowNum = rowNum;
        }

        public void handleEvent(Event event) {
            if (this.rowNum == FilterDialog.this.myFilterDialogRows.size() - 1) {
                FilterDialog.this.addEmptyDialogRowToGUI();
            }
        }
    }
}

