/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FindDialog
extends Dialog {
    public static final String DIALOG_TITLE = "Find by keyword";
    public static final String FIND_NEXT_LABEL = "Find next...";
    public static final String FIND_ALL_LABEL = "Find All";
    public static final String CLOSE_ALIAS_LABEL = "Close";
    public static final String DIALOG_MESSAGE = "Enter a keyword and click 'Find next...'";
    public static final String TEXT_INPUT_LABEL = "Keyword: ";
    public static final int FIND_NEXT_BTN_ID = 1025;
    public static final int FIND_ALL_BTN_ID = 1026;
    private String findKeyword;
    private Text txtInput;
    private LogTableViewer myLogTableViewer;

    public FindDialog(Shell parentShell, String findKeyword, LogTableViewer logTableViewer) {
        super(parentShell);
        this.findKeyword = findKeyword == null ? "" : findKeyword;
        this.myLogTableViewer = logTableViewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 30;
        Label message = new Label(composite, 0);
        message.setLayoutData((Object)gridData);
        message.setText(DIALOG_MESSAGE);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 250;
        Label label = new Label(composite, 0);
        label.setText(TEXT_INPUT_LABEL);
        this.txtInput = new Text(composite, 2048);
        this.txtInput.setText(this.findKeyword);
        this.txtInput.setLayoutData((Object)gridData);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, FIND_NEXT_LABEL, true);
        this.createButton(parent, 1026, FIND_ALL_LABEL, false);
        this.createButton(parent, 12, CLOSE_ALIAS_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 1) {
            super.cancelPressed();
        } else if (buttonType == 12) {
            super.cancelPressed();
        } else {
            this.findKeyword = this.txtInput.getText();
            if (this.findKeyword != null && this.findKeyword.length() > 0) {
                this.myLogTableViewer.setFindKeyword(this.findKeyword);
                if (buttonType == 1025) {
                    this.myLogTableViewer.findNext();
                } else if (buttonType == 1026) {
                    this.myLogTableViewer.findAll();
                }
            }
        }
    }

    public String getFindKeyword() {
        return this.findKeyword;
    }
}

