/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HighlightDialog
extends Dialog {
    public static final String DIALOG_TITLE = "Highlight a keyword";
    public static final String HIGHLIGHT_LABEL = "Highlight";
    public static final String CLEAR_LABEL = "Unhighlight";
    public static final String CLOSE_ALIAS_LABEL = "Close";
    public static final String DIALOG_MESSAGE = "Enter a keyword and click 'Highlight'";
    public static final String TEXT_INPUT_LABEL = "Highlight keyword: ";
    public static final int HIGHLIGHT_BTN_ID = 1025;
    public static final int CLEAR_BTN_ID = 1026;
    private String highlightKeyword;
    private Text txtInput;
    private LogTableViewer myLogTableViewer;

    public HighlightDialog(Shell parentShell, String highlightKeyword, LogTableViewer logTableViewer) {
        super(parentShell);
        this.highlightKeyword = highlightKeyword == null ? "" : highlightKeyword;
        this.myLogTableViewer = logTableViewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 30;
        Label message = new Label(composite, 0);
        message.setLayoutData((Object)gridData);
        message.setText(DIALOG_MESSAGE);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 250;
        Label label = new Label(composite, 0);
        label.setText(TEXT_INPUT_LABEL);
        this.txtInput = new Text(composite, 2048);
        this.txtInput.setText(this.highlightKeyword);
        this.txtInput.setLayoutData((Object)gridData);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, HIGHLIGHT_LABEL, true);
        this.createButton(parent, 1026, CLEAR_LABEL, false);
        this.createButton(parent, 12, CLOSE_ALIAS_LABEL, false);
    }

    protected void buttonPressed(int buttonType) {
        if (buttonType == 12) {
            super.cancelPressed();
        } else if (buttonType == 1025 || buttonType == 1026) {
            this.highlightKeyword = this.txtInput.getText();
            this.myLogTableViewer.setTxtHighlightStr(this.highlightKeyword);
            if (buttonType == 1025) {
                this.myLogTableViewer.setBtnHighlightStr(CLEAR_LABEL);
                this.myLogTableViewer.highlight(this.highlightKeyword);
            } else if (buttonType == 1026) {
                this.myLogTableViewer.setBtnHighlightStr(HIGHLIGHT_LABEL);
                this.myLogTableViewer.highlight("");
            }
        }
    }

    public String getHighlightKeyword() {
        return this.highlightKeyword;
    }
}

