/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs;

import com.vmware.vide.utils.resource.ResourceUtils;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.export.EnumLogExport;
import com.vmware.vide.vlogbrowser.core.export.ILogEntryAccessor;
import com.vmware.vide.vlogbrowser.core.export.ILogExport;
import com.vmware.vide.vlogbrowser.core.export.LogExportException;
import com.vmware.vide.vlogbrowser.core.export.LogExportFactory;
import com.vmware.vide.vlogbrowser.core.export.LogItemAdaptor;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import com.vmware.vide.vlogbrowser.core.script.api.LogBrowserScriptRecorderManager;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogExportDialog
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(LogExportDialog.class);
    private static boolean includeExtraLinesInExport = false;
    private LogBrowserEditor logBrowserEditor;
    private Button btnExportFilteredEvents;
    private Button btnExportAllEvents;
    private Button btnExportExtraLines;
    private Text textFileLocation;
    private Combo comboFormat;
    private Button btnBrowse;
    private Button btnExport;

    public LogExportDialog(Shell parentShell, LogBrowserEditor logBrowserEditor) {
        super(parentShell);
        this.logBrowserEditor = logBrowserEditor;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Group grpContentOptions = new Group(container, 0);
        GridData gridData = new GridData(4, 128, true, false, 1, 1);
        grpContentOptions.setLayoutData((Object)gridData);
        grpContentOptions.setText("Options");
        grpContentOptions.setLayout((Layout)new FillLayout(256));
        this.btnExportFilteredEvents = new Button((Composite)grpContentOptions, 16);
        this.btnExportFilteredEvents.setText("Filtered events");
        this.btnExportFilteredEvents.setSelection(true);
        this.btnExportAllEvents = new Button((Composite)grpContentOptions, 16);
        this.btnExportAllEvents.setText("All events");
        this.btnExportExtraLines = new Button((Composite)grpContentOptions, 32);
        this.btnExportExtraLines.setText("Include Extra Lines");
        this.btnExportExtraLines.setSelection(includeExtraLinesInExport);
        this.btnExportExtraLines.setToolTipText("For log entries that span multiple lines, only the first line is included by default.  If this is selected, the additional lines are also included in the export.");
        Group grpFile = new Group(container, 0);
        grpFile.setLayout((Layout)new GridLayout(4, false));
        gridData = new GridData(4, 128, true, false, 1, 1);
        grpFile.setLayoutData((Object)gridData);
        grpFile.setText("File");
        Label lblFormat = new Label((Composite)grpFile, 0);
        lblFormat.setText("Format:");
        this.comboFormat = new Combo((Composite)grpFile, 0);
        gridData = new GridData(16384, 128, false, false, 1, 1);
        gridData.widthHint = 125;
        this.comboFormat.setLayoutData((Object)gridData);
        EnumLogExport[] enumLogExportArray = EnumLogExport.values();
        int n = enumLogExportArray.length;
        int n2 = 0;
        while (n2 < n) {
            EnumLogExport type = enumLogExportArray[n2];
            this.comboFormat.add(type.getDescription());
            this.comboFormat.setData(type.getDescription(), (Object)type);
            ++n2;
        }
        this.comboFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!LogExportDialog.this.comboFormat.getText().isEmpty()) {
                    LogExportDialog.this.btnBrowse.setEnabled(true);
                    LogExportDialog.this.textFileLocation.setEnabled(true);
                }
            }
        });
        new Label((Composite)grpFile, 0);
        Label lblFileLocation = new Label((Composite)grpFile, 0);
        gridData = new GridData(16384, 128, true, false, 1, 1);
        lblFileLocation.setLayoutData((Object)gridData);
        lblFileLocation.setText("Location:");
        this.textFileLocation = new Text((Composite)grpFile, 2048);
        gridData = new GridData(16384, 128, true, false, 1, 1);
        gridData.widthHint = 190;
        this.textFileLocation.setLayoutData((Object)gridData);
        this.textFileLocation.setEnabled(false);
        this.textFileLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LogExportDialog.this.btnExport.setEnabled(!LogExportDialog.this.textFileLocation.getText().isEmpty());
            }
        });
        this.btnBrowse = new Button((Composite)grpFile, 0);
        this.btnBrowse.setText("Browse...");
        this.btnBrowse.setEnabled(false);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(LogExportDialog.this.logBrowserEditor.getSite().getShell(), 8192);
                fileDialog.setText("Select a file to export current log");
                EnumLogExport formatType = (EnumLogExport)LogExportDialog.this.comboFormat.getData(LogExportDialog.this.comboFormat.getText());
                fileDialog.setFileName(String.valueOf(LogExportDialog.this.getLogFileName()) + "." + formatType.getOption());
                fileDialog.setFilterExtensions(new String[]{formatType.getExtension()});
                ILogBrowserManager lbManager = LogBrowserPlugin.getDefault().getLogBrowserManager();
                String recentDir = lbManager.getRecentHostDir("localhost");
                if (recentDir != null && !recentDir.isEmpty()) {
                    fileDialog.setFilterPath(recentDir);
                } else {
                    URI workspaceUri = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    String workspacePathString = new File(workspaceUri).getAbsolutePath();
                    fileDialog.setFilterPath(workspacePathString);
                }
                String selected = this.open(fileDialog);
                if (selected != null) {
                    LogExportDialog.this.textFileLocation.setText(selected);
                    try {
                        File parentFile = new File(selected).getParentFile();
                        if (parentFile != null && parentFile.exists()) {
                            lbManager.setRecentHostDir("localhost", parentFile.getAbsolutePath());
                        }
                    }
                    catch (Exception e2) {
                        logger.error("Error trying to persist directory setting", (Throwable)e2);
                    }
                }
            }

            private String open(FileDialog fileDialog) {
                String fileName = null;
                boolean done = false;
                while (!done) {
                    fileName = fileDialog.open();
                    if (fileName == null) {
                        done = true;
                        continue;
                    }
                    File file = new File(fileName);
                    if (file.exists()) {
                        MessageBox mb = new MessageBox(fileDialog.getParent(), 200);
                        mb.setMessage(String.valueOf(fileName) + " already exists. Do you want to replace it?");
                        done = mb.open() == 64;
                        continue;
                    }
                    done = true;
                }
                return fileName;
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnExport = this.createButton(parent, 0, "Export", true);
        this.btnExport.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Export log file");
    }

    protected Point getInitialSize() {
        return new Point(450, 240);
    }

    protected boolean isResizable() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.export();
        }
        super.buttonPressed(buttonId);
    }

    private void export() {
        boolean exportExtraLines;
        String filePath = this.textFileLocation.getText();
        boolean isFiltered = this.btnExportFilteredEvents.getSelection();
        includeExtraLinesInExport = exportExtraLines = this.btnExportExtraLines.getSelection();
        EnumLogExport formatType = (EnumLogExport)this.comboFormat.getData(this.comboFormat.getText());
        LogTableViewer viewer = this.logBrowserEditor.getLogTableViewer();
        if (viewer == null) {
            String errorMessage = "Unable to export log file: " + this.getLogFileName();
            logger.error(errorMessage);
            MessageDialog.openError((Shell)this.logBrowserEditor.getSite().getShell(), (String)"Error", (String)errorMessage);
        } else {
            LogFormat logFormat = viewer.getLogFormat();
            Object logItems = null;
            logItems = isFiltered ? viewer.getFilterList() : viewer.getFilterList().getUnfiltered();
            ILogExport exportService = LogExportFactory.getInstance().createService(formatType);
            try {
                ILogBrowserScriptRecorder recorder = LogBrowserScriptRecorderManager.getInstance().getRecorder();
                recorder.export(viewer.getProjectName(), viewer.getResourceName(), formatType.getOption(), filePath, isFiltered);
                this.runService(exportService, (List<LogItem>)logItems, logFormat, filePath, exportExtraLines);
            }
            catch (LogExportException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            ResourceUtils.refreshFileParent((String)filePath, null);
        }
    }

    private void runService(final ILogExport exportService, final List<LogItem> logItems, final LogFormat logFormat, final String filePath, final boolean emitExtraLines) throws LogExportException {
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(filePath);
                    BufferedOutputStream bufferedStream = new BufferedOutputStream(fileOutputStream);
                    PrintStream outputStream = new PrintStream(bufferedStream);
                    exportService.start((OutputStream)outputStream, monitor, emitExtraLines);
                    LogItemAdaptor logAccessor = new LogItemAdaptor(logItems, logFormat);
                    exportService.export((ILogEntryAccessor)logAccessor);
                    exportService.end();
                    outputStream.close();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)LogExportDialog.this.logBrowserEditor.getSite().getShell(), (String)"Success", (String)("Log file " + LogExportDialog.this.getLogFileName() + " was successfully exported to " + filePath));
                        }
                    });
                }
                catch (Exception e) {
                    final String errorMessage = e.getMessage();
                    logger.error(errorMessage, (Throwable)e);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)LogExportDialog.this.logBrowserEditor.getSite().getShell(), (String)"Error", (String)errorMessage);
                        }
                    });
                }
            }
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, runnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw new LogExportException("Error in the progress bar dialog", (Throwable)e);
        }
    }

    private String getLogFileName() {
        String name = this.logBrowserEditor.getTitle();
        name = name.substring(0, name.lastIndexOf(46));
        return name;
    }
}

