/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.dialogs.highlight;

import com.vmware.vide.vlogbrowser.core.parser.XmlDocUtils;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElement;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightElementList;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.HighlightUtil;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HighlightElementsPersistence {
    private Document document;
    private LogBrowserEditor myLogBrowserEditor;

    public HighlightElementsPersistence(LogTableViewer logTableViewer) {
        this.document = logTableViewer.getConfigParser().getConfigDoc();
        this.myLogBrowserEditor = logTableViewer.getMyLogBrowserEditor();
    }

    public HighlightElementList loadKeywordsFromLogXFile() {
        HighlightElementList resultList = new HighlightElementList();
        NodeList keywordNodeList = this.getKeywordNodeList();
        int i = 0;
        while (i < keywordNodeList.getLength()) {
            Node node = keywordNodeList.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String keywordText = element.getAttribute("text");
                boolean enable = Boolean.parseBoolean(element.getAttribute("enable"));
                String strColor = element.getAttribute("color");
                RGB color = HighlightUtil.stringToColor(strColor);
                resultList.createElement(enable, keywordText, color);
            }
            ++i;
        }
        return resultList;
    }

    public void saveKeywordsToLogXFile(List<HighlightElement> listHighlightElements) {
        Element tagHighlightKeywords = null;
        Element root = this.document.getDocumentElement();
        NodeList nodeList = this.document.getElementsByTagName("HighlightKeywords");
        if (nodeList.getLength() == 1) {
            tagHighlightKeywords = (Element)nodeList.item(0);
            root.removeChild(tagHighlightKeywords);
        }
        if (listHighlightElements != null && !listHighlightElements.isEmpty()) {
            tagHighlightKeywords = this.document.createElement("HighlightKeywords");
            root.appendChild(tagHighlightKeywords);
            for (HighlightElement highlightElement : listHighlightElements) {
                Element domElement = this.document.createElement("Keyword");
                domElement.setAttribute("enable", new Boolean(highlightElement.isEnable()).toString());
                domElement.setAttribute("text", highlightElement.getKeyword().toString());
                domElement.setAttribute("color", HighlightUtil.colorToString(highlightElement.getColor()));
                tagHighlightKeywords.appendChild(domElement);
            }
        }
        this.myLogBrowserEditor.overwriteTextInEditor(XmlDocUtils.getXmlStringFromDocument((Document)this.document));
    }

    private NodeList getKeywordNodeList() {
        NodeList keywordNodeList = null;
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/root/HighlightKeywords[1]/Keyword");
            keywordNodeList = (NodeList)expr.evaluate(this.document, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return keywordNodeList;
    }
}

