/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.runners;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetManagerInitListener;
import com.vmware.vide.target.api.TargetManagerPlugin;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import com.vmware.vide.vlogbrowser.core.script.api.LogBrowserScriptRecorderManager;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogTableViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogLoadRunner
extends Job
implements ITargetManagerInitListener {
    private static final Logger logger = LoggerFactory.getLogger(LogLoadRunner.class);
    private LogTableViewer viewer;
    private boolean forceReload;
    private static final ILogBrowserScriptRecorder recorder = LogBrowserScriptRecorderManager.getInstance().getRecorder();

    public LogLoadRunner(LogTableViewer viewer, boolean forceReload, String message) {
        super(message);
        this.viewer = viewer;
        this.forceReload = forceReload;
        viewer.getLogWorker().prepareToRun(this);
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Initializing", 20);
        this.viewer.loadAllLogFilesInTable(this.forceReload, (IProgressMonitor)new SubProgressMonitor(monitor, 19));
        this.recordingHook();
        monitor.worked(1);
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean shouldSchedule() {
        if (!TargetManagerPlugin.getTheTargetManager().isInitialized()) {
            TargetManagerPlugin.getTheTargetManager().addInitListener((ITargetManagerInitListener)this);
            return false;
        }
        return true;
    }

    public void phaseComplete(int phase) {
        if (phase == 0) {
            TargetManagerPlugin.getTheTargetManager().removeInitListener((ITargetManagerInitListener)this);
            this.schedule();
        }
    }

    private void recordingHook() {
        try {
            ITarget target;
            String logxType = this.viewer.getLogFormat().getName();
            String userName = null;
            String password = null;
            String hostType = null;
            String hostName = null;
            String prjName = this.viewer.getProjectName();
            String path = null;
            ConfigParser.SourceInfo[] infos = this.viewer.getConfigParser().getSourceInfos();
            if (infos != null && infos.length != 0) {
                hostName = infos[0].getHost();
                path = infos[0].getArchiveFilepath();
            }
            if (hostName != null && (target = TargetManagerPlugin.getTheTargetManager().findTarget(hostName)) != null) {
                userName = target.getUserId();
                password = target.getPassword(false);
                hostType = target.getTargetType();
            }
            recorder.downloadAndStageLogFiles(prjName, new String[]{logxType}, hostName, hostType, userName, password, path);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

