/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.tableviewer;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class LogItemLabelProvider
extends StyledCellLabelProvider {
    private String searchKey;
    private Color highlightColor;
    private static Color oddBackground;
    private static Color evenBackground;
    protected LogFormat logFormat;
    private Map<String, RGB> mapHighlightKeywords = null;
    private static Display DISPLAY;
    private static final Image INFO_IMAGE;
    private static final Image WARN_IMAGE;

    static {
        DISPLAY = Display.getDefault();
        INFO_IMAGE = new Image((Device)DISPLAY, DISPLAY.getSystemImage(2).getImageData().scaledTo(16, 16));
        WARN_IMAGE = new Image((Device)DISPLAY, DISPLAY.getSystemImage(8).getImageData().scaledTo(16, 16));
    }

    public LogItemLabelProvider(LogFormat logFormat) {
        this.logFormat = logFormat;
        this.highlightColor = Display.getCurrent().getSystemColor(7);
        oddBackground = new Color((Device)Display.getCurrent(), 197, 255, 196);
        evenBackground = Display.getCurrent().getSystemColor(1);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            try {
                if (((LogItem)element).getLogExtra(this.logFormat).length() > 0) {
                    return WARN_IMAGE;
                }
                return INFO_IMAGE;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        try {
            String text = ((LogItem)element).getLogField(columnIndex, this.logFormat).toString();
            return text.trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Color getBackground(LogItem item) {
        return (item.getGroupId() & 1) != 0 ? oddBackground : evenBackground;
    }

    public void update(ViewerCell cell) {
        ArrayList<StyleRange> cellStyleRanges;
        LogItem item = (LogItem)cell.getElement();
        int columnIndex = cell.getColumnIndex();
        String columnText = this.getColumnText(item, columnIndex);
        cell.setFont(Display.getCurrent().getSystemFont());
        cell.setText(columnText);
        cell.setImage(this.getColumnImage(item, columnIndex));
        cell.setBackground(LogItemLabelProvider.getBackground(item));
        cell.setForeground(this.getForeground(item, columnIndex));
        if (!(this.searchKey != null && this.searchKey.length() != 0 || this.mapHighlightKeywords != null && this.mapHighlightKeywords.size() != 0)) {
            cell.setStyleRanges(new ArrayList().toArray(new StyleRange[0]));
        }
        if (this.searchKey != null && this.searchKey.length() > 0) {
            cellStyleRanges = new ArrayList<StyleRange>();
            this.addColorIntoCell(cellStyleRanges, columnText, this.searchKey, this.highlightColor);
            cell.setStyleRanges(cellStyleRanges.toArray(new StyleRange[cellStyleRanges.size()]));
        }
        if (this.mapHighlightKeywords != null && this.mapHighlightKeywords.size() > 0) {
            cellStyleRanges = new ArrayList();
            for (Map.Entry<String, RGB> entry : this.mapHighlightKeywords.entrySet()) {
                String keyword = entry.getKey();
                RGB rgb = entry.getValue();
                Color color = new Color((Device)Display.getCurrent(), rgb);
                this.addColorIntoCell(cellStyleRanges, columnText, keyword, color);
            }
            cell.setStyleRanges(cellStyleRanges.toArray(new StyleRange[cellStyleRanges.size()]));
        }
        super.update(cell);
    }

    private void addColorIntoCell(ArrayList<StyleRange> cellStyleRanges, String columnText, String keyword, Color color) {
        int[] searchKeyFoundAt = LogItemLabelProvider.searchHitsToArray(columnText, keyword);
        int i = 0;
        while (i < searchKeyFoundAt.length - 1) {
            int start = searchKeyFoundAt[i];
            int length = searchKeyFoundAt[i + 1];
            cellStyleRanges.add(new StyleRange(start, length, null, color));
            i += 2;
        }
    }

    public void setSearchKey(String searchKey) {
        this.searchKey = searchKey;
    }

    public void setMapHighlightKeywords(Map<String, RGB> mapHighlightKeywords) {
        this.mapHighlightKeywords = mapHighlightKeywords;
    }

    public Map<String, RGB> getMapHighlightKeywords() {
        return this.mapHighlightKeywords;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (columnIndex == this.logFormat.getDateColumnIndex() && this.logFormat.getDateDelta() != 0L) {
            return Display.getCurrent().getSystemColor(4);
        }
        return Display.getCurrent().getSystemColor(2);
    }

    public static int[] searchHitsToArray(String textStr, String keyword) {
        ArrayList<Integer> searchHits = new ArrayList<Integer>();
        if (keyword == null || keyword.length() == 0 || textStr == null || textStr.length() == 0) {
            return new int[0];
        }
        int textStrIndex = 0;
        while (textStrIndex < textStr.length()) {
            int keyStart = textStr.indexOf(keyword, textStrIndex);
            if (keyStart < 0) break;
            searchHits.add(keyStart);
            searchHits.add(keyword.length());
            textStrIndex = keyStart + keyword.length();
        }
        int[] returnIntArr = new int[searchHits.size()];
        int i = 0;
        while (i < searchHits.size()) {
            returnIntArr[i] = (Integer)searchHits.get(i);
            ++i;
        }
        return returnIntArr;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }
}

