/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.tableviewer;

import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vide.utils.timer.TimerUtils;
import com.vmware.vide.utils.xml.XMLParser;
import com.vmware.vide.utils.xml.XMLUtil;
import com.vmware.vide.vlogbrowser.core.chart.IFilterListener;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.model.GroupMatcherFilter;
import com.vmware.vide.vlogbrowser.core.model.ISingleMatcher;
import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.LogItemFilteredList;
import com.vmware.vide.vlogbrowser.core.model.LogItemSerializator;
import com.vmware.vide.vlogbrowser.core.model.MatcherFilter;
import com.vmware.vide.vlogbrowser.core.model.util.IFilter;
import com.vmware.vide.vlogbrowser.core.model.util.IFilteredList;
import com.vmware.vide.vlogbrowser.core.model.util.ISerializator;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.core.parser.DateMatcher;
import com.vmware.vide.vlogbrowser.core.parser.IParserFileListener;
import com.vmware.vide.vlogbrowser.core.parser.IndexMatcher;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogItemMatcher;
import com.vmware.vide.vlogbrowser.core.parser.LogParser;
import com.vmware.vide.vlogbrowser.core.parser.MultiMatcher;
import com.vmware.vide.vlogbrowser.core.parser.MultiMatcherFactory;
import com.vmware.vide.vlogbrowser.core.parser.ParserEvent;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import com.vmware.vide.vlogbrowser.core.script.api.LogBrowserScriptRecorderManager;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.dialogs.LogDialog;
import com.vmware.vide.vlogbrowser.ui.dialogs.highlight.AdvancedHighlightDialog;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import com.vmware.vide.vlogbrowser.ui.fileops.UiLogFileManager;
import com.vmware.vide.vlogbrowser.ui.runners.LogFilterJob;
import com.vmware.vide.vlogbrowser.ui.runners.LogFilterRunner;
import com.vmware.vide.vlogbrowser.ui.runners.LogLoadRunner;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LILabelProviderLinux;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogContentProvider;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogItemLabelProvider;
import com.vmware.vide.vlogbrowser.ui.tableviewer.LogWorker;
import com.vmware.vide.vlogbrowser.ui.tableviewer.ParserJobListener;
import com.vmware.vide.vlogbrowser.ui.views.LogEntryDetailView;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogTableViewer {
    private static final Logger logger = LoggerFactory.getLogger(LogTableViewer.class);
    private LogFormat logFormat;
    private TableViewer viewer;
    private Table table;
    private Action cellDoubleclicked;
    private TableColumn[] columns;
    private IFilteredList<LogItem> filterList;
    private IFilter<LogItem> matcherFilter;
    public transient List<IFilterListener<LogItem>> filterListListener;
    private LogItemLabelProvider fLabelProvider;
    private UiLogFileManager logFileMgr;
    public static final int SELECT_ALL_LIMIT = 3000;
    private IWorkbenchPartSite mySite;
    private String findKeyword;
    private Composite topLeftComposite;
    private Composite topRightComposite;
    private Composite pageComposite;
    private Composite topCenterComposite;
    private Text txtFilter;
    private Button btnFilter;
    private Combo cboFilterAddLines;
    private Button btnFilterCaseSensitive;
    public static final String[] ADD_LINES_VALUES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private Button btnKeepSynched;
    private Text txtHighlight;
    private Button btnHighlight;
    private Link advancedUnhighlightLink;
    private Label lblLogFilesLoaded;
    private Text txtLogFilesLoaded;
    private Date btnFilterTimeStamp;
    private Date btnHighlightTimeStamp;
    public static final String TOOLTIP_PREAMBLE = "Additional text associated with log entry:\n";
    public static final String TOOLTIP_EXTRA = "\nContinued... Double-click to see more";
    public static final int TOOLTIP_LIMIT = 300;
    public static final int WARN_THRESHOLD = 50000;
    public static final String SORT_WARN_MSG = " may take awhile, since there are more than 50000 log entries in the table.\n";
    public static final String SORT_ALTERNATIVE = "Sorting by the \"Date\" column is faster, and sorting by the \"#\" column is fastest.\nAs an alternative to sorting, you can also use the Highlight, Find, or Filter operations.";
    public static final String FILTER_BTN_LABEL = "Filter";
    public static final String UNFILTER_BTN_LABEL = "Unfilter";
    private static final int MIN_COL_WIDTH = 10;
    private String logFilesInfoStr;
    private boolean ignoreLongOpWarning;
    private LogBrowserEditor myLogBrowserEditor;
    private LogFilter fLogFilter;
    private Map<String, LogFilter> namedLogFilters;
    private String externalFiltersFilePath;
    private LogParser parser;
    private LogWorker logWorker;
    private LogContentProvider fContentProvider;
    private String prjName;
    private String resName;
    private ILogBrowserScriptRecorder recorder;

    public LogTableViewer(LogBrowserEditor editor, Composite fullPageComposite, LogFormat lgfmt, UiLogFileManager logFileMgr, final IWorkbenchPartSite mySite, Map<String, LogFilter> namedLogFilters) {
        this.myLogBrowserEditor = editor;
        this.pageComposite = fullPageComposite;
        this.logFormat = lgfmt;
        this.logFileMgr = logFileMgr;
        this.mySite = mySite;
        this.btnFilterTimeStamp = new Date(System.currentTimeMillis());
        this.btnHighlightTimeStamp = new Date(System.currentTimeMillis());
        this.logFilesInfoStr = "";
        this.ignoreLongOpWarning = false;
        this.namedLogFilters = namedLogFilters;
        this.fLogFilter = new LogFilter("", 0, 2);
        this.externalFiltersFilePath = "";
        this.filterListListener = new LinkedList<IFilterListener<LogItem>>();
        this.resName = editor.getConfigFileName();
        this.prjName = editor.getProjectName();
        this.recorder = LogBrowserScriptRecorderManager.getInstance().getRecorder();
        this.parser = new LogParser();
        this.logWorker = new LogWorker(this.parser);
        try {
            fullPageComposite.setLayout((Layout)new FillLayout());
            ViewForm fullPageViewForm = new ViewForm(fullPageComposite, 0);
            this.topLeftComposite = new Composite((Composite)fullPageViewForm, 0);
            this.topLeftComposite.setLayout((Layout)new GridLayout(5, false));
            this.txtFilter = new Text(this.topLeftComposite, 2048);
            GridData gridData = new GridData();
            gridData.widthHint = 150;
            this.txtFilter.setLayoutData((Object)gridData);
            this.txtFilter.setData("name", (Object)"txtFilter");
            this.txtFilter.setToolTipText("Enter a filter keyword here");
            this.txtFilter.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (!LogTableViewer.this.fLogFilter.isJustAKeyword()) {
                        IHandlerService handlerSvc = (IHandlerService)mySite.getService(IHandlerService.class);
                        try {
                            handlerSvc.executeCommand("com.vmware.vide.vlogbrowser.commands.filter", null);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            this.btnFilter = new Button(this.topLeftComposite, 8);
            this.btnFilter.setData("name", (Object)"btnFilter");
            this.btnFilter.setText(FILTER_BTN_LABEL);
            this.btnFilter.setToolTipText("Enter a keyword and click 'Filter' to see only log entries that contain that keyword");
            this.cboFilterAddLines = new Combo(this.topLeftComposite, 12);
            this.cboFilterAddLines.setData("name", (Object)"cboFilterAddLines");
            this.cboFilterAddLines.setItems(ADD_LINES_VALUES);
            this.cboFilterAddLines.setText("0");
            this.cboFilterAddLines.setToolTipText("Number of immediately surrounding log entries displayed before and after log entries that match the filter");
            this.cboFilterAddLines.pack();
            this.btnFilterCaseSensitive = new Button(this.topLeftComposite, 32);
            this.btnFilterCaseSensitive.setData("name", (Object)"btnFilterCaseSensitive");
            this.btnFilterCaseSensitive.setText("Case sensitive");
            this.btnFilterCaseSensitive.setSelection(false);
            this.btnFilterCaseSensitive.pack();
            this.btnFilter.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (System.currentTimeMillis() - LogTableViewer.this.btnFilterTimeStamp.getTime() > 500L) {
                        try {
                            LogTableViewer.this.btnFilterTimeStamp = new Date();
                            if (LogTableViewer.this.getBtnFilterStr().equals(LogTableViewer.FILTER_BTN_LABEL)) {
                                if (LogTableViewer.this.txtFilter.getEditable() && LogTableViewer.this.txtFilter.getText().trim().isEmpty()) {
                                    return;
                                }
                                if (LogTableViewer.this.fLogFilter.isJustAKeyword()) {
                                    LogTableViewer.this.fLogFilter.setFirstKeyword(LogTableViewer.this.txtFilter.getText());
                                }
                                LogTableViewer.this.fLogFilter.setCaseSensitive(LogTableViewer.this.btnFilterCaseSensitive.getSelection());
                                LogTableViewer.this.fLogFilter.setFilterEnabled(true);
                                LogTableViewer.this.setBtnFilterStr(LogTableViewer.UNFILTER_BTN_LABEL);
                            } else {
                                LogTableViewer.this.fLogFilter.setFilterEnabled(false);
                                LogTableViewer.this.setBtnFilterStr(LogTableViewer.FILTER_BTN_LABEL);
                            }
                            LogFilterJob filterJob = new LogFilterJob(LogTableViewer.this, LogTableViewer.this.fLogFilter, LogTableViewer.FILTER_BTN_LABEL);
                            filterJob.setUser(true);
                            filterJob.schedule();
                            HttpLogger.logActivity((String)"vlogbrowser", (String)"UseFilter");
                        }
                        catch (Exception e1) {
                            MessageDialog.openError((Shell)LogTableViewer.this.viewer.getControl().getShell(), (String)"Error", (String)("While trying to set the filter keyword, en error occurred: " + e1.getMessage()));
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.txtFilter.addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode == 13 || e.keyCode == 10) {
                        try {
                            if (LogTableViewer.this.fLogFilter.isJustAKeyword()) {
                                LogTableViewer.this.fLogFilter.setFirstKeyword(LogTableViewer.this.txtFilter.getText());
                            }
                            LogTableViewer.this.fLogFilter.setFilterEnabled(true);
                            LogFilterRunner lfRunner = new LogFilterRunner(LogTableViewer.this, LogTableViewer.this.fLogFilter);
                            LogTableViewer.this.setBtnFilterStr(LogTableViewer.UNFILTER_BTN_LABEL);
                            new ProgressMonitorDialog(mySite.getShell()).run(false, false, (IRunnableWithProgress)lfRunner);
                        }
                        catch (Exception e1) {
                            MessageDialog.openError((Shell)LogTableViewer.this.viewer.getControl().getShell(), (String)"Error", (String)("While trying to set the filter keyword, en error occurred: " + e1.getMessage()));
                            e1.printStackTrace();
                        }
                    }
                }
            });
            this.cboFilterAddLines.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LogTableViewer.this.fLogFilter.setNumSurroundingLines(Integer.parseInt(LogTableViewer.this.cboFilterAddLines.getText()));
                    if (LogTableViewer.this.getBtnFilterStr().equals(LogTableViewer.UNFILTER_BTN_LABEL)) {
                        LogFilterRunner lfRunner = new LogFilterRunner(LogTableViewer.this, LogTableViewer.this.fLogFilter);
                        try {
                            new ProgressMonitorDialog(mySite.getShell()).run(false, false, (IRunnableWithProgress)lfRunner);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
            fullPageViewForm.setTopLeft((Control)this.topLeftComposite);
            this.topRightComposite = new Composite((Composite)fullPageViewForm, 0);
            this.topRightComposite.setLayout((Layout)new GridLayout(2, false));
            this.txtHighlight = new Text(this.topRightComposite, 2176);
            this.txtHighlight.setData("name", (Object)"txtHighlight");
            gridData = new GridData();
            gridData.widthHint = 150;
            this.txtHighlight.setLayoutData((Object)gridData);
            this.txtHighlight.setToolTipText("Enter a keyword to highlight here");
            gridData = new GridData();
            gridData.widthHint = 85;
            this.btnHighlight = new Button(this.topRightComposite, 8);
            this.btnHighlight.setLayoutData((Object)gridData);
            this.btnHighlight.setData("name", (Object)"btnHighlight");
            this.btnHighlight.setText("Highlight");
            this.btnHighlight.setToolTipText("Enter a keyword and click 'Highlight' to highlight any occurrences of that keyword in any log entry");
            this.btnHighlight.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    if (System.currentTimeMillis() - LogTableViewer.this.btnHighlightTimeStamp.getTime() > 500L) {
                        LogTableViewer.this.btnHighlightTimeStamp = new Date();
                        if (LogTableViewer.this.getBtnHighlightStr().equals("Highlight")) {
                            LogTableViewer.this.setBtnHighlightStr("Unhighlight");
                            LogTableViewer.this.fLabelProvider.setSearchKey(LogTableViewer.this.txtHighlight.getText());
                        } else {
                            LogTableViewer.this.setBtnHighlightStr("Highlight");
                            LogTableViewer.this.fLabelProvider.setSearchKey("");
                        }
                        LogTableViewer.this.viewer.refresh();
                        HttpLogger.logActivity((String)"vlogbrowser", (String)"UseHighlight");
                    }
                }
            });
            this.txtHighlight.addListener(1, new Listener(){

                public void handleEvent(Event e) {
                    if (e.keyCode == 13 || e.keyCode == 10) {
                        LogTableViewer.this.setBtnHighlightStr("Unhighlight");
                        LogTableViewer.this.fLabelProvider.setSearchKey(LogTableViewer.this.txtHighlight.getText());
                        LogTableViewer.this.viewer.refresh();
                    }
                }
            });
            Link advancedLink = new Link(this.topRightComposite, 0);
            advancedLink.setText("<a>Advanced highlight</a>");
            advancedLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AdvancedHighlightDialog advancedHighlightDialog = new AdvancedHighlightDialog(Display.getDefault().getActiveShell(), LogTableViewer.this);
                    advancedHighlightDialog.open();
                }
            });
            this.advancedUnhighlightLink = new Link(this.topRightComposite, 0);
            this.advancedUnhighlightLink.setText("<a>Unhighlight all</a>");
            this.advancedUnhighlightLink.setVisible(false);
            this.advancedUnhighlightLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    LogTableViewer.this.fLabelProvider.setSearchKey("");
                    LogTableViewer.this.fLabelProvider.setMapHighlightKeywords(new HashMap<String, RGB>());
                    LogTableViewer.this.viewer.refresh();
                    LogTableViewer.this.advancedUnhighlightLink.setVisible(false);
                }
            });
            fullPageViewForm.setTopRight((Control)this.topRightComposite);
            this.topCenterComposite = new Composite((Composite)fullPageViewForm, 0);
            GridLayout gridLO = new GridLayout(3, false);
            gridLO.marginRight = 100;
            this.topCenterComposite.setLayout((Layout)gridLO);
            this.lblLogFilesLoaded = new Label(this.topCenterComposite, 131072);
            gridData = new GridData();
            gridData.widthHint = 100;
            this.lblLogFilesLoaded.setLayoutData((Object)gridData);
            this.lblLogFilesLoaded.setData("name", (Object)"lblLogFilesLoaded");
            this.lblLogFilesLoaded.setText("Log files loaded: ");
            this.txtLogFilesLoaded = new Text(this.topCenterComposite, 2052);
            gridData = new GridData();
            gridData.widthHint = 500;
            gridData.grabExcessHorizontalSpace = true;
            this.txtLogFilesLoaded.setLayoutData((Object)gridData);
            this.txtLogFilesLoaded.setText("");
            this.txtLogFilesLoaded.setEditable(false);
            this.txtLogFilesLoaded.setBackground(Display.getCurrent().getSystemColor(15));
            this.topCenterComposite.setToolTipText("Click the \"View Log Info\" menu button for a complete list of loaded log files.");
            this.btnKeepSynched = new Button(this.topCenterComposite, 32);
            this.btnKeepSynched.setData("name", (Object)"btnKeepSynched");
            this.btnKeepSynched.setText("Sync");
            this.btnKeepSynched.setToolTipText("When a log entry in a different vLogBrowser window is selected, keep this window synchronized to that timestamp as closely as possible.");
            gridData = new GridData();
            gridData.horizontalIndent = 40;
            this.btnKeepSynched.setLayoutData((Object)gridData);
            fullPageViewForm.setTopCenter((Control)this.topCenterComposite);
            Composite innerTableComposite = new Composite((Composite)fullPageViewForm, 0);
            TableColumnLayout tcLayout = new TableColumnLayout();
            innerTableComposite.setLayout((Layout)tcLayout);
            this.viewer = new TableViewer(innerTableComposite, 268503810);
            this.fLabelProvider = Utils.isPlatformWindows() ? new LogItemLabelProvider(lgfmt) : new LILabelProviderLinux(lgfmt);
            this.viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fContentProvider = new LogContentProvider();
            this.viewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.viewer.setUseHashlookup(true);
            this.table = this.viewer.getTable();
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            fullPageViewForm.setContent((Control)innerTableComposite);
            String[] columnNames = this.logFormat.getColumnNames();
            int[] columnWeights = this.logFormat.getColumnWeights();
            this.columns = new TableColumn[columnNames.length];
            int i = 0;
            while (i < this.columns.length) {
                this.columns[i] = new TableColumn(this.table, 16384);
                this.columns[i].setText(columnNames[i]);
                tcLayout.setColumnData((Widget)this.columns[i], (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
                this.columns[i].addControlListener(new ControlListener(){

                    public void controlResized(ControlEvent e) {
                        TableColumn column = (TableColumn)e.getSource();
                        if (column.getWidth() < 10) {
                            column.setWidth(10);
                        }
                        String text = column.getText();
                        String width = Integer.toString(column.getWidth());
                        LogTableViewer.this.saveColumnWidths(text, width);
                    }

                    public void controlMoved(ControlEvent e) {
                    }
                });
                ++i;
            }
            this.filterList = new LogItemFilteredList(this.resName, (ISerializator)new LogItemSerializator(this.logFormat.getDateFormat()));
            this.parser.addListener(new IParserFileListener(){

                public void done(ParserEvent evt) {
                    int fileIndex = evt.getFileIndex();
                    if (LogTableViewer.this.table.isDisposed() || fileIndex > 0 && fileIndex < evt.getNumberOfFiles() - 1) {
                        return;
                    }
                    LogTableViewer.this.table.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (LogTableViewer.this.table.isDisposed()) {
                                return;
                            }
                            LogTableViewer.this.table.setRedraw(false);
                            LogTableViewer.this.viewer.setItemCount(LogTableViewer.this.filterList.size());
                            LogTableViewer.this.table.setRedraw(true);
                            LogTableViewer.this.viewer.refresh(true);
                            if (LogTableViewer.this.viewer.getSelection().isEmpty() && LogTableViewer.this.filterList.size() > 0) {
                                LogItem logItem = (LogItem)LogTableViewer.this.filterList.get(0);
                                LogTableViewer.this.viewer.setSelection((ISelection)new StructuredSelection((Object)logItem));
                            }
                            if (LogParser.isLoggingEvents()) {
                                TimerUtils.report((String)(String.valueOf(LogTableViewer.this.logFormat.getName()) + ": "), (String)"");
                            }
                        }
                    });
                }
            });
            if (!Utils.isPlatformWindows()) {
                this.table.addListener(40, new Listener(){
                    private Event event;
                    private GC gc;
                    private TableItem item;
                    private LogItem logItem;

                    public void handleEvent(Event event) {
                        Map<String, RGB> mapHighlightKeywords;
                        this.event = event;
                        this.gc = event.gc;
                        this.item = (TableItem)event.item;
                        this.logItem = (LogItem)this.item.getData();
                        this.cleanCellBackground();
                        String keyword = LogTableViewer.this.fLabelProvider.getSearchKey();
                        if (keyword != null && keyword.length() != 0) {
                            this.higlightCell(keyword, LogTableViewer.this.fLabelProvider.getHighlightColor());
                        }
                        if ((mapHighlightKeywords = LogTableViewer.this.fLabelProvider.getMapHighlightKeywords()) != null && !mapHighlightKeywords.isEmpty()) {
                            for (Map.Entry<String, RGB> entry : mapHighlightKeywords.entrySet()) {
                                String akeyword = entry.getKey();
                                RGB rgb = entry.getValue();
                                Color color = new Color((Device)Display.getCurrent(), rgb);
                                this.higlightCell(akeyword, color);
                            }
                        }
                        event.detail &= 0xFFFFFFF7;
                        event.detail &= 0xFFFFFFDF;
                    }

                    private void cleanCellBackground() {
                        this.gc.setBackground(LogItemLabelProvider.getBackground(this.logItem));
                        this.gc.fillRectangle(this.event.x, this.event.y, this.event.width, this.event.height);
                    }

                    private void higlightCell(String keyword, Color color) {
                        String logCellString = "";
                        try {
                            logCellString = this.logItem.getLogField(this.event.index, LogTableViewer.this.logFormat).toString();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        int[] keywordLocations = LogItemLabelProvider.searchHitsToArray(logCellString, keyword);
                        if (keywordLocations.length == 0) {
                            return;
                        }
                        Rectangle textBounds = this.item.getTextBounds(this.event.index);
                        int i = 0;
                        while (i < keywordLocations.length) {
                            int location = keywordLocations[i];
                            String beforeKeyword = logCellString.substring(0, location);
                            Point startOfHighlight = this.gc.textExtent(beforeKeyword);
                            Point endOfHighlight = this.gc.textExtent(keyword);
                            int beginHighlight = textBounds.x + startOfHighlight.x;
                            int highlightWidth = endOfHighlight.x;
                            Color oldForeground = this.gc.getForeground();
                            Color oldBackground = this.gc.getBackground();
                            this.gc.setBackground(color);
                            this.gc.fillRectangle(beginHighlight, this.event.y, highlightWidth, this.event.height);
                            this.gc.setForeground(oldForeground);
                            this.gc.setBackground(oldBackground);
                            i += 2;
                        }
                    }
                });
            }
            this.cellDoubleclicked = new Action(){

                public void run() {
                    try {
                        IViewPart viewPart = LogTableViewer.this.myLogBrowserEditor.getSite().getPage().showView("com.vmware.vide.vlogbrowser.ui.logEntryDetailView");
                        if (viewPart instanceof LogEntryDetailView) {
                            ISelection selection = LogTableViewer.this.viewer.getSelection();
                            ((LogEntryDetailView)viewPart).selectionChanged((IWorkbenchPart)LogTableViewer.this.myLogBrowserEditor, selection);
                        }
                    }
                    catch (PartInitException e) {
                        logger.error("Error while creating/openning Eclipse view: {}", (Object)"com.vmware.vide.vlogbrowser.ui.logEntryDetailView", (Object)e);
                    }
                }
            };
            this.viewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    LogTableViewer.this.cellDoubleclicked.run();
                }
            });
            this.table.addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 1 && LogTableViewer.this.isKeepSynched()) {
                        Date logItemDate = LogTableViewer.this.getSelectedDate(true);
                        IWorkbenchPage myPage = mySite.getPage();
                        IEditorPart myEditor = myPage.getActiveEditor();
                        ((LogBrowserEditor)myEditor).findByDateInOtherEditors(logItemDate);
                    }
                }
            });
            this.table.setToolTipText("");
            this.table.addListener(32, new Listener(){

                public void handleEvent(Event event) {
                    TableItem item = LogTableViewer.this.table.getItem(new Point(event.x, event.y));
                    if (item != null) {
                        LogItem logItem = (LogItem)item.getData();
                        String logExtraStr = "";
                        try {
                            logExtraStr = logItem.getLogExtra(LogTableViewer.this.logFormat);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (logExtraStr.length() == 0) {
                            LogTableViewer.this.table.setToolTipText("");
                        } else if (logExtraStr.length() > 300) {
                            logExtraStr = logExtraStr.substring(0, 300);
                            LogTableViewer.this.table.setToolTipText(LogTableViewer.TOOLTIP_PREAMBLE + logExtraStr + LogTableViewer.TOOLTIP_EXTRA);
                        } else {
                            LogTableViewer.this.table.setToolTipText(LogTableViewer.TOOLTIP_PREAMBLE + logExtraStr);
                        }
                    }
                }
            });
            this.table.addListener(5, new Listener(){

                public void handleEvent(Event event) {
                    LogTableViewer.this.table.setToolTipText("");
                }
            });
            this.viewer.setInput(this.filterList);
            this.setupContextMenu();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public UiLogFileManager getLogFileMgr() {
        return this.logFileMgr;
    }

    public void updateFilter(IProgressMonitor myMonitor, LogFilter logFilter) throws Exception {
        this.fLogFilter = logFilter;
        if (!this.fLogFilter.isFilterEnabled()) {
            myMonitor.beginTask("Removing filter from table...", 1);
            this.filterList.removeFilter(this.matcherFilter);
            this.filterList.refresh((IProgressMonitor)new SubProgressMonitor(myMonitor, 1));
        } else {
            Integer surroundingLinesInt = this.fLogFilter.getNumSurroundingLines();
            String aroundString = surroundingLinesInt > 0 ? surroundingLinesInt.toString() : null;
            final StringBuffer filterTxt = new StringBuffer();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    filterTxt.append(LogTableViewer.this.txtFilter.getText());
                }
            });
            if (this.fLogFilter.isJustAKeyword()) {
                this.recorder.applyFilter(this.prjName, this.resName, filterTxt.toString(), aroundString);
            } else {
                this.recorder.applyFilterByName(this.prjName, this.resName, this.fLogFilter.getName());
            }
            int numSurroundingLines = this.fLogFilter.getNumSurroundingLines();
            MultiMatcher matcher = MultiMatcherFactory.getMultiMatcher((LogFilter)this.fLogFilter, (LogFormat)this.logFormat);
            this.matcherFilter = numSurroundingLines > 0 ? new GroupMatcherFilter((ISingleMatcher)matcher, numSurroundingLines, this.filterList.getUnfiltered()) : new MatcherFilter((ISingleMatcher)matcher);
            myMonitor.beginTask("Applying filter to table...", 1);
            this.filterList.setFilters(Collections.singletonList(this.matcherFilter));
            this.filterList.refresh((IProgressMonitor)new SubProgressMonitor(myMonitor, 1));
        }
        this.table.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LogTableViewer.this.table.setRedraw(false);
                LogTableViewer.this.viewer.setItemCount(LogTableViewer.this.filterList.size());
                LogTableViewer.this.table.setRedraw(true);
                LogTableViewer.this.viewer.refresh();
                LogTableViewer.this.notifyFilteredListeners();
                LogTableViewer.this.gotoIndexNum(LogTableViewer.this.getCurrentIndexNum());
            }
        });
        myMonitor.done();
    }

    public synchronized void addFilterListener(IFilterListener<LogItem> listener) {
        this.filterListListener.add(listener);
    }

    public synchronized void removeFilterListener(IFilterListener<LogItem> listener) {
        this.filterListListener.remove(listener);
    }

    public void notifyFilteredListeners() {
        for (IFilterListener<LogItem> listener : this.filterListListener) {
            listener.filterPerformed(this.filterList);
        }
    }

    public LogFilter getMyLogFilter() {
        return this.fLogFilter;
    }

    public Map<String, LogFilter> getNamedLogFilters() {
        return this.namedLogFilters;
    }

    @Deprecated
    public void sortColumn(int col, int currentSortDir, IProgressMonitor monitor) {
    }

    public void loadAllLogFilesInTable(boolean forceReload, IProgressMonitor myMonitor) {
        myMonitor.beginTask("Initializing", 30);
        myMonitor.subTask("Waiting for access to log entry list...");
        try {
            myMonitor.subTask("Starting log entry table...");
            this.filterList.clear();
            myMonitor.worked(1);
            myMonitor.subTask("Checking log file staging area...");
            this.logFormat.closeAllRandAccFiles();
            List raFiles = null;
            this.logFileMgr.prepareStagingDir(forceReload);
            if (!forceReload) {
                raFiles = this.logFileMgr.loadFilesFromManifest();
            }
            myMonitor.worked(1);
            this.logWorker.setFilterList(this.filterList);
            this.logWorker.setLogFormat(this.logFormat);
            this.logWorker.setParent(this.topRightComposite);
            this.logWorker.setLogFileMgr(this.logFileMgr);
            this.logWorker.setEditor((IEditorPart)this.myLogBrowserEditor);
            if (raFiles == null || raFiles.size() == 0) {
                String errorMessage = "No log files loaded";
                try {
                    raFiles = this.logFileMgr.getFileList();
                }
                catch (FileNotFoundException e) {
                    errorMessage = e.getMessage();
                }
                if (raFiles == null || raFiles.size() == 0) {
                    this.logWorker.parseFilesIntoTable((IProgressMonitor)new SubProgressMonitor(myMonitor, 18));
                    myMonitor.done();
                    throw new LoadingLogfilesException(errorMessage);
                }
                int lim = this.logFormat.getSizeLimitMB();
                if (lim != -1) {
                    raFiles = this.logFileMgr.trimFileList(raFiles, lim);
                }
                this.logWorker.marshalLogFiles(raFiles, (IProgressMonitor)new SubProgressMonitor(myMonitor, 10));
            } else {
                myMonitor.worked(10);
            }
            final List raFiles2 = raFiles;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    String msg = String.valueOf(((RAFile)raFiles2.get(0)).toShortDisplayString()) + (raFiles2.size() > 1 ? "..." : "");
                    LogTableViewer.this.txtLogFilesLoaded.setText(msg);
                }
            });
            this.logFilesInfoStr = LogFileUtils.getFileListStr((List)raFiles);
            this.logFormat.loadNewRAFileList(raFiles);
            this.logWorker.parseFilesIntoTable((IProgressMonitor)new SubProgressMonitor(myMonitor, 18));
        }
        catch (LoadingLogfilesException e) {
            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Warning", (String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            LogBrowserUiPlugin.log(e);
            myMonitor.setCanceled(true);
            LogDialog dialog = new LogDialog(Display.getDefault().getActiveShell(), "Read Error", null, "Error reading file", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.setMessage("The input log file could not be read due to an error: " + e.getMessage());
            dialog.open();
        }
        myMonitor.done();
    }

    public void addLogFilesToTable(String srcHostChoice, String fullLogFilePaths) {
        try {
            IWorkbenchPage myPage = this.mySite.getPage();
            IEditorPart myEditor = myPage.getActiveEditor();
            this.logFileMgr.addLogFiles(srcHostChoice, fullLogFilePaths, (LogBrowserEditor)myEditor);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)"Error", (String)e.getMessage());
            e.printStackTrace();
        }
        LogLoadRunner llRunner = new LogLoadRunner(this, true, "Reloading log set to include newly added log files.");
        llRunner.schedule();
    }

    public long getCurrentIndexNum() {
        long currentIndex = -1L;
        StructuredSelection mySel = (StructuredSelection)this.viewer.getSelection();
        Object myItem = mySel.getFirstElement();
        if (myItem != null && myItem instanceof LogItem) {
            currentIndex = ((LogItem)myItem).getLogIndexNum();
        }
        return currentIndex;
    }

    public void gotoIndexNum(long logIndexNum) {
        if (logIndexNum < 0L) {
            return;
        }
        IndexMatcher matcher = new IndexMatcher(logIndexNum);
        int i = 0;
        while (i < this.filterList.size()) {
            LogItem logItem = (LogItem)this.filterList.get(i);
            if (matcher.matches(logItem)) {
                this.table.setSelection(i);
                this.table.showSelection();
                break;
            }
            ++i;
        }
    }

    public void showCurrentSelection() {
        this.table.showSelection();
    }

    public boolean findNext() {
        LogItem logItem;
        this.recorder.findPattern(this.prjName, this.resName, this.findKeyword, null, null);
        LogItemMatcher matcher = new LogItemMatcher(this.findKeyword, this.logFormat);
        int myIndex = 0;
        StructuredSelection mySel = (StructuredSelection)this.viewer.getSelection();
        Object myItem = mySel.getFirstElement();
        if (myItem != null && (myIndex = this.filterList.indexOf(myItem) + 1) >= this.filterList.size()) {
            myIndex = 0;
        }
        boolean matched = false;
        int i = myIndex;
        while (i < this.filterList.size()) {
            logItem = (LogItem)this.filterList.get(i);
            if (matcher.matchesSomeField(logItem)) {
                this.table.setSelection(i);
                this.table.showSelection();
                matched = true;
                break;
            }
            ++i;
        }
        if (!matched && myIndex > 0) {
            i = 0;
            while (i < this.filterList.size()) {
                logItem = (LogItem)this.filterList.get(i);
                if (matcher.matchesSomeField(logItem)) {
                    this.table.setSelection(i);
                    this.table.showSelection();
                    matched = true;
                    break;
                }
                ++i;
            }
        }
        return matched;
    }

    public void findAll() {
        this.recorder.findPattern(this.prjName, this.resName, this.findKeyword, null, null);
        LogItemMatcher lim = new LogItemMatcher(this.findKeyword, this.logFormat);
        ArrayList<Integer> matchedIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < this.filterList.size()) {
            LogItem li = (LogItem)this.filterList.get(i);
            if (lim.matchesSomeField(li)) {
                matchedIndices.add(i);
                if (matchedIndices.size() == 3000) {
                    LogDialog dialog = new LogDialog(this.viewer.getControl().getShell(), "Information", null, "Select All Limit Reached", 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.setMessage("The 'Select All' function reached the limit of 3000 matching items.");
                    dialog.open();
                    break;
                }
            }
            ++i;
        }
        int[] intIndices = new int[matchedIndices.size()];
        int i2 = 0;
        while (i2 < intIndices.length) {
            intIndices[i2] = (Integer)matchedIndices.get(i2);
            ++i2;
        }
        this.table.setFocus();
        this.table.setSelection(intIndices);
        this.table.showSelection();
    }

    public void findClosestDate(Date findDate) {
        long findDateInMillis = findDate.getTime() - this.logFormat.getDateDelta();
        DateMatcher dateMatcher = new DateMatcher(new Date(findDateInMillis));
        int i = 0;
        while (i < this.filterList.size()) {
            LogItem logItem = (LogItem)this.filterList.get(i);
            dateMatcher.submitMatchCandidate(logItem, i);
            ++i;
        }
        this.table.setSelection(dateMatcher.getClosestMatchIndex());
        this.table.showSelection();
    }

    public Date getSelectedDate(boolean includeAdjustment) {
        Object myItem;
        StructuredSelection mySel = (StructuredSelection)this.viewer.getSelection();
        if (mySel != null && (myItem = mySel.getFirstElement()) != null && myItem instanceof LogItem) {
            long returnDateInMillis = ((LogItem)myItem).getLogDate().getTime();
            if (includeAdjustment) {
                returnDateInMillis += this.logFormat.getDateDelta().longValue();
            }
            return new Date(returnDateInMillis);
        }
        return null;
    }

    public void highlight(String highlightKeyword) {
        this.fLabelProvider.setSearchKey(highlightKeyword);
        this.viewer.refresh();
    }

    public void highlight(Map<String, RGB> mapDefaultKeywords) {
        this.fLabelProvider.setMapHighlightKeywords(mapDefaultKeywords);
        this.viewer.refresh();
    }

    public void copyClipboard() {
        StructuredSelection mySel = (StructuredSelection)this.viewer.getSelection();
        Clipboard cb = new Clipboard(Display.getDefault());
        ArrayList<LogItem> selectedItems = new ArrayList<LogItem>();
        if (mySel != null && mySel instanceof IStructuredSelection) {
            StructuredSelection iSel = mySel;
            for (LogItem myItem : iSel) {
                selectedItems.add(myItem);
            }
            if (selectedItems.size() > 0) {
                String returnStr = "";
                for (LogItem li : selectedItems) {
                    try {
                        returnStr = String.valueOf(returnStr) + li.toBriefString(this.logFormat);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    returnStr = String.valueOf(returnStr) + System.getProperty("line.separator");
                }
                Object[] data = new Object[]{returnStr};
                Transfer[] transArr = new Transfer[]{TextTransfer.getInstance()};
                cb.setContents(data, transArr);
            }
        }
    }

    public String getTxtFilterStr() {
        return this.txtFilter.getText();
    }

    public void setTxtFilterStr(String txtFilterStr) {
        if (txtFilterStr != null) {
            this.txtFilter.setText(txtFilterStr);
        } else {
            this.txtFilter.setText("");
        }
    }

    public String getBtnFilterStr() {
        return this.btnFilter.getText();
    }

    public void setBtnFilterStr(String btnFilterStr) {
        this.btnFilter.setText(btnFilterStr);
        this.btnFilter.pack();
        this.topLeftComposite.pack();
    }

    public String getCboFilterAddLinesStr() {
        return this.cboFilterAddLines.getText();
    }

    public void setCboFilterAddLinesStr(String cboFilterAddLinesStr) {
        this.cboFilterAddLines.setText(cboFilterAddLinesStr);
    }

    public String getTxtHighlightStr() {
        return this.txtHighlight.getText();
    }

    public void setTxtHighlightStr(String txtHighlightStr) {
        if (txtHighlightStr != null) {
            this.txtHighlight.setText(txtHighlightStr);
        } else {
            this.txtHighlight.setText("");
        }
    }

    public String getBtnHighlightStr() {
        return this.btnHighlight.getText();
    }

    public void setBtnHighlightStr(String btnHighlightStr) {
        this.btnHighlight.setText(btnHighlightStr);
    }

    public String getFindKeyword() {
        return this.findKeyword;
    }

    public void setFindKeyword(String findKeyword) {
        this.findKeyword = findKeyword;
    }

    private void setupContextMenu() {
        this.table.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Menu menu = new Menu((Decorations)LogTableViewer.this.table.getShell(), 8);
                MenuItem item = new MenuItem(menu, 8);
                item.setText(LogTableViewer.FILTER_BTN_LABEL);
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/filter.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.filter"));
                item = new MenuItem(menu, 8);
                item.setText("Find");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/find.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.find"));
                item = new MenuItem(menu, 8);
                item.setText("Find next...");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/findnext.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.findnext"));
                item = new MenuItem(menu, 8);
                item.setText("Find or Adjust Date...");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/findbydate.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.findbydate"));
                item = new MenuItem(menu, 2);
                item.setText("Start/stop recording log browser script");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/start-record-16x16.png"));
                item.setSelection(false);
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.recording.toggle"));
                item = new MenuItem(menu, 8);
                item.setText("Highlight");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/highlight.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.highlight"));
                item = new MenuItem(menu, 8);
                item.setText("Copy");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/copyclip.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.copyclipboard"));
                item = new MenuItem(menu, 8);
                item.setText("Refresh");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/refresh.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.refresh"));
                item = new MenuItem(menu, 8);
                item.setText("View Log Info");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/loginfo.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.loginfo"));
                item = new MenuItem(menu, 8);
                item.setText("Add Log Files");
                item.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/addlogfiles.png"));
                item.addSelectionListener((SelectionListener)new MySelectionListener("com.vmware.vide.vlogbrowser.commands.addlogfiles"));
                Point pt = new Point(e.x, e.y);
                menu.setLocation(pt);
                menu.setVisible(true);
            }
        });
    }

    public String getLogFilesInfoStr() {
        return this.logFilesInfoStr;
    }

    public boolean isKeepSynched() {
        return this.btnKeepSynched.getSelection();
    }

    public String getLogFormatName() {
        return this.logFormat.getName();
    }

    public boolean applyDateDelta(long dateDelta) throws Exception {
        if (this.logFormat.getDateDelta() != dateDelta) {
            this.logFormat.setDateDelta(dateDelta);
            this.viewer.refresh(true);
            this.recorder.adjustTime(this.getProjectName(), this.getResourceName(), Long.toString(dateDelta));
            return true;
        }
        return false;
    }

    public boolean proceedWithLongOperation(String message, String alternativeMessage) {
        if (this.filterList.size() < 50000 || this.ignoreLongOpWarning) {
            return true;
        }
        LogDialog dialog = new LogDialog(this.viewer.getControl().getShell(), "Warning", null, "Please confirm this potentially long operation", 4, new String[]{"Proceed", "Cancel", "Disable Warnings and Proceed"}, 1);
        dialog.setMessage(String.valueOf(message) + "\n" + alternativeMessage);
        dialog.open();
        switch (dialog.getReturnCode()) {
            case 0: 
            case 10: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: 
            case 9: {
                this.ignoreLongOpWarning = true;
                return true;
            }
        }
        return false;
    }

    public Composite getPageComposite() {
        return this.pageComposite;
    }

    public void setTxtFilterEditable(boolean editable) {
        this.txtFilter.setEditable(editable);
        if (editable) {
            this.txtFilter.setBackground(Display.getCurrent().getSystemColor(1));
            this.txtFilter.setToolTipText("Enter a filter keyword here");
        } else {
            this.txtFilter.setBackground(Display.getCurrent().getSystemColor(15));
            this.txtFilter.setToolTipText("Named filter configured. Click to open the 'Keyword Filtering with a Named Filter' dialog.");
        }
    }

    public String getExternalFiltersFilePath() {
        return this.externalFiltersFilePath;
    }

    public void setExternalFiltersFilePath(String externalFiltersFilePath) {
        this.externalFiltersFilePath = externalFiltersFilePath;
    }

    private void saveColumnWidths(String columnName, String currentWidth) {
        ConfigParser cfgParser;
        Document configDoc;
        Element element;
        NodeList nodeListColumns;
        IWorkbenchPage myPage = this.mySite.getPage();
        IEditorPart myEditor = myPage.getActiveEditor();
        if (myEditor != null && (nodeListColumns = (element = (configDoc = (cfgParser = this.logFileMgr.getCfgParser()).getConfigDoc()).getDocumentElement()).getElementsByTagName("Columns")).getLength() == 1) {
            Node nodeColumns = nodeListColumns.item(0);
            ArrayList arrayColumn = XMLUtil.getAllChildrenNamed((String)"Column", (Node)nodeColumns);
            for (Node columnNode : arrayColumn) {
                String nodeName = XMLUtil.getChildValue((String)"Name", (Node)columnNode);
                if (nodeName == null || !nodeName.equals(columnName)) continue;
                Node nodeWidthWeight = XMLUtil.getChildNamed((String)"WidthWeight", (Node)columnNode);
                XMLParser.replaceNodeValue((Document)configDoc, (Node)nodeWidthWeight, (String)currentWidth, (boolean)true, (boolean)true);
                this.myLogBrowserEditor.overwriteTextInEditor(cfgParser.getXmlFromDocument());
                break;
            }
        }
    }

    public IFilteredList<LogItem> getFilterList() {
        return this.filterList;
    }

    public ParserJobListener getParserJobListener() {
        return this.logWorker.getParserJobListener();
    }

    public LogWorker getLogWorker() {
        return this.logWorker;
    }

    public LogFormat getLogFormat() {
        return this.logFormat;
    }

    public void setVisibleLinkAdvancedUnhighlight(boolean visible) {
        this.advancedUnhighlightLink.setVisible(visible);
    }

    public ConfigParser getConfigParser() {
        return this.logFileMgr.getCfgParser();
    }

    public LogBrowserEditor getMyLogBrowserEditor() {
        return this.myLogBrowserEditor;
    }

    public TableViewer getJfaceTableViewer() {
        return this.viewer;
    }

    public String getResourceName() {
        return this.resName;
    }

    public String getProjectName() {
        return this.prjName;
    }

    private class LoadingLogfilesException
    extends Exception {
        public LoadingLogfilesException(String msg) {
            super(msg);
        }
    }

    private class MySelectionListener
    implements SelectionListener {
        private String commandId;

        public MySelectionListener(String commandId) {
            this.commandId = commandId;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            IHandlerService handlerSvc = (IHandlerService)LogTableViewer.this.mySite.getService(IHandlerService.class);
            try {
                handlerSvc.executeCommand(this.commandId, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

