/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.tableviewer;

import com.vmware.vide.vlogbrowser.core.fileops.BaseLogWorker;
import com.vmware.vide.vlogbrowser.core.parser.LogParser;
import com.vmware.vide.vlogbrowser.ui.dialogs.LogDialog;
import com.vmware.vide.vlogbrowser.ui.tableviewer.ParserJobListener;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class LogWorker
extends BaseLogWorker {
    private ParserJobListener myJobListener = new ParserJobListener();
    private Composite parent;
    private IEditorPart editor;

    public LogWorker(LogParser parser) {
        super(parser);
    }

    public boolean areAllJobsCanceled() {
        ParserJobListener.ParserJobState jobState = this.myJobListener.getJobState();
        return jobState == ParserJobListener.ParserJobState.CANCELLED;
    }

    public void prepareToRun(Job job) {
        this.myJobListener.addEditorJob(this.editor, job);
        job.addJobChangeListener((IJobChangeListener)this.myJobListener);
    }

    public void handleCopyFileException(final Exception e) {
        if (this.parent.isDisposed()) {
            return;
        }
        final Display myDisplay = this.parent.getDisplay();
        myDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                LogDialog dialog = new LogDialog(myDisplay.getActiveShell(), "File copy error", null, "The file could not be copied from the source to the staging area.", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setMessage(e.getMessage());
                dialog.open();
            }
        });
    }

    public void handleReadFileException(final Exception e) {
        if (this.parent.isDisposed()) {
            return;
        }
        final Display myDisplay = this.parent.getDisplay();
        myDisplay.syncExec(new Runnable(){

            @Override
            public void run() {
                LogDialog dialog = new LogDialog(myDisplay.getActiveShell(), "File read error", null, "The file could not be read.", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                e.printStackTrace();
                dialog.setMessage(e.getMessage());
                dialog.open();
            }
        });
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public ParserJobListener getParserJobListener() {
        return this.myJobListener;
    }

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }
}

