/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.views;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.ui.editors.LogBrowserEditor;
import java.io.IOException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogEntryDetailView
extends ViewPart
implements ISelectionListener,
IPartListener {
    private static final Logger logger = LoggerFactory.getLogger(LogEntryDetailView.class);
    public static final String VIEW_ID = "com.vmware.vide.vlogbrowser.ui.logEntryDetailView";
    private Composite composite = null;
    private LogBrowserEditor logBrowserEditor = null;

    public void createPartControl(Composite parent) {
        this.composite = parent;
        this.composite.setLayout((Layout)new GridLayout(2, false));
        IWorkbenchPage myWorkbenchPage = this.getSite().getPage();
        myWorkbenchPage.addPartListener((IPartListener)this);
        myWorkbenchPage.addSelectionListener((ISelectionListener)this);
    }

    public void setFocus() {
        this.composite.setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof LogItem) {
            LogItem logItem = (LogItem)element;
            if (part instanceof LogBrowserEditor) {
                this.logBrowserEditor = (LogBrowserEditor)part;
                this.disposeCompositeWidgets();
                LogBrowserEditor editor = (LogBrowserEditor)part;
                this.createWidgetsLogFileName(editor.getTitle());
                LogFormat logFormat = editor.getLogTableViewer().getLogFormat();
                String[] columns = logFormat.getColumnNames();
                int i = 0;
                while (i < columns.length) {
                    String column = columns[i];
                    boolean lastField = false;
                    try {
                        String field = logItem.getLogField(i, logFormat).toString();
                        if (i == columns.length - 1) {
                            lastField = true;
                            String logExtra = logItem.getLogExtra(logFormat);
                            if (logExtra.length() > 0) {
                                field = String.valueOf(field) + "\n" + logExtra;
                            }
                        }
                        this.createWidgetsLogEntryField(column, field, lastField);
                    }
                    catch (IOException e) {
                        logger.error("Error at Eclipse View -Log Entry Detail- while accessing log item: {}", (Object)logItem, (Object)e);
                    }
                    ++i;
                }
                this.composite.layout();
            }
        }
    }

    private void createWidgetsLogFileName(String logFileName) {
        Label labelLogFileName = new Label(this.composite, 0);
        labelLogFileName.setText("Log file name: " + logFileName);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 128;
        labelLogFileName.setLayoutData((Object)gridData);
        Label labelSeparator = new Label(this.composite, 258);
        gridData = new GridData(4, 0x1000000, false, false, 2, 1);
        labelSeparator.setLayoutData((Object)gridData);
    }

    private void createWidgetsLogEntryField(String column, String field, boolean lastField) {
        Label labelColumn = new Label(this.composite, 0);
        labelColumn.setText(String.valueOf(column) + ":");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 128;
        labelColumn.setLayoutData((Object)gridData);
        int style = 2050;
        if (lastField) {
            style |= 0x300;
        }
        Text textField = new Text(this.composite, style);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        if (!lastField) {
            gridData.verticalAlignment = 128;
        } else {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        textField.setLayoutData((Object)gridData);
        textField.setText(field);
        textField.setBackground(new Color((Device)Display.getCurrent(), 255, 255, 255));
        textField.setEditable(false);
    }

    private void disposeCompositeWidgets() {
        Control[] children;
        Control[] controlArray = children = this.composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
    }

    public void dispose() {
        IWorkbenchPage myWorkbenchPage = this.getSite().getPage();
        myWorkbenchPage.removePartListener((IPartListener)this);
        myWorkbenchPage.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void partClosed(IWorkbenchPart part) {
        LogBrowserEditor editor;
        if (part instanceof LogBrowserEditor && ((Object)((Object)(editor = (LogBrowserEditor)part))).equals((Object)this.logBrowserEditor)) {
            this.disposeCompositeWidgets();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

