/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.wizards;

import com.vmware.vide.vlogbrowser.core.fileops.LogFileManager;
import com.vmware.vide.vlogbrowser.core.fileops.LogxFileSetCreator;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.dialogs.LogDialog;
import com.vmware.vide.vlogbrowser.ui.wizards.LogBrowserNewWizard;
import com.vmware.vide.vlogbrowser.ui.wizards.LogxContentProvider;
import com.vmware.vide.vlogbrowser.ui.wizards.LogxEditingSupport;
import com.vmware.vide.vlogbrowser.ui.wizards.LogxLabelProvider;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LBNewWizardFinishPage
extends WizardPage {
    private static final Logger logger = LoggerFactory.getLogger(LBNewWizardFinishPage.class);
    private TableViewer lxTableViewer;
    private LogBrowserNewWizard myParentWizard;
    private List<LogxFile> myLxFiles;
    private LogxFileSetCreator logCreator;
    private IWizardPage firstPage;
    private IWizardPage pathPage;
    private TableViewerColumn[] fColumns;
    private Label notFoundLogxLabel;
    static final int COLUMN_CREATE = 0;
    static final int COLUMN_HOST = 1;
    static final int COLUMN_FILE = 2;
    static final int COLUMN_OPEN = 3;
    private static final int COLUMNS_COUNT = 4;
    private static final String HEADER_TITLE = "Summary";
    private static final String HEADER_MSG = "Select the .logx files you want to be created in the parent project {0}";

    public LBNewWizardFinishPage(ISelection selection, IWizardPage firstPage, IWizardPage pathPage) {
        super("LogBrowserNewWizardFinishPage");
        this.setTitle(HEADER_TITLE);
        this.setDescription("This wizard creates one or more new log analysis configuration files (.logx files).");
        this.setImageDescriptor(LogBrowserUiPlugin.getImageDescriptor("/icons/wizard.png"));
        this.logCreator = new LogxFileSetCreator();
        this.myLxFiles = this.logCreator.getLxFiles();
        this.firstPage = firstPage;
        this.pathPage = pathPage;
    }

    public void createControl(Composite parent) {
        this.myParentWizard = (LogBrowserNewWizard)this.getWizard();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        this.setControl((Control)container);
        Label descr = new Label(container, 0);
        descr.setText("&Select log analysis configuration files to create and open:");
        GridData data1 = new GridData(32, -1);
        data1.horizontalAlignment = 4;
        data1.horizontalSpan = 3;
        descr.setLayoutData((Object)data1);
        this.lxTableViewer = new TableViewer(container, 68354);
        GridData data2 = new GridData();
        data2.grabExcessVerticalSpace = true;
        data2.grabExcessHorizontalSpace = true;
        data2.horizontalAlignment = 4;
        data2.verticalAlignment = 4;
        this.lxTableViewer.getTable().setLayoutData((Object)data2);
        Listener myEditListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 36) {
                    LBNewWizardFinishPage.this.updateStatus(null);
                }
            }
        };
        this.fColumns = new TableViewerColumn[4];
        this.fColumns[0] = new TableViewerColumn(this.lxTableViewer, 0);
        this.fColumns[0].getColumn().setWidth(75);
        this.fColumns[0].getColumn().setText("Create");
        this.fColumns[0].getColumn().setToolTipText("If checked, the .logx file specified in this row will be created in the project. If unchecked, it will be ignored.");
        LogxEditingSupport lxEnableEditing = new LogxEditingSupport((ColumnViewer)this.lxTableViewer, 0, myEditListener);
        this.fColumns[0].setEditingSupport((EditingSupport)lxEnableEditing);
        this.fColumns[1] = new TableViewerColumn(this.lxTableViewer, 0);
        this.fColumns[1].getColumn().setWidth(200);
        this.fColumns[1].getColumn().setText("Host (Log Format)");
        this.fColumns[2] = new TableViewerColumn(this.lxTableViewer, 0);
        this.fColumns[2].getColumn().setWidth(225);
        this.fColumns[2].getColumn().setText("New File Name");
        this.fColumns[2].getColumn().setToolTipText("Name of the .logx file that will be created in project. You can then open that file in Log Analysis to view and analyze the underlying log entries.");
        LogxEditingSupport lxNameEditing = new LogxEditingSupport((ColumnViewer)this.lxTableViewer, 2, myEditListener);
        this.fColumns[2].setEditingSupport((EditingSupport)lxNameEditing);
        this.fColumns[3] = new TableViewerColumn(this.lxTableViewer, 0);
        this.fColumns[3].getColumn().setWidth(75);
        this.fColumns[3].getColumn().setText("Open");
        this.fColumns[3].getColumn().setToolTipText("Check this box to open Log Analysis  for this file after completion of this wizard.");
        this.fColumns[3].setEditingSupport((EditingSupport)new LogxEditingSupport((ColumnViewer)this.lxTableViewer, 3));
        Table table = this.lxTableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.marginWidth = 0;
        gl_composite.marginHeight = 0;
        composite.setLayout((Layout)gl_composite);
        Button selectAll = new Button(composite, 0);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LBNewWizardFinishPage.this.selectAll(true);
            }
        });
        selectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        selectAll.setText("Select &All");
        Button deselectAll = new Button(composite, 0);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LBNewWizardFinishPage.this.selectAll(false);
            }
        });
        deselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        deselectAll.setText("&Deselect All");
        Label vfiller = new Label(composite, 0);
        vfiller.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.lxTableViewer.setContentProvider((IContentProvider)new LogxContentProvider());
        this.lxTableViewer.setLabelProvider((IBaseLabelProvider)new LogxLabelProvider());
        this.notFoundLogxLabel = new Label(container, 0);
        this.notFoundLogxLabel.setText("* Entries in red were not found in the host.");
        GridData data3 = new GridData();
        data3.horizontalSpan = 3;
        this.notFoundLogxLabel.setLayoutData((Object)data3);
        this.notFoundLogxLabel.setVisible(false);
        this.updateStatus(null);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            try {
                this.addLogxFilesToList();
            }
            catch (Exception e) {
                LogDialog dialog = new LogDialog(this.getShell(), "Logx Error", null, "Error creating .logx file list", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.setMessage("The .logx file list could not be created due to an error: " + e.getMessage());
                dialog.setBlockOnOpen(false);
                dialog.open();
                e.printStackTrace();
            }
            this.lxTableViewer.setInput(this.myLxFiles);
            this.lxTableViewer.refresh();
            String msg = MessageFormat.format(HEADER_MSG, this.myParentWizard.getChosenProjectContainer());
            this.setMessage(msg);
        }
        super.setVisible(visible);
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        boolean atLeastOneIsEnabled = false;
        for (LogxFile lxFile : this.myLxFiles) {
            if (!lxFile.isCreateThisFile()) continue;
            atLeastOneIsEnabled = true;
            break;
        }
        message = !atLeastOneIsEnabled ? "At least one of the rows must be enabled." : this.checkLogxFilenames();
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private String checkLogxFilenames() {
        this.logCreator.setProject(this.myParentWizard.getChosenProjectContainer());
        return this.logCreator.checkLogxFilenames();
    }

    private void addLogxFilesToList() throws Exception {
        String hostname = this.myParentWizard.getChosenSrcHost();
        LogxFile selectedFormat = this.myParentWizard.getSelectedLogFormat();
        String selectedFormatName = this.myParentWizard.getSelectedLogFormatName();
        String tgzFilepath = this.myParentWizard.getTGZFilepath();
        String parentDir = this.myParentWizard.getParentDir();
        String filePatterns = this.myParentWizard.getFilePatterns();
        this.logCreator.setProject(this.myParentWizard.getChosenProjectContainer());
        this.logCreator.addLogxFilesToList(hostname, selectedFormat, selectedFormatName, tgzFilepath, parentDir, filePatterns);
        this.checkIfLogxFilesExistAndUpdateCreateSelection();
    }

    private void checkIfLogxFilesExistAndUpdateCreateSelection() {
        boolean notFoundLabelVisible = false;
        for (LogxFile lxFile : this.myLxFiles) {
            ConfigParser cfgParser;
            try {
                cfgParser = LogxFileSetCreator.createParserForLogxFile((LogxFile)lxFile);
            }
            catch (Exception e) {
                logger.error("Error creating parser for lxFile", (Throwable)e);
                continue;
            }
            boolean logFilesExist = true;
            try {
                LogFileManager manager = new LogFileManager(cfgParser);
                List raFiles = manager.getFileList();
                if (raFiles == null || raFiles.size() == 0) {
                    logFilesExist = false;
                }
            }
            catch (Exception e) {
                logger.info("Log format " + lxFile.getLogFormatName() + " appears not to have any log files.", (Throwable)e);
                logFilesExist = false;
            }
            lxFile.setCreateThisFile(logFilesExist);
            lxFile.setLogFilesExist(logFilesExist);
            boolean bl = notFoundLabelVisible = notFoundLabelVisible || !logFilesExist;
        }
        this.notFoundLogxLabel.setVisible(notFoundLabelVisible);
    }

    protected List<LogxFile> getLogxFileList() {
        return this.myLxFiles;
    }

    public IWizardPage getPreviousPage() {
        if (this.myParentWizard.getSelectedLogFormatName().equals("[Standard Log Collection]")) {
            return this.firstPage;
        }
        return this.pathPage;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private void selectAll(boolean flag) {
        int i = 0;
        while (i < this.myLxFiles.size()) {
            LogxFile f = this.myLxFiles.get(i);
            if (f.logFilesExist()) {
                f.setCreateThisFile(flag);
                f.setOpenEditor(flag);
            }
            ++i;
        }
        this.lxTableViewer.refresh();
        this.updateStatus(null);
    }
}

