/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.ui.wizards;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetChangedEvent;
import com.vmware.vide.target.api.ITargetListener;
import com.vmware.vide.target.api.TargetManagerPlugin;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.LogBrowserPlugin;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileUtils;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.core.utils.Utils;
import com.vmware.vide.vlogbrowser.ui.LogBrowserUiPlugin;
import com.vmware.vide.vlogbrowser.ui.dialogs.LogDialog;
import com.vmware.vide.vlogbrowser.ui.runners.RemoteTargetListRunner;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class LBNewWizardStartPage
extends WizardPage {
    private static final IRSESystemType[] validRSEWizardTypes = new IRSESystemType[]{RSECorePlugin.getTheCoreRegistry().getSystemTypeById("vide.rse.systemtype.esx"), RSECorePlugin.getTheCoreRegistry().getSystemTypeById("vide.rse.systemtype.vcva"), RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.linux"), RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.windows")};
    private final ISelection selection;
    private Shell shell;
    private Combo cboSrcHost;
    private Combo cboLogFormat;
    private Text txtProjContainer;
    private String rseLocalConnName;
    private IWizardPage pathPage;
    private IWizardPage finishPage;
    private final String TARGETS_FAILED_TITLE = "RSE Get Targets Failed";
    private final String TARGETS_FAILED_MSG = "Unexpected failure retrieving remote connections: ";
    private final HostListUpdater myHostListUpdater;
    private Label fHostTypeText;

    public LBNewWizardStartPage(ISelection selection) {
        super("LogBrowserNewWizardStartPage");
        this.setTitle("Log Host and Format Selection");
        this.setDescription("This wizard creates one or more new vLogBrowser configuration files (.logx files).");
        this.setMessage("Choose a source host for the log files, choose a log format to retrieve, and select a Project Container.\nMouse over each input for more information.");
        this.setImageDescriptor(LogBrowserUiPlugin.getImageDescriptor("/icons/wizard.png"));
        this.selection = selection;
        this.myHostListUpdater = new HostListUpdater();
        this.rseLocalConnName = "";
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.shell = parent.getShell();
        this.shell.setText("");
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = false;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        Label lblChooseSrcHost = new Label(container, 0);
        lblChooseSrcHost.setText("&Source host:");
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        lblChooseSrcHost.setLayoutData((Object)gd);
        this.cboSrcHost = new Combo(container, 12);
        this.cboSrcHost.setData("name", (Object)"cboSrcHost");
        this.cboSrcHost.add("");
        this.cboSrcHost.setVisibleItemCount(10);
        ITarget[] hostChoices = null;
        RemoteTargetListRunner rtlRunner = new RemoteTargetListRunner(this.myHostListUpdater);
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, (IRunnableWithProgress)rtlRunner);
            hostChoices = rtlRunner.getAllTargetNames();
        }
        catch (Exception e1) {
            MessageDialog.openError((Shell)this.getShell(), (String)"RSE Get Targets Failed", (String)("Unexpected failure retrieving remote connections: " + e1.getMessage()));
            e1.printStackTrace();
        }
        this.addSrcTargetsToList(hostChoices, false);
        this.cboSrcHost.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String hostTypeStr = "";
                try {
                    String srcHost = LBNewWizardStartPage.this.getSrcHostChoice();
                    ITarget target = LogFileUtils.getTarget((String)srcHost);
                    hostTypeStr = LBNewWizardStartPage.this.getSrcHostTypeMsgTxt(true);
                    String esxVersion = Utils.getSafeEsxVersion((ITarget)target, (String)hostTypeStr);
                    hostTypeStr = String.valueOf(hostTypeStr) + " " + esxVersion;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                LBNewWizardStartPage.this.fHostTypeText.setText(hostTypeStr);
                if (hostTypeStr.trim().length() > 0) {
                    LBNewWizardStartPage.this.reloadCboLogFormats();
                }
                LBNewWizardStartPage.this.updateStatus(null);
            }
        });
        gd = new GridData(1, 2, false, false);
        gd.widthHint = 300;
        this.cboSrcHost.setLayoutData((Object)gd);
        Button btnRefreshHosts = new Button(container, 0);
        btnRefreshHosts.setData("name", (Object)"btnRefreshHosts");
        btnRefreshHosts.setText("&Refresh");
        btnRefreshHosts.setToolTipText("Refresh Hosts");
        gd = new GridData();
        gd.widthHint = 100;
        btnRefreshHosts.setLayoutData((Object)gd);
        btnRefreshHosts.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/refresh.png"));
        btnRefreshHosts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LBNewWizardStartPage.this.refreshSrcHostList();
                LBNewWizardStartPage.this.updateStatus(null);
            }
        });
        Button btnAddHost = new Button(container, 0);
        btnAddHost.setData("name", (Object)"btnAddHost");
        btnAddHost.setText("&Add...");
        btnAddHost.setToolTipText("Add a New Host");
        gd = new GridData();
        gd.widthHint = 100;
        btnAddHost.setLayoutData((Object)gd);
        btnAddHost.setImage(LogBrowserUiPlugin.getDefault().getImage("/icons/addhost.png"));
        btnAddHost.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LBNewWizardStartPage.this.openAddTargetDialog();
            }
        });
        Label lblType = new Label(container, 0);
        lblType.setText("Host type:");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        lblType.setLayoutData((Object)gd);
        this.fHostTypeText = new Label(container, 0);
        this.fHostTypeText.setText("");
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        this.fHostTypeText.setLayoutData((Object)gd);
        Label lblChooseFormat = new Label(container, 0);
        lblChooseFormat.setText("&Log format:");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        lblChooseFormat.setLayoutData((Object)gd);
        this.cboLogFormat = new Combo(container, 12);
        this.cboLogFormat.setData("name", (Object)"cboLogFormat");
        gd = new GridData(1, 2, false, false);
        gd.horizontalSpan = 3;
        gd.widthHint = 300;
        this.cboLogFormat.setLayoutData((Object)gd);
        if (this.cboSrcHost.getText() != null && this.cboSrcHost.getText().length() > 0) {
            this.reloadCboLogFormats();
        }
        this.cboLogFormat.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LBNewWizardStartPage.this.updateStatus(null);
            }
        });
        this.cboLogFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LBNewWizardStartPage.this.cboLogFormat.getSelectionIndex();
                if (LBNewWizardStartPage.this.isItemCategory(index)) {
                    LBNewWizardStartPage.this.cboLogFormat.select(index + 1);
                }
            }
        });
        Label lblProjContainer = new Label(container, 0);
        lblProjContainer.setText("&Project container:");
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        lblProjContainer.setLayoutData((Object)gd);
        this.txtProjContainer = new Text(container, 2052);
        this.txtProjContainer.setData("name", (Object)"txtProjContainer");
        this.txtProjContainer.setEditable(true);
        String containerTip1 = "Project containers appear in the \"Project Explorer\" view and will contain the \".logx\" config file(s) created with this wizard.";
        this.txtProjContainer.setToolTipText(containerTip1);
        gd = new GridData(4, 2, false, false);
        this.txtProjContainer.setLayoutData((Object)gd);
        this.txtProjContainer.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                LBNewWizardStartPage.this.updateStatus(null);
            }
        });
        Button btnContainerBrowse = new Button(container, 8);
        btnContainerBrowse.setData("name", (Object)"btnContainerBrowse");
        btnContainerBrowse.setText("&Browse...");
        String containerTip2 = "Click to browse for a project container.";
        btnContainerBrowse.setToolTipText(String.valueOf(containerTip2) + "\n" + containerTip1);
        gd = new GridData(1, 2, false, false);
        gd.horizontalSpan = 2;
        gd.widthHint = 100;
        btnContainerBrowse.setLayoutData((Object)gd);
        btnContainerBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LBNewWizardStartPage.this.handleContainerBrowse();
                LBNewWizardStartPage.this.updateStatus(null);
            }
        });
        this.setControl((Control)container);
        this.initialize();
        this.updateStatus(null);
    }

    private boolean isItemCategory(int index) {
        String item = this.cboLogFormat.getItem(index);
        LogxFile template = (LogxFile)this.cboLogFormat.getData(Integer.toString(index));
        return template == null && !item.startsWith("[");
    }

    private void initialize() {
        IStructuredSelection ssel;
        Object obj;
        this.cboSrcHost.select(0);
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (obj = (ssel = (IStructuredSelection)this.selection).getFirstElement()) instanceof IResource) {
            IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
            this.txtProjContainer.setText(container.getFullPath().toString());
        }
    }

    private synchronized void addSrcTargetsToList(ITarget[] targets, boolean selectFirstAdded) {
        if (this.cboSrcHost == null || this.cboSrcHost.isDisposed()) {
            return;
        }
        ITarget[] iTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                String connectionName;
                block8: {
                    ITarget targ;
                    block7: {
                        targ = iTargetArray[n2];
                        if (LogFileUtils.arrayContains((Object[])this.cboSrcHost.getItems(), (Object)targ.getName())) break block6;
                        connectionName = targ.getName();
                        if (!targ.getTargetType().equals("localhost")) break block7;
                        this.rseLocalConnName = connectionName;
                        break block8;
                    }
                    if (!targ.isFileSystemSupported()) break block6;
                }
                this.cboSrcHost.add(connectionName);
                if (selectFirstAdded) {
                    this.cboSrcHost.select(this.cboSrcHost.getItemCount() - 1);
                    selectFirstAdded = false;
                }
            }
            ++n2;
        }
    }

    private synchronized void removeSrcTargetsFromList(ITarget[] targets) {
        if (this.cboSrcHost == null || this.cboSrcHost.isDisposed()) {
            return;
        }
        ITarget[] iTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITarget targ = iTargetArray[n2];
            if (LogFileUtils.arrayContains((Object[])this.cboSrcHost.getItems(), (Object)targ.getName())) {
                this.cboSrcHost.remove(targ.getName());
            }
            ++n2;
        }
    }

    private synchronized void refreshSrcHostList() {
        if (this.cboSrcHost == null || this.cboSrcHost.isDisposed()) {
            return;
        }
        String prevChoice = this.cboSrcHost.getText();
        this.cboSrcHost.removeAll();
        this.cboSrcHost.add("", 0);
        try {
            ITarget[] targets = TargetManagerPlugin.getTheTargetManager().getTargets();
            this.addSrcTargetsToList(targets, false);
        }
        catch (Exception e) {
            LogDialog dialog = new LogDialog(this.shell, "Refresh Error", null, "Error refreshing host list", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.setMessage("The host list could not be refreshed due to an error: " + e.getMessage());
            dialog.setBlockOnOpen(false);
            dialog.open();
            e.printStackTrace();
        }
        if (prevChoice.length() > 0 && LogFileUtils.arrayContains((Object[])this.cboSrcHost.getItems(), (Object)prevChoice)) {
            LogBrowserPlugin.getDefault().getLogBrowserManager().clearHostFormats(prevChoice);
            this.cboSrcHost.setText(prevChoice);
        }
    }

    private void reloadCboLogFormats() {
        LogxFile[] fixedPathFormats;
        String hostname = this.getSrcHostChoice();
        LogxFile selectedTemplate = this.getLogFormatChoice();
        this.cboLogFormat.removeAll();
        ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
        boolean showAll = manager.isShowAllTemplates(hostname);
        if (showAll) {
            this.cboLogFormat.add("[VMware Log Bundle]");
            int index = this.cboLogFormat.getItemCount();
            this.cboLogFormat.setData(Integer.toString(index - 1), null);
        }
        LogxFile[] logFormatsByHost = manager.getLogFormatsByHost(hostname, false);
        this.addTemplatesCategorized(logFormatsByHost);
        String srcHostType = this.getSrcHostType();
        if (srcHostType.equals("esx") && (fixedPathFormats = manager.getLogFormatsByHost(hostname, true)).length > 1) {
            this.cboLogFormat.add("[Standard Log Collection]");
            int index = this.cboLogFormat.getItemCount();
            this.cboLogFormat.setData(Integer.toString(index - 1), null);
        }
        if (!showAll) {
            this.cboLogFormat.add("[VMware Log Bundle]");
            int index = this.cboLogFormat.getItemCount();
            this.cboLogFormat.setData(Integer.toString(index - 1), null);
        }
        String prevChoice = selectedTemplate == null ? "" : String.valueOf(selectedTemplate.getCategory()) + "/" + selectedTemplate.getLogFormatName();
        String recentHostFormat = manager.getRecentHostFormat(hostname);
        if (recentHostFormat.length() > 0 && prevChoice.length() == 0) {
            prevChoice = recentHostFormat;
        }
        int newSelection = 0;
        int i = 0;
        while (i < this.cboLogFormat.getItemCount()) {
            LogxFile template = (LogxFile)this.cboLogFormat.getData(Integer.toString(i));
            String item = this.cboLogFormat.getItem(i).trim();
            if (template != null || item.equals(prevChoice)) {
                String s;
                String string = s = template == null ? item : String.valueOf(template.getCategory()) + "/" + template.getLogFormatName();
                if (s.equals(prevChoice)) {
                    newSelection = i;
                    break;
                }
            }
            ++i;
        }
        this.cboLogFormat.select(newSelection);
    }

    private void addTemplatesCategorized(LogxFile[] templates) {
        String[] categories;
        TreeSet<String> sortedCategories = new TreeSet<String>();
        int i = 0;
        while (i < templates.length) {
            LogxFile t = templates[i];
            String categoriesList = t.getCategory();
            String[] split = categoriesList.split(",");
            int j = 0;
            while (j < split.length) {
                String templateCategory = split[j].trim();
                if (!sortedCategories.contains(templateCategory)) {
                    sortedCategories.add(templateCategory);
                }
                ++j;
            }
            ++i;
        }
        String[] stringArray = categories = sortedCategories.toArray(new String[0]);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            this.cboLogFormat.add(category);
            int i2 = 0;
            while (i2 < templates.length) {
                LogxFile template = templates[i2];
                String categoriesList = template.getCategory();
                if (categoriesList.contains(category)) {
                    String[] split = categoriesList.split(",");
                    int j = 0;
                    while (j < split.length) {
                        String templateCategory = split[j].trim();
                        if (templateCategory.equals(category)) {
                            String logFormatName = template.getLogFormatName();
                            this.cboLogFormat.add("    " + logFormatName);
                            int index = this.cboLogFormat.getItemCount();
                            this.cboLogFormat.setData(Integer.toString(index - 1), (Object)template);
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++n2;
        }
    }

    private void handleContainerBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "Select new file container");
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.txtProjContainer.setText(((Path)result[0]).toString());
        }
    }

    protected boolean getSrcSupportSsh() {
        String srcHost = this.cboSrcHost.getText();
        try {
            if (!srcHost.isEmpty()) {
                ITarget target = LogFileUtils.getTarget((String)srcHost);
                return target.isSupportSsh();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting type for target '" + this.cboSrcHost.getText() + "'");
            e.printStackTrace();
        }
        return false;
    }

    protected String getSrcHostType() {
        String srcHost = this.cboSrcHost.getText();
        try {
            if (!srcHost.isEmpty()) {
                return LogFileUtils.getTarget((String)srcHost).getTargetType();
            }
        }
        catch (Exception e) {
            System.err.println("Error getting type for target '" + this.cboSrcHost.getText() + "'");
            e.printStackTrace();
        }
        return "";
    }

    protected String getHostTypeAndVersion() {
        return this.fHostTypeText.getText();
    }

    private String getSrcHostTypeMsgTxt(boolean retryOnError) {
        String srcHost = this.cboSrcHost.getText();
        try {
            if (!srcHost.isEmpty()) {
                ITarget system = LogFileUtils.getTarget((String)srcHost);
                ILogBrowserManager manager = LogBrowserPlugin.getDefault().getLogBrowserManager();
                return manager.getHostType(system, retryOnError);
            }
        }
        catch (Exception e) {
            System.err.println("Error getting type for target '" + this.cboSrcHost.getText() + "'");
            e.printStackTrace();
            return "Error contacting host";
        }
        return "";
    }

    protected String getSrcHostChoice() {
        if (this.cboSrcHost != null && !this.cboSrcHost.isDisposed()) {
            return this.cboSrcHost.getText();
        }
        return "";
    }

    protected LogxFile getLogFormatChoice() {
        if (this.cboLogFormat != null && !this.cboLogFormat.isDisposed()) {
            int selection = this.cboLogFormat.getSelectionIndex();
            LogxFile data = (LogxFile)this.cboLogFormat.getData(Integer.toString(selection));
            return data;
        }
        return null;
    }

    protected String getSelectedLogFormatName() {
        if (this.cboLogFormat != null && !this.cboLogFormat.isDisposed()) {
            String format;
            int selection = this.cboLogFormat.getSelectionIndex();
            LogxFile logxFile = (LogxFile)this.cboLogFormat.getData(Integer.toString(selection));
            String string = format = logxFile == null ? null : logxFile.getLogFormatName();
            if (format == null) {
                format = this.cboLogFormat.getItem(selection);
            }
            return format;
        }
        return null;
    }

    protected String getProjectContainer() {
        if (this.txtProjContainer != null && !this.txtProjContainer.isDisposed()) {
            return this.txtProjContainer.getText();
        }
        return "";
    }

    protected String getRseLocalConnName() {
        if (this.rseLocalConnName != null) {
            return this.rseLocalConnName;
        }
        return "";
    }

    private void openAddTargetDialog() {
        RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
        wizard.restrictToSystemTypes(validRSEWizardTypes);
        wizard.setWindowTitle("Create a new ESX or Linux (SSH) connection");
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private void updateStatus(String message) {
        int index;
        if (this.cboSrcHost.getText().length() == 0) {
            message = "Please choose a source host.";
        } else if (this.fHostTypeText.getText().equals("Error contacting host")) {
            message = "This host is not accessible. Please choose another one.";
        } else if (this.cboLogFormat.getText().length() == 0) {
            message = "Please choose a log format.";
        } else if (this.txtProjContainer.getText().length() == 0) {
            message = "Please choose a project container by clicking 'Browse', or type the name of a new project container to be created";
        } else if (this.txtProjContainer.getText().contains("RemoteSystemsTempFiles")) {
            message = "Invalid project container. Please choose another.";
        } else {
            IResource container;
            String regexValidate = "^/?[\\w][\\w\\.\\- ]*/?$";
            Pattern regexValidator = Pattern.compile(regexValidate);
            Matcher matcher = regexValidator.matcher(this.txtProjContainer.getText());
            if (!matcher.matches()) {
                message = "Project Container must be a valid project name and be a child of the root container.";
            }
            if ((container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.txtProjContainer.getText()))) != null && !container.isAccessible()) {
                message = "Project must be writable";
            }
        }
        if (message == null && this.cboLogFormat.getText().length() != 0 && this.isItemCategory(index = this.cboLogFormat.getSelectionIndex())) {
            String item = this.cboLogFormat.getItem(index);
            message = String.valueOf(item) + " is a category, please select a valid log format.";
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public IWizardPage getNextPage() {
        String selectedFormatName = this.getSelectedLogFormatName();
        if (selectedFormatName.equals("[Standard Log Collection]")) {
            return this.finishPage;
        }
        return this.pathPage;
    }

    protected void setNextTwoPages(IWizardPage pathPage, IWizardPage finishPage) {
        this.pathPage = pathPage;
        this.finishPage = finishPage;
    }

    public void dispose() {
        TargetManagerPlugin.getTheTargetManager().removeTargetListener((ITargetListener)this.myHostListUpdater);
        super.dispose();
    }

    private class HostListUpdater
    implements ITargetListener {
        private HostListUpdater() {
        }

        public void targetChanged(ITargetChangedEvent event) {
            if (event.getType() == 1) {
                ITarget target = event.getSources()[0];
                LBNewWizardStartPage.this.addSrcTargetsToList(event.getSources(), true);
                LBNewWizardStartPage.this.reloadCboLogFormats();
                String hostTypeStr = "";
                try {
                    hostTypeStr = LBNewWizardStartPage.this.getSrcHostTypeMsgTxt(false);
                    String esxVersion = Utils.getSafeEsxVersion((ITarget)target, (String)hostTypeStr);
                    hostTypeStr = String.valueOf(hostTypeStr) + " " + esxVersion;
                }
                catch (Exception exception) {}
                LBNewWizardStartPage.this.fHostTypeText.setText(hostTypeStr);
                LBNewWizardStartPage.this.updateStatus(null);
            } else if (event.getType() == 2) {
                LBNewWizardStartPage.this.removeSrcTargetsFromList(event.getSources());
            }
        }
    }
}

