/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimclient;

import com.vmware.vide.cimtools.core.cimclient.CIMClientAccess;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import java.util.ArrayList;
import java.util.List;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EnumCIMInstanceNames
extends CIMClientAccess {
    private static final String JOB_TITLE = "[WBEM] Enumerate CIM Instance Names ";
    private CIMHost cimhost;
    private CIMObjectPath cimobjpath;
    private List<CIMInstance> resultinstances;

    public EnumCIMInstanceNames(CIMHost host, CIMObjectPath path) {
        super(JOB_TITLE + (path != null ? " for " + path.toString() : ""));
        this.cimhost = host;
        this.cimobjpath = path;
        this.resultinstances = new ArrayList<CIMInstance>();
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("WBEM operation", 100);
            List<CIMObjectPath> instances = this.getEnumInstanceNames(this.cimhost, this.cimobjpath, monitor);
            monitor.worked(50);
            this.resultinstances.clear();
            for (CIMObjectPath instance : instances) {
                CIMInstance inst = new CIMInstance(instance, null);
                this.resultinstances.add(inst);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (CIMToolsException e) {
            this.exception = e;
        }
        finally {
            monitor.done();
        }
        return Status.CANCEL_STATUS;
    }

    public List<CIMInstance> getWBEMResult() {
        return this.resultinstances;
    }
}

