/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.core.cimcore;

import com.vmware.vide.cimtools.CIMToolsPlugin;
import com.vmware.vide.cimtools.core.cimclient.EnumCIMClasses;
import com.vmware.vide.cimtools.core.cimcore.CIMAssocClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.ui.cimbrowser.BrowserView;
import com.vmware.vide.cimtools.ui.cimbrowser.WBEMOperationView;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import com.vmware.vide.cimtools.utils.Utils;
import com.vmware.vide.target.api.ITarget;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.graphics.Image;

public class CIMHost
extends CIMTreeData {
    private final String namespace;
    private final URL hosturl;
    private final ITarget target;
    private final String sslProtocol;
    private Map<String, CIMClassData> allclasses;
    private SortedSet<Object> sortedclasses;
    private final Map<String, CIMBrowserViewData> viewclasses;
    private EnumCIMClasses enumclassesjob;
    private boolean initialized;

    public CIMHost(ITarget target, URL url, String namespace, String sslProtocol) {
        super(null, target != null ? target.getHostName() : null);
        this.target = target;
        this.hosturl = url;
        this.namespace = namespace;
        this.sslProtocol = sslProtocol;
        this.allclasses = new LinkedHashMap<String, CIMClassData>();
        this.viewclasses = new LinkedHashMap<String, CIMBrowserViewData>();
        this.viewclasses.put("com.vmware.vide.cimtools.inheritanceview", new CIMBrowserViewData(this, "com.vmware.vide.cimtools.inheritanceview"));
        this.viewclasses.put("com.vmware.vide.cimtools.schemaview", new CIMBrowserViewData(this, "com.vmware.vide.cimtools.schemaview"));
        this.viewclasses.put("com.vmware.vide.cimtools.instanceview", new CIMBrowserViewData(this, "com.vmware.vide.cimtools.instanceview"));
        this.enumclassesjob = null;
        this.initialized = false;
    }

    public CIMHost(ITarget target, String protocol, int port, String namespace, String sslProtocol) {
        this(target, Utils.getUrl(target.getHostName(), protocol, port, ""), namespace, sslProtocol);
    }

    public CIMHost(CIMHost host) {
        this(host.target, host.hosturl, host.namespace, null);
    }

    public CIMHost(CIMHost host, String namespace) {
        this(host.target, host.hosturl, namespace, null);
    }

    @Override
    public boolean isValid() {
        return this.target != null && this.hosturl != null && this.namespace != null && !this.namespace.isEmpty();
    }

    @Override
    public Object[] getChildren(String viewid, int viewtype) {
        if (viewtype == 1 && this.viewclasses.containsKey(viewid)) {
            return this.viewclasses.get(viewid).getAllClasses();
        }
        return new Object[0];
    }

    @Override
    public String getText() {
        return this.getCIMHostName();
    }

    @Override
    public Image getImage() {
        if (this.target.getTargetType().equals("esx")) {
            return CIMToolsPlugin.getDefault().getImage("virtualMachine.png");
        }
        return null;
    }

    public String getCIMHostName() {
        String username = this.target.getUserId();
        username = username == null || username.isEmpty() ? "" : "(" + username + ")";
        return String.valueOf(this.hosturl.toString()) + "/" + this.namespace + username;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public URL getHostURL() {
        return this.hosturl;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public String getUsername() {
        return this.target.getUserId();
    }

    public String getPassword(boolean prompt) {
        return this.target.getPassword(prompt);
    }

    public ITarget getTarget() {
        return this.target;
    }

    public synchronized EnumCIMClasses getCurrentEnumCIMClassesJob() {
        return this.enumclassesjob;
    }

    public synchronized void setCurrentEnumCIMClassesJob(EnumCIMClasses job) {
        this.enumclassesjob = job;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    private synchronized void setInitialized(boolean init) {
        this.initialized = init;
    }

    public void initializeBase(Map<String, CIMClassData> classes) throws CIMToolsException {
        this.allclasses = classes;
        this.collectAssociatedClasses();
        this.setSortedClasses();
        this.setInitialized(true);
    }

    public void addViewClasses(String viewid, CIMClassData[] classes) {
        if (this.viewclasses.containsKey(viewid)) {
            this.viewclasses.get(viewid).addViewClasses(classes);
        }
    }

    public void addAllClassesToInheritance() {
        CIMBrowserViewData viewdata = this.viewclasses.get("com.vmware.vide.cimtools.inheritanceview");
        viewdata.removeAll();
        viewdata.addViewClasses(this.allclasses);
    }

    public void restoreAll() throws CIMToolsException {
        this.allclasses.clear();
        EnumCIMClasses job = new EnumCIMClasses(this, null, true);
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                CIMToolsException exp;
                if (event.getResult().isOK()) {
                    for (CIMBrowserViewData vdata : CIMHost.this.viewclasses.values()) {
                        vdata.restoreClasses();
                        try {
                            BrowserView.refreshView(vdata.viewid, false, null);
                            WBEMOperationView.refreshView(false);
                        }
                        catch (Exception e) {
                            UtilDialog.openDialog(CIMToolsException.createCommonException(e.getMessage(), e));
                        }
                    }
                } else if (event.getJob() instanceof EnumCIMClasses && (exp = ((EnumCIMClasses)event.getJob()).getException()) != null) {
                    UtilDialog.openDialog(exp);
                }
            }
        });
    }

    public void remove(String viewid, CIMClassData[] cimclass) {
        if (this.viewclasses.containsKey(viewid)) {
            this.viewclasses.get(viewid).remove(cimclass);
        }
    }

    public void removeAllClasses(String viewid) {
        if (this.viewclasses.containsKey(viewid)) {
            CIMBrowserViewData data = this.viewclasses.get(viewid);
            data.removeAll();
        }
    }

    public void removeAllViewClasses(boolean removebase) {
        for (CIMBrowserViewData data : this.viewclasses.values()) {
            data.removeAll();
        }
        if (removebase) {
            this.allclasses.clear();
        }
    }

    public CIMClassData find(String classname) {
        for (CIMClassData cimclass : this.allclasses.values()) {
            CIMClassData data = cimclass.find(classname);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public CIMClassData find(CIMClassData classdata) {
        for (CIMClassData cimclass : this.allclasses.values()) {
            CIMClassData data = cimclass.find(classdata);
            if (data == null) continue;
            return data;
        }
        return null;
    }

    public CIMClassData findRoot(CIMClassData classdata) {
        for (CIMClassData cimclass : this.allclasses.values()) {
            CIMClassData data = cimclass.find(classdata);
            if (data == null) continue;
            return cimclass;
        }
        return null;
    }

    public ArrayList<CIMClassData> find(String[] classnames) {
        ArrayList<CIMClassData> classes = new ArrayList<CIMClassData>();
        String[] stringArray = classnames;
        int n = classnames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            CIMClassData classdata = this.find(name);
            if (classdata != null && classdata.isValid()) {
                classes.add(classdata);
            }
            ++n2;
        }
        return classes;
    }

    public SortedSet<Object> getSortedCIMClasses() {
        return this.sortedclasses;
    }

    private void collectAssociatedClasses() {
        for (CIMClassData data : this.allclasses.values()) {
            data.cleanSchemaElements();
        }
        for (CIMClassData data : this.allclasses.values()) {
            if (!(data instanceof CIMAssocClassData)) continue;
            ((CIMAssocClassData)data).collectAssociatedClasses();
        }
    }

    private void setSortedClasses() {
        this.sortedclasses = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object arg1, Object arg2) {
                String classname1 = arg1 instanceof CIMClassData ? ((CIMClassData)arg1).getCIMClassName() : arg1.toString();
                String classname2 = arg2 instanceof CIMClassData ? ((CIMClassData)arg2).getCIMClassName() : arg2.toString();
                return classname1.compareTo(classname2);
            }
        });
        for (CIMClassData data : this.allclasses.values()) {
            this.sortedclasses.addAll(data.getAllCIMClass());
        }
    }

    private class CIMBrowserViewData {
        private final CIMHost cimhost;
        private final String viewid;
        private LinkedHashMap<String, CIMClassData> viewclasses;

        public CIMBrowserViewData(CIMHost host, String viewid) {
            this.cimhost = host;
            this.viewid = viewid;
            this.viewclasses = new LinkedHashMap();
        }

        public Object[] getAllClasses() {
            return this.viewclasses.values().toArray();
        }

        public void addViewClasses(CIMClassData[] classes) {
            CIMClassData[] cIMClassDataArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                CIMClassData found;
                CIMClassData cimclass = cIMClassDataArray[n2];
                CIMClassData cIMClassData = found = CIMHost.this.isInheritanceView(this.viewid) ? CIMHost.this.findRoot(cimclass) : CIMHost.this.find(cimclass);
                if (found != null && !this.viewclasses.containsKey(found.getCIMClassName())) {
                    this.viewclasses.put(found.getClassName(), found);
                }
                ++n2;
            }
        }

        public void addViewClasses(Map<String, CIMClassData> classes) {
            this.viewclasses.putAll(classes);
        }

        public void remove(CIMClassData[] classes) {
            if (classes != null && classes.length > 0) {
                CIMClassData[] cIMClassDataArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    CIMClassData cimclass = cIMClassDataArray[n2];
                    Iterator<CIMClassData> it = this.viewclasses.values().iterator();
                    while (it.hasNext()) {
                        if (it.next() != cimclass) continue;
                        it.remove();
                        break;
                    }
                    ++n2;
                }
            }
        }

        public void removeAll() {
            this.viewclasses.clear();
        }

        public void restoreClasses() {
            if (this.viewclasses.size() == 0) {
                return;
            }
            LinkedHashMap<String, CIMClassData> newclasses = new LinkedHashMap<String, CIMClassData>();
            for (String key : this.viewclasses.keySet()) {
                CIMClassData orgclass = this.viewclasses.get(key);
                CIMClassData newelement = this.cimhost.findRoot(orgclass);
                if (newelement != null && newelement instanceof CIMClassData) {
                    newclasses.put(key, newelement);
                    continue;
                }
                System.err.println("[ERROR] failed to find a class " + orgclass.getCIMClassName());
            }
            this.viewclasses = newclasses;
        }
    }
}

