/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.ui.cimbrowser;

import com.vmware.vide.cimtools.CIMToolsPlugin;
import com.vmware.vide.cimtools.core.cimbrowser.CIMBrowserEngine;
import com.vmware.vide.cimtools.core.cimclient.EnumCIMClassNames;
import com.vmware.vide.cimtools.core.cimclient.EnumCIMClasses;
import com.vmware.vide.cimtools.core.cimclient.EnumCIMInstanceNames;
import com.vmware.vide.cimtools.core.cimclient.EnumCIMInstances;
import com.vmware.vide.cimtools.core.cimclient.GetCIMClass;
import com.vmware.vide.cimtools.core.cimcore.CIMClassData;
import com.vmware.vide.cimtools.core.cimcore.CIMHost;
import com.vmware.vide.cimtools.core.cimcore.CIMInstanceData;
import com.vmware.vide.cimtools.core.cimcore.CIMTreeData;
import com.vmware.vide.cimtools.ui.cimbrowser.AddHostWizard;
import com.vmware.vide.cimtools.ui.cimbrowser.SearchClassWizard;
import com.vmware.vide.cimtools.utils.CIMToolsException;
import com.vmware.vide.cimtools.utils.UtilDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.cim.CIMClass;
import javax.cim.CIMInstance;
import javax.cim.CIMObjectPath;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class WBEMOperationView
extends ViewPart {
    public static final String VIEWID_WBEMOPERATION = "com.vmware.vide.cimtools.wbemoperationview";
    public static final String KEY_CIMCLASSDATA = "CIMClassData";
    private static final String LABEL_CIMHOST = "CIM Host";
    private static final String LABEL_CIMCLASS = "CIM Class";
    private static final String LABEL_WBEM_OPERATION = "WBEM Operation";
    private static final String LABEL_DEEP = "Deep";
    private static final String LABEL_LOCAL_ONLY = "Local Only";
    private static final String LABEL_INCLUDE_QUALIFIERS = "Include Qualifiers";
    private static final String LABEL_INCLUDE_CLASS_ORIGIN = "Include Class Origin";
    private static final String BUTTON_CIMHOST = "  &Add a CIM Host  ";
    private static final String BUTTON_SEARCH = "&Search";
    private static final String BUTTON_EXECUTE = "    &Execute     ";
    private static final String WBEMOP_ENUMCLASSES = "enumerateClasses";
    private static final String WBEMOP_ENUMCLASSNAMES = "enumerateClassNames";
    private static final String WBEMOP_ENUMINSTANCES = "enumerateInstances";
    private static final String WBEMOP_ENUMINSTANCENAMES = "enumerateInstanceNames";
    private static final String WBEMOP_GETCLASS = "getClass";
    private static final String WBEMOPT_DEEP = "deep";
    private static final String WBEMOPT_LOCALONLY = "localonly";
    private static final String WBEMOPT_INCLUDE_QUALIFIERS = "includequalifiers";
    private static final String WBEMOPT_INCLUDE_CLASSORIGIN = "includeclassorigin";
    private static final String WBEMOPT_DEEP_INFO = "If true, the result contains the specified class and all subclasses";
    private static final String WBEMOPT_LOCALONLY_INFO = "If true, only elements defined in,or overridden in the class are included in the result. If false, all elements of the class definition are returned";
    private static final String WBEMOPT_INCLUDE_QUALIFIERS_INFO = "If true, all qualifiers for each class and its elements are present in the result";
    private static final String WBEMOPT_INCLUDE_CLASSORIGIN_INFO = "The class origin attribute is the name of the class that first defined the property or method. If true, the class origin attribute will be present for each property and method on all returned CIMClasses. If false, the class origin will not be present.";
    private static final String TOOLTIP_ADDCIMHOST = "Add a new CIM Host";
    private static final String TOOLTIP_REFRESH = "Refresh CIM classes in the selected CIM Host";
    private static final String TOOLTIP_SEARCH = "Search a CIM class in the selected CIM Host";
    private static final String TOOLTIP_WBEMOPTEXT = "Select a WBEM operation to execute";
    private static final String TOOLTIP_EXECUTE = "Execute the selected WBEM operation";
    private CIMHost currentcimhost;
    private CIMClassData currentcimclass;
    private TreeViewer resultviewer;
    private Tree resulttree;
    private Combo cimhostcombo;
    private Combo wbemopcombo;
    private Text cimclasstext;
    private Button cimclassbtn;
    private Button execbtn;
    private Button cimhostrefreshbtn;
    private Button deepbtn;
    private Button localonlybtn;
    private Button incqualifiersbtn;
    private Button incclassoriginbtn;
    private Map<String, WBEMOperation> wbemoperations;
    private Map<String, Control[]> wbemoptions;

    public WBEMOperationView() {
        this.initializeWBEMOperations();
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createInputUI(composite);
        this.createExecuteUI(composite);
        this.createOutputUI(composite);
        this.cimclassbtn.setEnabled(false);
        this.initializeWBEMOptions();
    }

    public void setFocus() {
        this.resultviewer.getControl().setFocus();
    }

    public void refresh(boolean enableexecbtn) {
        String currenthost = this.cimhostcombo.getText();
        this.cimhostcombo.setItems(CIMBrowserEngine.getDefault().getAllCIMHostnames());
        if (!currenthost.isEmpty()) {
            this.cimhostcombo.setText(currenthost);
        }
        if (enableexecbtn) {
            this.execbtn.setEnabled(true);
        }
        this.resultviewer.refresh();
    }

    private void initializeWBEMOperations() {
        this.wbemoperations = new LinkedHashMap<String, WBEMOperation>();
        this.wbemoperations.put(WBEMOP_ENUMCLASSES, new EnumClassOperation());
        this.wbemoperations.put(WBEMOP_ENUMCLASSNAMES, new EnumClassNamesOperation());
        this.wbemoperations.put(WBEMOP_ENUMINSTANCES, new EnumInstancesOperation());
        this.wbemoperations.put(WBEMOP_ENUMINSTANCENAMES, new EnumInstanceNamesOperation());
        this.wbemoperations.put(WBEMOP_GETCLASS, new GetClassOperation());
    }

    private void initializeWBEMOptions() {
        this.wbemoptions = new LinkedHashMap<String, Control[]>();
        this.wbemoptions.put(WBEMOPT_DEEP, new Control[]{this.deepbtn});
        this.wbemoptions.put(WBEMOPT_LOCALONLY, new Control[]{this.localonlybtn});
        this.wbemoptions.put(WBEMOPT_INCLUDE_QUALIFIERS, new Control[]{this.incqualifiersbtn});
        this.wbemoptions.put(WBEMOPT_INCLUDE_CLASSORIGIN, new Control[]{this.incclassoriginbtn});
    }

    private void createInputUI(Composite parent) {
        Composite inputcomposite = new Composite(parent, 0);
        inputcomposite.setLayout((Layout)new GridLayout(4, false));
        inputcomposite.setLayoutData((Object)new GridData(768));
        Label cimhostlabel = new Label(inputcomposite, 8);
        cimhostlabel.setText(LABEL_CIMHOST);
        cimhostlabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.cimhostcombo = new Combo(inputcomposite, 2056);
        this.cimhostcombo.setData("name", (Object)"CIMHostList");
        this.cimhostcombo.setLayoutData((Object)new GridData(4, 0, true, true));
        this.cimhostcombo.setItems(CIMBrowserEngine.getDefault().getAllCIMHostnames());
        this.cimhostcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperationView.this.refreshCIMHostInfo();
            }
        });
        this.cimhostcombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WBEMOperationView.this.refreshCIMHostInfo();
            }
        });
        Button cimhostbtn = new Button(inputcomposite, 8);
        cimhostbtn.setLayoutData((Object)new GridData(4, 0, false, false));
        cimhostbtn.setText(BUTTON_CIMHOST);
        cimhostbtn.setToolTipText(TOOLTIP_ADDCIMHOST);
        cimhostbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperationView.this.openAddCIMHostWizard();
                WBEMOperationView.this.refreshExecuteButton();
            }
        });
        this.cimhostrefreshbtn = new Button(inputcomposite, 8);
        this.cimhostrefreshbtn.setLayoutData((Object)new GridData(4, 0, false, false));
        this.cimhostrefreshbtn.setImage(CIMToolsPlugin.getDefault().getImage("refresh.png"));
        this.cimhostrefreshbtn.setToolTipText(TOOLTIP_REFRESH);
        this.cimhostrefreshbtn.setEnabled(false);
        this.cimhostrefreshbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperationView.this.restoreSelectedCIMHostInfo();
            }
        });
        Label cimclasslabel = new Label(inputcomposite, 8);
        cimclasslabel.setText(LABEL_CIMCLASS);
        cimclasslabel.setData("name", (Object)"ClassNameLabel");
        cimclasslabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.cimclasstext = new Text(inputcomposite, 2048);
        this.cimclasstext.setData("name", (Object)"ClassNameList");
        this.cimclasstext.setLayoutData((Object)new GridData(4, 0, true, true));
        this.cimclasstext.setText("");
        this.cimclasstext.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WBEMOperationView.this.refreshExecuteButton();
            }
        });
        this.cimclassbtn = new Button(inputcomposite, 8);
        this.cimclassbtn.setLayoutData((Object)new GridData(4, 0, false, false, 2, 1));
        this.cimclassbtn.setText(BUTTON_SEARCH);
        this.cimclassbtn.setToolTipText(TOOLTIP_SEARCH);
        this.cimclassbtn.addSelectionListener(this.getSearchSelectionListener(this.cimclasstext));
        Label wbemoplabel = new Label(inputcomposite, 8);
        wbemoplabel.setText(LABEL_WBEM_OPERATION);
        wbemoplabel.setData("name", (Object)"WBEMOperationLabel");
        wbemoplabel.setLayoutData((Object)new GridData(0, 0, false, false));
        this.wbemopcombo = new Combo(inputcomposite, 2056);
        this.wbemopcombo.setData("name", (Object)"WBEMOperationList");
        this.wbemopcombo.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.wbemopcombo.setItems(this.wbemoperations.keySet().toArray(new String[this.wbemoperations.size()]));
        this.wbemopcombo.setToolTipText(TOOLTIP_WBEMOPTEXT);
        this.wbemopcombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperationView.this.updateUIOptionsOfWBEMOperation();
                WBEMOperationView.this.refreshExecuteButton();
            }
        });
        Composite emptycomposite = new Composite(inputcomposite, 0);
        emptycomposite.setLayout((Layout)new GridLayout(1, false));
        emptycomposite.setLayoutData((Object)new GridData());
        Composite optioncomposite = new Composite(inputcomposite, 0);
        optioncomposite.setLayout((Layout)new GridLayout(1, false));
        optioncomposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createCheckOptionUI(optioncomposite);
    }

    private void createCheckOptionUI(Composite parent) {
        Composite optioncomposite = new Composite(parent, 0);
        optioncomposite.setLayout((Layout)new GridLayout(4, false));
        optioncomposite.setLayoutData((Object)new GridData(768));
        this.deepbtn = new Button(optioncomposite, 32);
        this.deepbtn.setLayoutData((Object)new GridData(4, 4, true, true));
        this.deepbtn.setText(LABEL_DEEP);
        this.deepbtn.setToolTipText(WBEMOPT_DEEP_INFO);
        this.deepbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                if (op != null) {
                    op.options.put(WBEMOperationView.WBEMOPT_DEEP, WBEMOperationView.this.deepbtn.getSelection());
                }
            }
        });
        this.localonlybtn = new Button(optioncomposite, 32);
        this.localonlybtn.setLayoutData((Object)new GridData(4, 4, true, true));
        this.localonlybtn.setText(LABEL_LOCAL_ONLY);
        this.localonlybtn.setToolTipText(WBEMOPT_LOCALONLY_INFO);
        this.localonlybtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                if (op != null) {
                    op.options.put(WBEMOperationView.WBEMOPT_LOCALONLY, WBEMOperationView.this.localonlybtn.getSelection());
                }
            }
        });
        this.incqualifiersbtn = new Button(optioncomposite, 32);
        this.incqualifiersbtn.setLayoutData((Object)new GridData(4, 4, true, true));
        this.incqualifiersbtn.setText(LABEL_INCLUDE_QUALIFIERS);
        this.incqualifiersbtn.setToolTipText(WBEMOPT_INCLUDE_QUALIFIERS_INFO);
        this.incqualifiersbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                if (op != null) {
                    op.options.put(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS, WBEMOperationView.this.incqualifiersbtn.getSelection());
                }
            }
        });
        this.incclassoriginbtn = new Button(optioncomposite, 32);
        this.incclassoriginbtn.setLayoutData((Object)new GridData(4, 4, true, true));
        this.incclassoriginbtn.setText(LABEL_INCLUDE_CLASS_ORIGIN);
        this.incclassoriginbtn.setToolTipText(WBEMOPT_INCLUDE_CLASSORIGIN_INFO);
        this.incclassoriginbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                if (op != null) {
                    op.options.put(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN, WBEMOperationView.this.incclassoriginbtn.getSelection());
                }
            }
        });
    }

    private void createExecuteUI(Composite parent) {
        Composite execcomposite = new Composite(parent, 0);
        execcomposite.setLayout((Layout)new GridLayout(1, false));
        execcomposite.setLayoutData((Object)new GridData(128));
        this.execbtn = new Button(execcomposite, 0);
        this.execbtn.setLayoutData((Object)new GridData(4, 0, false, false));
        this.execbtn.setText(BUTTON_EXECUTE);
        this.execbtn.setToolTipText(TOOLTIP_EXECUTE);
        this.execbtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                String classname = WBEMOperationView.this.cimclasstext.getText();
                if (classname == null || classname.isEmpty()) {
                    op.setWBEMOperationError("No class name specified");
                    return;
                }
                if (WBEMOperationView.this.currentcimclass == null || !classname.equals(WBEMOperationView.this.currentcimclass.getCIMClassName())) {
                    WBEMOperationView.this.currentcimclass = WBEMOperationView.this.currentcimhost.find(classname);
                }
                if (WBEMOperationView.this.currentcimclass == null) {
                    op.setWBEMOperationError("CIM class not found");
                    return;
                }
                if (op != null) {
                    WBEMOperationView.this.execbtn.setEnabled(false);
                    op.execute(WBEMOperationView.this.currentcimhost, WBEMOperationView.this.currentcimclass);
                }
            }
        });
    }

    private void createOutputUI(Composite parent) {
        Composite outputcomposite = new Composite(parent, 0);
        outputcomposite.setLayout((Layout)new GridLayout(1, false));
        outputcomposite.setLayoutData((Object)new GridData(1808));
        Composite treecomposite = new Composite(outputcomposite, 0);
        treecomposite.setLayout((Layout)new GridLayout());
        treecomposite.setLayoutData((Object)new GridData(1808));
        this.resulttree = new Tree(treecomposite, 2816);
        this.resulttree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeColumn colname = new TreeColumn(this.resulttree, 16384);
        colname.setAlignment(16384);
        colname.setText("Information");
        colname.setWidth(400);
        TreeColumn coltype = new TreeColumn(this.resulttree, 131072);
        coltype.setAlignment(16384);
        coltype.setText("Type");
        coltype.setWidth(60);
        TreeColumn colvalue = new TreeColumn(this.resulttree, 131072);
        colvalue.setAlignment(16384);
        colvalue.setText("Value");
        colvalue.setWidth(200);
        this.resulttree.setHeaderVisible(true);
        this.resulttree.setLinesVisible(true);
        this.resultviewer = new TreeViewer(this.resulttree);
        this.resultviewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int colindex) {
                if (element instanceof CIMTreeData) {
                    return ((CIMTreeData)element).getColumnImage(colindex);
                }
                return null;
            }

            public String getColumnText(Object element, int colindex) {
                if (element instanceof CIMTreeData) {
                    return ((CIMTreeData)element).getColumnText(colindex);
                }
                return element != null && colindex == 0 ? element.toString() : null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.resultviewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object obj) {
                WBEMOperation op = (WBEMOperation)WBEMOperationView.this.wbemoperations.get(WBEMOperationView.this.wbemopcombo.getText());
                return op == null ? new Object[]{} : op.getChildren();
            }

            public Object[] getChildren(Object element) {
                if (element instanceof WBEMOperation) {
                    return ((WBEMOperation)element).getChildren();
                }
                if (element instanceof CIMTreeData) {
                    return ((CIMTreeData)element).getChildren(WBEMOperationView.VIEWID_WBEMOPERATION, 2);
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof CIMTreeData) {
                    return ((CIMTreeData)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof CIMTreeData) {
                    return ((CIMTreeData)element).hasChildren(WBEMOperationView.VIEWID_WBEMOPERATION, 0);
                }
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.resultviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                Object[] selitems = null;
                if (selection instanceof IStructuredSelection) {
                    selitems = ((IStructuredSelection)selection).toArray();
                }
                if (selitems != null && selitems.length == 1 && selitems[0] instanceof CIMTreeData) {
                    CIMTreeData treedata = (CIMTreeData)selitems[0];
                    UtilDialog.openDialog(WBEMOperationView.LABEL_WBEM_OPERATION, treedata.getText(), 2, null, treedata.getCIMInfo());
                }
            }
        });
        this.resultviewer.setInput((Object)this);
    }

    private SelectionListener getSearchSelectionListener(final Text text) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WBEMOperationView.this.openSearchWizard(text);
                Object cls = text.getData(WBEMOperationView.KEY_CIMCLASSDATA);
                if (cls != null && cls instanceof CIMClassData) {
                    WBEMOperationView.this.currentcimclass = (CIMClassData)cls;
                }
                WBEMOperationView.this.refreshExecuteButton();
            }
        };
    }

    private void refreshCIMHostInfo() {
        String cimhostname = this.cimhostcombo.getText();
        if (cimhostname == null || cimhostname.isEmpty()) {
            this.cimclassbtn.setEnabled(false);
            return;
        }
        this.currentcimhost = CIMBrowserEngine.getDefault().findCIMHost(cimhostname);
        this.cimclassbtn.setEnabled(this.currentcimhost != null);
        this.cimhostrefreshbtn.setEnabled(this.currentcimhost != null);
    }

    private void refreshExecuteButton() {
        this.execbtn.setEnabled(this.currentcimhost != null && !this.cimclasstext.getText().isEmpty() && !this.wbemopcombo.getText().isEmpty());
    }

    private void openAddCIMHostWizard() {
        AddHostWizard wizard = new AddHostWizard(VIEWID_WBEMOPERATION);
        wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        dialog.open();
    }

    private void openSearchWizard(Text text) {
        CIMClassData classdata;
        if (text == null || this.currentcimhost == null) {
            return;
        }
        SearchClassWizard wizard = new SearchClassWizard(this.currentcimhost, text.getText());
        wizard.init(this.getSite().getWorkbenchWindow().getWorkbench(), null);
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (classdata = wizard.getSelectedCIMClass()) != null) {
            text.setText(classdata.getCIMClassName());
            text.setData(KEY_CIMCLASSDATA, (Object)classdata);
        }
    }

    private void updateUIOptionsOfWBEMOperation() {
        WBEMOperation op = this.wbemoperations.get(this.wbemopcombo.getText());
        if (op == null) {
            return;
        }
        for (String option : this.wbemoptions.keySet()) {
            Object value;
            boolean enabled = op.options.containsKey(option);
            Control[] controls = this.wbemoptions.get(option);
            Button checkbox = null;
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control != null && !control.isDisposed()) {
                    control.setEnabled(enabled);
                    if (control instanceof Button) {
                        checkbox = (Button)control;
                    }
                }
                ++n2;
            }
            if (!enabled || !((value = op.options.get(option)) instanceof Boolean) || checkbox == null) continue;
            checkbox.setSelection(((Boolean)value).booleanValue());
        }
    }

    private void restoreSelectedCIMHostInfo() {
        if (this.currentcimhost == null) {
            return;
        }
        try {
            this.currentcimhost.restoreAll();
        }
        catch (CIMToolsException e) {
            UtilDialog.openDialog(e);
        }
    }

    public static void refreshView(boolean openview) throws Exception {
        WBEMOperationView.refreshView(openview, false);
    }

    private static void refreshView(final boolean openview, final boolean enableexecbtn) throws Exception {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
                    IWorkbenchPage page = wbWindow.getActivePage();
                    if (page == null) {
                        return;
                    }
                    IViewPart view = page.getActivePart().getSite().getPage().findView(WBEMOperationView.VIEWID_WBEMOPERATION);
                    if (view == null && openview) {
                        view = page.showView(WBEMOperationView.VIEWID_WBEMOPERATION);
                    }
                    if (view != null) {
                        WBEMOperationView wbemview = (WBEMOperationView)view;
                        wbemview.refresh(enableexecbtn);
                        if (openview) {
                            page.activate((IWorkbenchPart)wbemview);
                            wbemview.setFocus();
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                }
            }
        });
    }

    private class EnumClassNamesOperation
    extends WBEMOperation {
        public EnumClassNamesOperation() {
            super(WBEMOperationView.WBEMOP_ENUMCLASSNAMES);
            this.options.put(WBEMOperationView.WBEMOPT_DEEP, true);
        }

        @Override
        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            if (cimhost == null || cimclass == null) {
                this.setWBEMOperationError("Insufficient information for WBEM operation");
                return;
            }
            EnumCIMClassNames job = new EnumCIMClassNames(cimhost, cimclass.getObjectPath(), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_DEEP));
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMClassNames) {
                            EnumCIMClassNames resultjob = (EnumCIMClassNames)event.getJob();
                            if (event.getResult().isOK()) {
                                List<CIMObjectPath> results = resultjob.getWBEMResult();
                                if (results.size() > 0) {
                                    EnumClassNamesOperation.this.setWBEMOperationResults(EnumClassNamesOperation.this.convertCIMClassObjectPath(results));
                                } else {
                                    EnumClassNamesOperation.this.setWBEMOperationWarning("CIM Class not found");
                                }
                            } else {
                                EnumClassNamesOperation.this.setWBEMOperationError(resultjob.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        EnumClassNamesOperation.this.setWBEMOperationError(e);
                    }
                }
            });
            job.schedule();
        }
    }

    private class EnumClassOperation
    extends WBEMOperation {
        public EnumClassOperation() {
            super(WBEMOperationView.WBEMOP_ENUMCLASSES);
            this.options.put(WBEMOperationView.WBEMOPT_DEEP, true);
            this.options.put(WBEMOperationView.WBEMOPT_LOCALONLY, false);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS, true);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN, false);
        }

        @Override
        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            if (cimhost == null || cimclass == null) {
                this.setWBEMOperationError("Insufficient information for WBEM operation");
                return;
            }
            EnumCIMClasses job = new EnumCIMClasses(cimhost, cimclass.getObjectPath(), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_DEEP), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_LOCALONLY), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN), false);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMClasses) {
                            EnumCIMClasses resultjob = (EnumCIMClasses)event.getJob();
                            if (event.getResult().isOK()) {
                                List<CIMClass> results = resultjob.getWBEMResult();
                                if (results.size() > 0) {
                                    EnumClassOperation.this.setWBEMOperationResults(EnumClassOperation.this.convertCIMClasses(results));
                                } else {
                                    EnumClassOperation.this.setWBEMOperationWarning("CIM Class not found");
                                }
                            } else {
                                EnumClassOperation.this.setWBEMOperationError(resultjob.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        EnumClassOperation.this.setWBEMOperationError(e);
                    }
                }
            });
            job.schedule();
        }
    }

    private class EnumInstanceNamesOperation
    extends WBEMOperation {
        public EnumInstanceNamesOperation() {
            super(WBEMOperationView.WBEMOP_ENUMINSTANCENAMES);
        }

        @Override
        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            if (cimhost == null || cimclass == null) {
                this.setWBEMOperationError("Insufficient information for WBEM operation");
                return;
            }
            EnumCIMInstanceNames job = new EnumCIMInstanceNames(cimhost, cimclass.getObjectPath());
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMInstanceNames) {
                            EnumCIMInstanceNames resultjob = (EnumCIMInstanceNames)event.getJob();
                            if (event.getResult().isOK()) {
                                List<CIMInstance> results = resultjob.getWBEMResult();
                                if (results.size() > 0) {
                                    EnumInstanceNamesOperation.this.setWBEMOperationResults(EnumInstanceNamesOperation.this.convertCIMInstances(results));
                                } else {
                                    EnumInstanceNamesOperation.this.setWBEMOperationWarning("CIM instance not found");
                                }
                            } else {
                                EnumInstanceNamesOperation.this.setWBEMOperationError(resultjob.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        EnumInstanceNamesOperation.this.setWBEMOperationError(e);
                    }
                }
            });
            job.schedule();
        }
    }

    private class EnumInstancesOperation
    extends WBEMOperation {
        public EnumInstancesOperation() {
            super(WBEMOperationView.WBEMOP_ENUMINSTANCES);
            this.options.put(WBEMOperationView.WBEMOPT_DEEP, true);
            this.options.put(WBEMOperationView.WBEMOPT_LOCALONLY, false);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS, true);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN, true);
        }

        @Override
        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            if (cimhost == null || cimclass == null) {
                this.setWBEMOperationError("Insufficient information for WBEM operation");
                return;
            }
            EnumCIMInstances job = new EnumCIMInstances(cimhost, cimclass.getObjectPath(), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_DEEP), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_LOCALONLY), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN), null);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof EnumCIMInstances) {
                            EnumCIMInstances resultjob = (EnumCIMInstances)event.getJob();
                            if (event.getResult().isOK()) {
                                ArrayList<CIMInstance> results = resultjob.getWBEMResult();
                                if (results.size() > 0) {
                                    EnumInstancesOperation.this.setWBEMOperationResults(EnumInstancesOperation.this.convertCIMInstances(results));
                                } else {
                                    EnumInstancesOperation.this.setWBEMOperationWarning("CIM instance not found");
                                }
                            } else {
                                EnumInstancesOperation.this.setWBEMOperationError(resultjob.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        EnumInstancesOperation.this.setWBEMOperationError(e);
                    }
                }
            });
            job.schedule();
        }
    }

    private class GetClassOperation
    extends WBEMOperation {
        public GetClassOperation() {
            super(WBEMOperationView.WBEMOP_GETCLASS);
            this.options.put(WBEMOperationView.WBEMOPT_DEEP, true);
            this.options.put(WBEMOperationView.WBEMOPT_LOCALONLY, false);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS, true);
            this.options.put(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN, true);
        }

        @Override
        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            if (cimhost == null || cimclass == null) {
                this.setWBEMOperationError("Insufficient information for WBEM operation");
                return;
            }
            GetCIMClass job = new GetCIMClass(cimhost, cimclass.getObjectPath(), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_DEEP), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_INCLUDE_QUALIFIERS), this.getBooleanOptionValue(WBEMOperationView.WBEMOPT_INCLUDE_CLASSORIGIN));
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    try {
                        if (event.getJob() instanceof GetCIMClass) {
                            GetCIMClass resultjob = (GetCIMClass)event.getJob();
                            if (event.getResult().isOK()) {
                                CIMClassData result = resultjob.getWBEMResult();
                                if (result != null) {
                                    GetClassOperation.this.setWBEMOperationResults(new Object[]{result});
                                } else {
                                    GetClassOperation.this.setWBEMOperationWarning("CIM Class not found");
                                }
                            } else {
                                GetClassOperation.this.setWBEMOperationError(resultjob.getException());
                            }
                        }
                    }
                    catch (Exception e) {
                        GetClassOperation.this.setWBEMOperationError(e);
                    }
                }
            });
            job.schedule();
        }
    }

    private abstract class WBEMOperation {
        protected static final String ERROR_INSUFFICIENT_INFO = "Insufficient information for WBEM operation";
        protected static final String WARNING_NO_CIMCLASS = "CIM Class not found";
        protected static final String WARNING_NO_CIMINSTANCE = "CIM instance not found";
        public String wbemoptype;
        protected Map<String, Object> options;
        private Object[] wbemopresults;

        public WBEMOperation(String type) {
            this.wbemoptype = type;
            this.options = new HashMap<String, Object>();
        }

        public Object[] getChildren() {
            return this.wbemopresults;
        }

        public void execute(CIMHost cimhost, CIMClassData cimclass) {
            this.setWBEMOperationError(String.valueOf(this.wbemoptype) + " is not supported yet ");
        }

        public boolean getBooleanOptionValue(String key) {
            Object value;
            if (this.options.containsKey(key) && (value = this.options.get(key)) != null && value instanceof Boolean) {
                return (Boolean)value;
            }
            return false;
        }

        public void setWBEMOperationResults(Object[] results) {
            this.wbemopresults = results;
            try {
                WBEMOperationView.refreshView(false, true);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }

        public void setWBEMOperationError(Exception e) {
            this.setWBEMOperationError(e.getMessage());
        }

        public void setWBEMOperationError(String errormsg) {
            this.setWBEMOperationResults(new CIMTreeData[]{CIMTreeData.getErrorMesgTreeData(errormsg)});
        }

        public void setWBEMOperationWarning(String warningmsg) {
            this.setWBEMOperationResults(new CIMTreeData[]{CIMTreeData.getWraningMsgTreeData(warningmsg)});
        }

        protected final Object[] convertCIMInstances(List<CIMInstance> results) {
            ArrayList<CIMInstanceData> instances = new ArrayList<CIMInstanceData>();
            for (CIMInstance inst : results) {
                CIMInstanceData instdata = new CIMInstanceData((CIMTreeData)WBEMOperationView.this.currentcimclass, WBEMOperationView.this.currentcimclass, inst);
                if (!instdata.isValid()) continue;
                instances.add(instdata);
            }
            return instances.toArray();
        }

        protected final Object[] convertCIMClasses(List<CIMClass> results) {
            ArrayList<CIMClassData> classes = new ArrayList<CIMClassData>();
            for (CIMClass cimclass : results) {
                CIMClassData classdata = CIMClassData.createCIMClassData(WBEMOperationView.this.currentcimhost, cimclass);
                if (!classdata.isValid()) continue;
                classes.add(classdata);
            }
            return classes.toArray();
        }

        protected final Object[] convertCIMClassObjectPath(List<CIMObjectPath> results) {
            ArrayList<CIMClassData> classes = new ArrayList<CIMClassData>();
            for (CIMObjectPath objectpath : results) {
                CIMClassData classdata = CIMClassData.createCIMClassData(WBEMOperationView.this.currentcimhost, new CIMClass(objectpath, null, null, null, null, false, false));
                if (!classdata.isValid()) continue;
                classes.add(classdata);
            }
            return classes.toArray();
        }
    }
}

